/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import javax.swing.JComponent;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.component.IValidator;
import jeus.tool.xmlui.component.NumberValidator;
import jeus.tool.xmlui.component.StringValidator;
import jeus.tool.xmlui.schema.XMLUIElement;

public abstract class XMLUIComponent
extends XMLUIPanel {
    protected String itemType = "string";
    protected String defaultValue = "";
    protected IValidator validator;
    protected boolean required;

    public void setConstraints(XMLUIElement element) {
        try {
            NumberValidator nvalidator = new NumberValidator();
            nvalidator.setValueType(this.itemType);
            String min = element.getMinInclusive();
            String max = element.getMaxInclusive();
            if (min != null && min.trim().length() > 0) {
                nvalidator.setMinimum(Double.valueOf(min));
            }
            if (max != null && max.trim().length() > 0) {
                nvalidator.setMaximum(Double.valueOf(max));
            }
            nvalidator.setRequired(element.getMinOccurs() > 0);
            if (element.getPattern() != null && element.getPattern().trim().length() > 0) {
                nvalidator.setPattern(element.getPattern());
            }
            this.validator = nvalidator;
        }
        catch (RuntimeException e) {
            StringValidator svalidator = new StringValidator();
            int min = element.getMinLength();
            int max = element.getMaxLength();
            svalidator.setMinimumLength(min);
            svalidator.setMaximumLength(max);
            svalidator.setFixedLength(element.getLength());
            if (element.getPattern() != null && element.getPattern().trim().length() > 0) {
                svalidator.setPattern(element.getPattern());
            }
            svalidator.setRequired(element.getMinOccurs() > 0);
            this.validator = svalidator;
        }
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getItemType() {
        return this.itemType;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public abstract void setEnabled(boolean var1);

    public abstract JComponent getItemComp();

    public abstract void resetValue();

    public void init() {
    }

    protected XMLUIPanel[] getChildConfigPanels() {
        return new XMLUIPanel[0];
    }

    public void setType(String itemType) {
        this.itemType = itemType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getType() {
        return this.itemType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

