/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jeus.tool.xmlui.component.ValidationException;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class XMLUIQName
extends XMLUIComponent {
    JPanel qnamePanel = new JPanel();
    JLabel namespaceURILabel = new JLabel("namespaceURI");
    JLabel prefixLabel = new JLabel("prefix");
    JLabel localPartLabel = new JLabel("local-part");
    JTextField namespaceURI = new JTextField();
    JTextField prefix = new JTextField();
    JTextField localPart = new JTextField();

    public XMLUIQName() {
        this.qnamePanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.qnamePanel.add((Component)this.namespaceURILabel, cons);
        cons.gridx = 1;
        cons.weightx = 1.0;
        cons.fill = 2;
        this.qnamePanel.add((Component)this.namespaceURI, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.qnamePanel.add((Component)this.prefixLabel, cons);
        cons.gridx = 1;
        cons.weightx = 1.0;
        cons.fill = 2;
        this.qnamePanel.add((Component)this.prefix, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.qnamePanel.add((Component)this.localPartLabel, cons);
        cons.gridx = 1;
        cons.weightx = 1.0;
        cons.fill = 2;
        this.qnamePanel.add((Component)this.localPart, cons);
        this.setLayout(new BorderLayout());
        this.add((Component)this.qnamePanel, "Center");
    }

    public JComponent getItemComp() {
        return this.qnamePanel;
    }

    public void resetValue() {
        this.namespaceURI.setText("");
        this.prefix.setText("");
        this.localPart.setText("");
    }

    public void setEnabled(boolean enabled) {
        this.qnamePanel.setEnabled(enabled);
        Component[] comps = this.qnamePanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(enabled);
        }
    }

    public Object getValue() {
        String l;
        String p;
        this.clearMessage();
        String n = this.namespaceURI.getText();
        if (n != null && n.trim().length() == 0) {
            n = null;
        }
        if ((p = this.prefix.getText()) != null && p.trim().length() == 0) {
            p = null;
        }
        if ((l = this.localPart.getText()) != null && l.trim().length() == 0) {
            l = null;
        }
        if (l != null && n == null) {
            this.addMessage("namespaceURI for @XPATH@ must be.");
            return null;
        }
        if (this.getValidator() != null) {
            try {
                this.getValidator().validate(this.getName(), l);
            }
            catch (ValidationException e) {
                this.addMessage(e.getMessage());
                return null;
            }
        }
        if (l != null) {
            return XMLUtil.createQName(this.getSession().getDocument(), n, p, this.getName(), l);
        }
        return null;
    }

    public void setValue(Object val) {
        Element node = (Element)val;
        String l = XMLUtil.getValue(node);
        String p = null;
        int c = l.indexOf(58);
        if (c > 0) {
            p = l.substring(0, c);
            l = l.substring(c + 1);
        }
        String n = node.getAttribute("xmlns" + (p == null ? "" : ":" + p));
        this.namespaceURI.setText(n);
        this.prefix.setText(p);
        this.localPart.setText(l);
    }
}

