/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jeus.tool.xmlui.component.XMLUITextField;
import jeus.tool.xmlui.engine.ChangeHistory;
import jeus.tool.xmlui.util.MessageUtil;

public class XMLUIReferredTextField
extends XMLUITextField {
    public static final String SYMBOLS = "jeus.tool.xmlui.symbols";
    private String targetXpath;

    public void init() {
        super.init();
        this.addSymbol(this.getName(), null);
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.addSymbol(this.getName(), this.value);
    }

    public Object getValue() {
        Object result = super.getValue();
        Boolean addMode = (Boolean)this.getSession().getAttribute("xmlui.add");
        if (addMode == null || !addMode.booleanValue()) {
            if (this.isChanged()) {
                this.updateTarget();
            }
            this.addSymbol(this.getName(), this.value);
        }
        return result;
    }

    protected void addSymbol(String key, String value) {
        HashMap<String, String> symbols = (HashMap<String, String>)super.getSession().getAttribute(SYMBOLS);
        if (symbols == null) {
            symbols = new HashMap<String, String>();
            this.getSession().addAttribute(SYMBOLS, symbols);
        }
        symbols.put(key, value);
    }

    protected String getSymbol(String key) {
        Map symbols = (Map)super.getSession().getAttribute(SYMBOLS);
        if (symbols != null) {
            return (String)symbols.get(key);
        }
        return null;
    }

    public String getTargetXpath() {
        return this.targetXpath;
    }

    public void setTargetXpath(String targetXpath) {
        this.targetXpath = MessageUtil.getMessage(this.getEngine(), "message:" + targetXpath, targetXpath);
    }

    protected void updateTarget() {
        ChangeHistory history = (ChangeHistory)this.getSession().getAttribute("jeus.tool.xmlui.history");
        if (history == null || this.targetXpath == null) {
            return;
        }
        StringTokenizer stk = new StringTokenizer(this.targetXpath, "$");
        StringBuffer buf = new StringBuffer();
        while (stk.hasMoreTokens()) {
            String key;
            String value;
            int i;
            String token = stk.nextToken();
            if (token.startsWith("{") && (i = token.indexOf(125)) > 0 && (value = this.getSymbol(key = token.substring(1, i))) != null) {
                token = value + token.substring(i + 1);
            }
            buf.append(token);
        }
        history.addChange(buf.toString(), this.value);
    }
}

