/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.engine;

import java.util.Hashtable;
import javax.swing.event.EventListenerList;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.OperationType;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUIEvent;
import jeus.tool.xmlui.engine.XMLUIListener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUISession {
    private XMLUIEngine engine;
    private Hashtable attrs;
    private EventListenerList lsnrlist = new EventListenerList();
    private Document doc;
    private boolean writeDefault;

    public XMLUISession(XMLUIEngine engine) {
        this.engine = engine;
        this.attrs = new Hashtable();
    }

    public void addAttribute(String name, Object obj) {
        this.attrs.put(name, obj);
    }

    public Object getAttribute(String name) {
        return this.attrs.get(name);
    }

    public void addXMLUIListener(XMLUIListener lsnr) {
        this.lsnrlist.add(XMLUIListener.class, lsnr);
    }

    public void removeXMLUIListener(XMLUIListener lsnr) {
        this.lsnrlist.remove(XMLUIListener.class, lsnr);
    }

    public void fireXMLUIEvent(XMLUIPanel source, Node node, OperationType op) {
        XMLUIEvent event = new XMLUIEvent(source, op, node);
        Object[] listeners = this.lsnrlist.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != XMLUIListener.class) continue;
            ((XMLUIListener)listeners[i + 1]).xmlChanged(event);
        }
        this.engine.fireXMLUIEvent(source, node, op);
    }

    public XMLUIEngine getEngine() {
        return this.engine;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public boolean isWriteDefault() {
        return this.writeDefault;
    }

    public void setWriteDefault(boolean writeDefault) {
        this.writeDefault = writeDefault;
    }
}

