/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.schema;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jeus.tool.xmlui.schema.XMLUIBase;

public class XMLUIElement
implements Serializable,
XMLUIBase,
Cloneable {
    public static final String ITEMTYPE_STRING = "string";
    public static final String ITEMTYPE_INT = "int";
    public static final String ITEMTYPE_LONG = "long";
    public static final String ITEMTYPE_FLOAT = "float";
    public static final String ITEMTYPE_DOUBLE = "double";
    public static final String ITEMTYPE_DATE = "date";
    public static final String ITEMTYPE_DATETIME = "dateTime";
    public static final String ITEMTYPE_BOOLEAN = "boolean";
    public static final String ITEMTYPE_CHOICE = "choice";
    public static final String ITEMTYPE_TEXTAREA = "textarea";
    public static final String ITEMTYPE_EDITABLE_CHOICE = "echoice";
    public static final String ITEMTYPE_EMPTY = "empty";
    public static final String ITEMTYPE_QNAME = "qname";
    public static final String ITEMTYPE_REFERRED = "referred";
    private String _name;
    private String _displayName;
    private String _multi = "false";
    private String _itemType = "String";
    private String _defaultValue;
    private String _required = "false";
    private Vector _candidateValueList;
    private String _xmlType = "element";
    private String _globalID;
    private String _description;
    private String _min;
    private String _max;
    private String _validator;
    private String _pattern;
    private String _elementUIClass;
    private String _readonly;
    private int minOccurs = 0;
    private int maxOccurs = 1;
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private String minInclusive;
    private String maxInclusive;
    private String minExclusive;
    private String maxExclusive;
    private int length = -1;
    private String pattern;
    private String _namespaceURI;

    public XMLUIElement() {
        this.setMulti("false");
        this.setItemType("String");
        this.setRequired("false");
        this._candidateValueList = new Vector();
    }

    public void addCandidateValue(String vCandidateValue) throws IndexOutOfBoundsException {
        this._candidateValueList.addElement(vCandidateValue);
    }

    public void addCandidateValue(int index, String vCandidateValue) throws IndexOutOfBoundsException {
        this._candidateValueList.insertElementAt(vCandidateValue, index);
    }

    public Enumeration enumerateCandidateValue() {
        return this._candidateValueList.elements();
    }

    public String getCandidateValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._candidateValueList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._candidateValueList.elementAt(index);
    }

    public String[] getCandidateValue() {
        int size = this._candidateValueList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._candidateValueList.elementAt(index);
        }
        return mArray;
    }

    public int getCandidateValueCount() {
        return this._candidateValueList.size();
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            this._displayName = this._name;
        }
        return this._displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public String getItemType() {
        return this._itemType;
    }

    public String getMulti() {
        if (this.maxOccurs > 1) {
            return "true";
        }
        return "false";
    }

    public String getName() {
        return this._name;
    }

    public String getRequired() {
        if (this.minOccurs == 1) {
            return "true";
        }
        return "false";
    }

    public String getXmlType() {
        return this._xmlType;
    }

    public String getGlobalID() {
        return this._globalID;
    }

    public void removeAllCandidateValue() {
        this._candidateValueList.removeAllElements();
    }

    public String removeCandidateValue(int index) {
        Object obj = this._candidateValueList.elementAt(index);
        this._candidateValueList.removeElementAt(index);
        return (String)obj;
    }

    public void setCandidateValue(int index, String vCandidateValue) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._candidateValueList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._candidateValueList.setElementAt(vCandidateValue, index);
    }

    public void setCandidateValue(String[] candidateValueArray) {
        this._candidateValueList.removeAllElements();
        for (int i = 0; i < candidateValueArray.length; ++i) {
            this._candidateValueList.addElement(candidateValueArray[i]);
        }
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public void setItemType(String itemType) {
        this._itemType = itemType;
    }

    public void setMulti(String multi) {
        this._multi = multi;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRequired(String required) {
        this._required = required;
    }

    public void setXmlType(String _xmlType) {
        this._xmlType = _xmlType;
    }

    public void setGlobalID(String val) {
        this._globalID = val;
    }

    public String getMax() {
        return this._max;
    }

    public void setMax(String _max) {
        this._max = _max;
    }

    public String getMin() {
        return this._min;
    }

    public void setMin(String _min) {
        this._min = _min;
    }

    public String getValidator() {
        return this._validator;
    }

    public void setValidator(String _validator) {
        this._validator = _validator;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Clone is not supported for ConfigItem");
        }
        return o;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String _pattern) {
        this._pattern = _pattern;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(String maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public String getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(String maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(String minExclusive) {
        this.minExclusive = minExclusive;
    }

    public String getMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(String minInclusive) {
        this.minInclusive = minInclusive;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setElementUIClass(String elementUIClass) {
        this._elementUIClass = elementUIClass;
    }

    public String getElementUIClass() {
        return this._elementUIClass;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this._namespaceURI = namespaceURI;
    }

    public String getReadonly() {
        return this._readonly;
    }

    public void setReadonly(String readonly) {
        this._readonly = readonly;
    }
}

