/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.deploy.archivist.AbstractArchive;
import jeus.service.descriptor.DescriptorFile;
import jeus.tool.builder.JEUSBuilder;
import jeus.xml.util.DomProcessor;
import jeus.xml.util.ElementOrderTable;
import jeus.xml.util.ElementOrderTableSource;
import jeus.xml.util.ElementSort;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtil {
    public static void replaceChildNodes(Element target, Element source) {
        Node child = target.getFirstChild();
        while (child != null) {
            Node oldChild = child;
            child = oldChild.getNextSibling();
            target.removeChild(oldChild);
        }
        child = source.getFirstChild();
        while (child != null) {
            Node newChild = child;
            child = newChild.getNextSibling();
            target.appendChild(newChild.cloneNode(true));
        }
    }

    public static boolean writeElement(Element element, OutputStream out) {
        if (element == null || out == null) {
            return false;
        }
        Document doc = element.getOwnerDocument();
        DomProcessor.serialize(doc, out);
        return true;
    }

    public static void writeDocument(Document document, OutputStream out, DescriptorFile descFile, ElementOrderTable t) throws Exception {
        if (document == null || out == null) {
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtil.writeDocument(document, bout);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        InputStream xin = descFile.getSchemaBasedStream(bin);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(xin);
        ElementSort.sort(document, t);
        XMLUtil.writeDocument(document, out);
    }

    public static void writeDocument(Document doc, OutputStream out) {
        DomProcessor.serialize(doc, out);
    }

    public static String getValue(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node first = node.getFirstChild();
                if (first == null || first.getNodeType() != 3) break;
                return first.getNodeValue();
            }
            case 2: {
                return node.getNodeValue();
            }
        }
        return node.getNodeValue();
    }

    public static void setValue(Node node, String value) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node first = node.getFirstChild();
                Text text = node.getOwnerDocument().createTextNode(value);
                if (first == null) {
                    node.appendChild(text);
                    break;
                }
                node.replaceChild(text, first);
                break;
            }
            case 2: {
                node.setNodeValue(value);
                break;
            }
        }
    }

    public static Element createQName(Document doc, String namespaceURI, String prefix, String name, String value) {
        Element element = XMLUtil.createElement(doc, name, (prefix == null ? "" : prefix + ":") + value);
        element.setAttribute("xmlns" + (prefix == null ? "" : ":" + prefix), namespaceURI);
        return element;
    }

    public static Element createElement(Document doc, String name, String value) {
        if (doc == null) {
            return null;
        }
        Element element = XMLUtil.createElement(doc, name);
        Text data = doc.createTextNode(value);
        element.appendChild(data);
        return element;
    }

    public static Element createElement(Document doc, String name) {
        if (doc == null) {
            return null;
        }
        Element docElement = doc.getDocumentElement();
        String namespaceURI = null;
        String prefix = null;
        if (docElement != null) {
            namespaceURI = docElement.getNamespaceURI();
            prefix = docElement.getPrefix();
        }
        Element element = null;
        element = namespaceURI != null ? doc.createElementNS(namespaceURI, (prefix == null ? "" : prefix + ":") + name) : doc.createElement(name);
        return element;
    }

    public static String unmarshall(Element element) {
        if (element == null) {
            return "";
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DomProcessor.serialize(element, bout);
        return bout.toString();
    }

    public static Vector getChildNodes(Element element) {
        if (element == null) {
            return new Vector();
        }
        NodeList list = element.getChildNodes();
        String namespaceURI = element.getNamespaceURI();
        Vector<Node> vct = new Vector<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || namespaceURI != null && !namespaceURI.equals(node.getNamespaceURI())) continue;
            vct.add(node);
        }
        return vct;
    }

    public static Vector getChildNodes(Element element, String name) {
        if (element == null) {
            return new Vector();
        }
        NodeList list = null;
        list = element.getNamespaceURI() == null ? element.getElementsByTagName(name) : element.getElementsByTagNameNS(element.getNamespaceURI(), name);
        Vector<Node> vct = new Vector<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            vct.add(list.item(i));
        }
        return vct;
    }

    public static String getName(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNamespaceURI() != null) {
            return node.getLocalName();
        }
        return node.getNodeName();
    }

    public static Hashtable getElementMapping(Element e) {
        if (e == null) {
            return new Hashtable();
        }
        Vector vct = XMLUtil.getChildNodes(e);
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vct.size(); ++i) {
            Element element = (Element)vct.get(i);
            String name = XMLUtil.getName(element);
            if (hashtable.containsKey(name)) {
                Object result = hashtable.get(name);
                ((Vector)result).add(element);
                continue;
            }
            Vector<Element> v = new Vector<Element>();
            v.add(element);
            hashtable.put(name, v);
        }
        return hashtable;
    }

    public static void appendChildNodes(Element element, Vector children) {
        if (element == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            element.appendChild((Node)children.get(i));
        }
    }

    public static Element getFirstElement(Element element, String name) {
        if (element == null) {
            return null;
        }
        Vector vct = XMLUtil.getChildNodes(element, name);
        if (vct.size() > 0) {
            return (Element)vct.get(0);
        }
        return null;
    }

    public static String getFirstElementValue(Element element, String name) {
        if (element == null) {
            return null;
        }
        if ((element = XMLUtil.getFirstElement(element, name)) == null) {
            return null;
        }
        return XMLUtil.getValue(element);
    }

    public static boolean hasChildren(Element element) {
        if (element == null) {
            return false;
        }
        return element.getChildNodes().getLength() > 0;
    }

    public static String getStandardDDFilePath(ModuleType moduleType) {
        String ddEntry = null;
        if (moduleType.equals(ModuleType.EAR)) {
            ddEntry = "META-INF/application.xml";
        } else if (moduleType.equals(ModuleType.EJB)) {
            ddEntry = "META-INF/ejb-jar.xml";
        } else if (moduleType.equals(ModuleType.WAR)) {
            ddEntry = "WEB-INF/web.xml";
        } else if (moduleType.equals(ModuleType.RAR)) {
            ddEntry = "META-INF/ra.xml";
        } else if (moduleType.equals(ModuleType.CAR)) {
            ddEntry = "META-INF/application-client.xml";
        }
        return ddEntry;
    }

    public static String getJeusDDFilePath(ModuleType moduleType) {
        String ddEntry = null;
        if (moduleType.equals(ModuleType.EAR)) {
            ddEntry = "META-INF/jeus-application-dd.xml";
        } else if (moduleType.equals(ModuleType.EJB)) {
            ddEntry = "META-INF/jeus-ejb-dd.xml";
        } else if (moduleType.equals(ModuleType.WAR)) {
            ddEntry = "WEB-INF/jeus-web-dd.xml";
        } else if (moduleType.equals(ModuleType.RAR)) {
            ddEntry = "META-INF/jeus-connector-dd.xml";
        } else if (moduleType.equals(ModuleType.CAR)) {
            ddEntry = "META-INF/jeus-client-dd.xml";
        }
        return ddEntry;
    }

    public static void validateStandardDDFile(AbstractArchive archive, ModuleType moduleType, ElementOrderTableSource elementOrderSrc) throws Exception {
        XMLUtil.validateDDFile(archive, XMLUtil.getStandardDDFilePath(moduleType), elementOrderSrc, "http://java.sun.com/xml/ns/j2ee");
    }

    public static void validateJeusDDFile(AbstractArchive archive, ModuleType moduleType, ElementOrderTableSource elementOrderSrc) throws Exception {
        XMLUtil.validateDDFile(archive, XMLUtil.getJeusDDFilePath(moduleType), elementOrderSrc, "http://www.tmaxsoft.com/xml/ns/jeus");
    }

    private static void validateDDFile(AbstractArchive archive, String ddEntry, ElementOrderTableSource elementOrderSrc, String namespaceUri) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ElementOrderTable t = null;
        InputStream is = archive.getEntry(ddEntry);
        if (is == null) {
            throw new FileNotFoundException("FileNotFound:" + ddEntry);
        }
        Document document = builder.parse(is);
        t = document.getDocumentElement().getNamespaceURI() == null ? elementOrderSrc.getElementOrderTable(document.getDocumentElement().getNodeName(), namespaceUri) : elementOrderSrc.getElementOrderTable(document);
        ElementSort.sort(document, t);
    }

    public static void validateDDFile(Document document, ElementOrderTable t) throws Exception {
        ElementSort.sort(document, t);
    }

    public static ElementOrderTable getElementOrderTable(Document document, String namespace) {
        ElementOrderTable t = null;
        t = document.getDocumentElement().getNamespaceURI() == null ? JEUSBuilder.tsrc.getElementOrderTable(document.getDocumentElement().getNodeName(), namespace) : JEUSBuilder.tsrc.getElementOrderTable(document);
        return t;
    }

    public static Element getDescriptorElement(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        return document.getDocumentElement();
    }
}

