/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.io.DataInput;
import java.io.IOException;
import javax.transaction.xa.Xid;
import jeus.transaction.TMNotAvailableException;
import jeus.transaction.XidImpl;
import jeus.transaction.client.ClientContextSenderReceiver;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;

public abstract class ContextSenderReceiver {
    protected static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    public static final byte[] nullTxBytes = new byte[]{0};
    private static ContextSenderReceiver delegate;

    public static void setContextSenderReceiver(ContextSenderReceiver delegate) {
        ContextSenderReceiver.delegate = delegate;
    }

    protected abstract boolean processContextPropagated(byte[] var1, Xid var2) throws TMNotAvailableException;

    public static boolean contextPropagated(byte[] ctx, Xid xid) throws TMNotAvailableException {
        return delegate.processContextPropagated(ctx, xid);
    }

    protected abstract byte[] processGetPropagationContext();

    public static byte[] getPropagationContext() {
        return delegate.processGetPropagationContext();
    }

    public static int readTMCtx(DataInput din) throws IOException {
        byte len = din.readByte();
        if (len == -1) {
            byte[] ctx = new byte[]{len};
            ContextSenderReceiver.contextPropagated(ctx, null);
            return 0;
        }
        if (len == -2) {
            byte[] ctx = new byte[5];
            ctx[0] = len;
            din.readFully(ctx, 1, 4);
            ContextSenderReceiver.contextPropagated(ctx, null);
            return 1;
        }
        if (len == -3) {
            byte[] ctx = new byte[5];
            ctx[0] = len;
            din.readFully(ctx, 1, 4);
            byte[] gtid = ContextSenderReceiver.readByteArray(din);
            byte[] bq = ContextSenderReceiver.readByteArray(din);
            int formatID = ByteUtil.readInt((DataInput)din);
            XidImpl xid = new XidImpl(gtid, bq, formatID);
            ContextSenderReceiver.contextPropagated(ctx, xid);
            return 1;
        }
        byte len2 = din.readByte();
        int length = ByteUtil.convertToUnsignedShort((byte[])new byte[]{len, len2}, (int)0);
        byte[] ctx = new byte[length + 2];
        ctx[0] = len;
        ctx[1] = len2;
        din.readFully(ctx, 2, length);
        if (ContextSenderReceiver.contextPropagated(ctx, null)) {
            return 2;
        }
        return 0;
    }

    public static int readTMCtx(byte[] bytes) {
        int offset = 0;
        try {
            byte len = bytes[offset++];
            if (len == -1) {
                byte[] ctx = new byte[]{len};
                ContextSenderReceiver.contextPropagated(ctx, null);
                return 0;
            }
            if (len == -2) {
                byte[] ctx = new byte[5];
                ctx[0] = len;
                System.arraycopy(bytes, offset, ctx, 1, 4);
                ContextSenderReceiver.contextPropagated(ctx, null);
                return 1;
            }
            if (len == -3) {
                byte[] ctx = new byte[5];
                ctx[0] = len;
                System.arraycopy(bytes, offset, ctx, 1, 4);
                offset += 4;
                byte gtidlength = bytes[offset++];
                byte[] gtid = new byte[gtidlength];
                System.arraycopy(bytes, offset, gtid, 0, gtidlength);
                offset += gtidlength;
                byte bqlength = bytes[offset++];
                byte[] bq = new byte[bqlength];
                System.arraycopy(bytes, offset, bq, 0, bqlength);
                byte formatID = bytes[offset += bqlength];
                XidImpl xid = new XidImpl(gtid, bq, (int)formatID);
                ContextSenderReceiver.contextPropagated(ctx, xid);
                return 1;
            }
            byte len2 = bytes[offset++];
            int length = ByteUtil.convertToUnsignedShort((byte[])new byte[]{len, len2}, (int)0);
            byte[] ctx = new byte[length + 2];
            ctx[0] = len;
            ctx[1] = len2;
            System.arraycopy(bytes, offset, ctx, 2, length);
            if (ContextSenderReceiver.contextPropagated(ctx, null)) {
                return 2;
            }
            return 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readByteArray(DataInput din) throws IOException {
        byte length = din.readByte();
        byte[] gtid = new byte[length];
        din.readFully(gtid, 0, length);
        return gtid;
    }

    static {
        ContextSenderReceiver.nullTxBytes[0] = -1;
        delegate = new ClientContextSenderReceiver();
    }
}

