/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import javax.naming.Reference;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;

public class TMCommonService {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");

    public static void registerDataSource(Reference ref, String exportName) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5705_LEVEL)) {
            logger.logp(JeusMessage_TM3._5705_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5705, (Object)exportName);
        }
        JEUSXAResourceFactory factory = new JEUSXAResourceFactory(ref);
        TMServer.registerXAResourceReference(factory, exportName);
        if (logger.isLoggable(JeusMessage_TM3._5706_LEVEL)) {
            logger.logp(JeusMessage_TM3._5706_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5706);
        }
    }

    public static void registerDataSource(XAResourceFactory factory, String exportName) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5705_LEVEL)) {
            logger.logp(JeusMessage_TM3._5705_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5705, (Object)exportName);
        }
        TMServer.registerXAResourceReference(factory, exportName);
        if (logger.isLoggable(JeusMessage_TM3._5706_LEVEL)) {
            logger.logp(JeusMessage_TM3._5706_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5706);
        }
    }

    public static void associateNullTransaction() {
        if (logger.isLoggable(JeusMessage_TM3._5707_LEVEL)) {
            logger.logp(JeusMessage_TM3._5707_LEVEL, "TMService", "associateNullTransaction", JeusMessage_TM3._5707);
        }
        ThreadContexts.dissociateTransactionID();
    }

    public static void associateTransactionContext(Transaction tx) {
        if (logger.isLoggable(JeusMessage_TM3._5708_LEVEL)) {
            logger.logp(JeusMessage_TM3._5708_LEVEL, "TMService", "associateTransactionContext", JeusMessage_TM3._5708, (Object)tx);
        }
        TMServer.associateThread(((TransactionImpl)tx).getGTID());
    }

    public static GTID suspendCurrentTransaction() {
        if (logger.isLoggable(JeusMessage_TM3._5709_LEVEL)) {
            logger.logp(JeusMessage_TM3._5709_LEVEL, "TMService", "suspendCurrentTransaction", JeusMessage_TM3._5709);
        }
        GTID id = ThreadContexts.getAssociatedTransactionID();
        ThreadContexts.dissociateTransactionID();
        return id;
    }

    public static void resumeCurrentTransaction(GTID id) {
        if (logger.isLoggable(JeusMessage_TM3._5710_LEVEL)) {
            logger.logp(JeusMessage_TM3._5710_LEVEL, "TMService", "resumeCurrentTransaction", JeusMessage_TM3._5710, (Object)id);
        }
        ThreadContexts.associateTransactionID(id);
    }

    public static boolean isAssociatedWithNullTransaction() {
        boolean associated;
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        boolean bl = associated = gtid == null || gtid.isInvalid();
        if (logger.isLoggable(JeusMessage_TM3._5711_LEVEL)) {
            logger.logp(JeusMessage_TM3._5711_LEVEL, "TMService", "isAssociatedWithNullTransaction", JeusMessage_TM3._5711, (Object)associated);
        }
        return associated;
    }

    public static boolean isAssociatedWithTransaction() {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        return gtid != null && !gtid.isInvalid();
    }

    public static void waitForRecovery() {
        TMServer.waitForRecovery();
    }

    public static boolean isTxTimeout() {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        return gtid != null && gtid.isInvalid();
    }

    public static boolean isGeneratedAtThisTM(Xid xid) {
        if (xid == null) {
            return false;
        }
        byte[] gtidBytes = xid.getGlobalTransactionId();
        if (gtidBytes == null) {
            return false;
        }
        TMInfo tmInfo = TMServer.getTMInfo();
        if (tmInfo == null) {
            return false;
        }
        GTID jeusGtid = new GTID(gtidBytes);
        return tmInfo.isGeneratedAtThisTM(jeusGtid);
    }
}

