/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import jeus.descriptor.jeusserver.TransactionManagerDescriptor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusTMProperties;

public final class TMConfig {
    public static long activeTO;
    public static long prepareTO;
    public static long preparedTO;
    public static long commitTO;
    public static long recoveryTO;
    public static long uncompletedTO;
    public static final long regTO = 120000L;
    public static boolean nonBlocking;
    private static final JeusLogger logger;

    public static void initialize() {
        TransactionManagerDescriptor tdesc = new TransactionManagerDescriptor();
        activeTO = tdesc.getTMActiveTO();
        prepareTO = tdesc.getTMPrepareTO();
        preparedTO = tdesc.getTMPreparedTO();
        commitTO = tdesc.getTMCommitTO();
        recoveryTO = tdesc.getTMRecoveryTO();
        uncompletedTO = tdesc.getTMUncompletedTO();
    }

    public static void configure(TransactionManagerDescriptor desc) {
        if (desc != null) {
            nonBlocking = desc.isNonBlocking();
            activeTO = desc.getTMActiveTO();
            prepareTO = desc.getTMPrepareTO();
            preparedTO = desc.getTMPreparedTO();
            commitTO = desc.getTMCommitTO();
            recoveryTO = desc.getTMRecoveryTO();
            uncompletedTO = desc.getTMUncompletedTO();
        } else {
            nonBlocking = JeusTMProperties.isNonBlocking;
            activeTO = JeusTMProperties.activeTO;
            prepareTO = JeusTMProperties.prepareTO;
            preparedTO = JeusTMProperties.preparedTO;
            commitTO = JeusTMProperties.commitTO;
            recoveryTO = JeusTMProperties.recoveryTO;
            uncompletedTO = JeusTMProperties.uncompletedTO;
        }
        if (logger.isLoggable(JeusMessage_TM3._5554_LEVEL)) {
            logger.logp(JeusMessage_TM3._5554_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5554, (Object)String.valueOf(nonBlocking));
        }
        if (logger.isLoggable(JeusMessage_TM3._5432_LEVEL)) {
            logger.logp(JeusMessage_TM3._5432_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5432, (Object)String.valueOf(activeTO));
        }
        if (logger.isLoggable(JeusMessage_TM3._5433_LEVEL)) {
            logger.logp(JeusMessage_TM3._5433_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5433, (Object)String.valueOf(prepareTO));
        }
        if (logger.isLoggable(JeusMessage_TM3._5434_LEVEL)) {
            logger.logp(JeusMessage_TM3._5434_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5434, (Object)String.valueOf(preparedTO));
        }
        if (logger.isLoggable(JeusMessage_TM3._5435_LEVEL)) {
            logger.logp(JeusMessage_TM3._5435_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5435, (Object)String.valueOf(commitTO));
        }
        if (logger.isLoggable(JeusMessage_TM3._5436_LEVEL)) {
            logger.logp(JeusMessage_TM3._5436_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5436, (Object)String.valueOf(recoveryTO));
        }
        if (logger.isLoggable(JeusMessage_TM3._5437_LEVEL)) {
            logger.logp(JeusMessage_TM3._5437_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5437, (Object)String.valueOf(uncompletedTO));
        }
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    }
}

