/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import jeus.net.SocketID;
import jeus.transaction.GTID;
import jeus.util.ByteUtil;
import jeus.util.cnet.NetUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM3;

public final class TMInfo
implements SocketID,
Serializable {
    static final long serialVersionUID = -3385248128742451331L;
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private final byte[] ipaddr;
    private final String ipstr;
    private int port;
    private final int vport;
    private final int time;
    private byte[] id;
    private int hashCode = -1;
    private String str;
    private String virtualID;
    private static final int TM_CONNECTION = 0;
    private static final int SIZE_TMINFO_EXCEPT_IP_ADDR = 8;
    public static final int SIZE_TMINFO_IPv4 = 12;
    public static final int SIZE_TMINFO_IPv6 = 24;
    private byte type;
    public static final byte TYPE_IPv4 = 0;
    public static final byte TYPE_IPv6 = 1;
    public static final int MAX_TMINFO_SIZE = 24;
    public static final int SIZE_START_TIME = 4;

    public TMInfo(byte[] ipaddr, int port, int time, int vport) {
        this.ipaddr = ipaddr;
        this.port = port;
        this.vport = vport;
        if (vport >= 0) {
            this.virtualID = "TM" + vport;
        }
        this.time = time;
        this.type = ipaddr.length == 4 ? (byte)0 : 1;
        this.ipstr = NetUtil.getIPAddrString((byte[])ipaddr);
        if (logger.isLoggable(JeusMessage_TM3._5301_LEVEL)) {
            logger.logp(JeusMessage_TM3._5301_LEVEL, "TMInfo", "<init>", JeusMessage_TM3._5301, (Object)this);
        }
    }

    public TMInfo(byte[] id, int offset) {
        this.id = id;
        byte type = id[offset];
        this.ipaddr = type == 0 ? new byte[4] : new byte[16];
        System.arraycopy(id, ++offset, this.ipaddr, 0, this.ipaddr.length);
        this.ipstr = NetUtil.getIPAddrString((byte[])this.ipaddr);
        this.port = ByteUtil.convertToUnsignedShort((byte[])id, (int)(offset += this.ipaddr.length));
        if (id[offset += 2] >= 0) {
            this.vport = id[offset];
            this.virtualID = "TM" + this.vport;
        } else {
            this.vport = -1;
        }
        this.time = ByteUtil.convertToInt((byte[])id, (int)(++offset));
        if (logger.isLoggable(JeusMessage_TM3._5302_LEVEL)) {
            logger.logp(JeusMessage_TM3._5302_LEVEL, "TMInfo", "<init>", JeusMessage_TM3._5302, (Object)this);
        }
    }

    public TMInfo(String location) throws UnknownHostException {
        int index = location.indexOf(95);
        this.type = (byte)Integer.parseInt(location.substring(0, index));
        int prevIndex = index + 1;
        index = location.indexOf(95, prevIndex);
        this.port = Integer.parseInt(location.substring(prevIndex, index));
        prevIndex = index + 1;
        index = location.lastIndexOf(95);
        String ipstrNomalized = location.substring(prevIndex, index);
        this.ipstr = ipstrNomalized.replace('_', '.').replace('#', ':');
        this.vport = Integer.parseInt(location.substring(index + 1));
        if (this.vport >= 0) {
            this.virtualID = "TM" + this.vport;
        }
        this.time = 0;
        InetAddress addr = InetAddress.getByName(this.ipstr);
        this.ipaddr = addr.getAddress();
    }

    public byte[] getIPAddress() {
        if (logger.isLoggable(JeusMessage_TM3._5304_LEVEL)) {
            logger.logp(JeusMessage_TM3._5304_LEVEL, "TMInfo", "getIPAddress", JeusMessage_TM3._5304, (Object)Utility.getDump((byte[])this.ipaddr));
        }
        return this.ipaddr;
    }

    public String getIPString() {
        if (logger.isLoggable(JeusMessage_TM3._5305_LEVEL)) {
            logger.logp(JeusMessage_TM3._5305_LEVEL, "TMInfo", "getIPString", JeusMessage_TM3._5305, (Object)this.ipstr);
        }
        return this.ipstr;
    }

    public int getPort() {
        if (logger.isLoggable(JeusMessage_TM3._5307_LEVEL)) {
            logger.logp(JeusMessage_TM3._5307_LEVEL, "TMInfo", "getPort", JeusMessage_TM3._5307, (Object)new Integer(this.port));
        }
        return this.port;
    }

    public int getTime() {
        if (logger.isLoggable(JeusMessage_TM3._5308_LEVEL)) {
            logger.logp(JeusMessage_TM3._5308_LEVEL, "TMInfo", "getTime", JeusMessage_TM3._5308, (Object)new Integer(this.time));
        }
        return this.time;
    }

    public String toString() {
        if (this.str == null) {
            this.str = "(" + this.type + ":" + this.ipstr + ":" + this.port + ":" + this.vport + ":0x" + Integer.toHexString(this.time) + ")";
        }
        return this.str;
    }

    public String getGTID(long ltid) {
        return "(" + this.type + ":" + this.ipstr + ":" + this.port + ":" + this.vport + ":0x" + Integer.toHexString(this.time) + ":0x" + Long.toHexString(ltid) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TMInfo) {
            TMInfo target = (TMInfo)obj;
            return Arrays.equals(target.ipaddr, this.ipaddr) && target.port == this.port && target.time == this.time && this.vport == target.vport;
        }
        return false;
    }

    public boolean isGeneratedAtThisTM(GTID gtid) {
        return this.isSameLocation(gtid.getPort(), gtid.getIPAddress(), gtid.getVPort());
    }

    public boolean isSameLocation(TMInfo info) {
        return this.isSameLocation(info.getPort(), info.getIPAddress(), info.getVirtualPort());
    }

    public boolean isSameLocation(int port, byte[] ipaddr, int vport) {
        return this.port == port && Arrays.equals(this.ipaddr, ipaddr) && this.vport == vport;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = ByteUtil.getHashCode((byte[])this.ipaddr) + this.port + this.time + this.vport;
        }
        return this.hashCode;
    }

    public byte[] toBytes() {
        if (this.id == null) {
            byte[] result = this.type == 0 ? new byte[12] : new byte[24];
            this.toBytes(result, 0);
            this.id = result;
        }
        return this.id;
    }

    public int toBytes(byte[] result, int offset) {
        result[offset] = this.type;
        System.arraycopy(this.ipaddr, 0, result, ++offset, this.ipaddr.length);
        ByteUtil.putUnsingedShort((byte[])result, (int)(offset += this.ipaddr.length), (int)this.port);
        result[offset += 2] = (byte)this.vport;
        ByteUtil.putInt((byte[])result, (int)(++offset), (int)this.time);
        return offset += 4;
    }

    public boolean isServer() {
        return this.vport >= 0;
    }

    public int getVirtualPort() {
        return this.vport;
    }

    public String getHost() {
        return this.ipstr;
    }

    public int getBasePort() {
        return this.port;
    }

    public boolean needConnect(SocketID socketID) {
        TMInfo o = (TMInfo)socketID;
        int result = this.ipstr.compareTo(o.ipstr);
        if (result > 0) {
            return true;
        }
        if (result < 0) {
            return false;
        }
        if (this.port != o.port) {
            return this.port > o.port;
        }
        if (this.vport != o.vport) {
            return this.vport > o.vport;
        }
        return this.time > o.time;
    }

    public String getVirtualID() {
        return this.virtualID;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectionType() {
        return 0;
    }

    public void setConnectionType(int type) {
    }

    public void setNotConnectable() {
    }

    public boolean isNotConnectable() {
        return false;
    }

    public String getLocationString() {
        String ipaddr = this.ipstr.replace('.', '_');
        ipaddr = ipaddr.replace(':', '#');
        return this.type + "_" + this.port + "_" + ipaddr + "_" + this.vport;
    }

    public byte getType() {
        return this.type;
    }

    public int getByteLength() {
        if (this.type == 0) {
            return 12;
        }
        return 24;
    }
}

