/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.transaction.InvalidTransactionException;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.TMConfig;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;

public final class ThreadContexts {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private static final Object sync = new Object();
    private static ThreadLocal contexts = new ThreadLocal();
    private static final ThreadLocal localTxList = new ThreadLocal();
    private static Hashtable coordTable;
    private static Hashtable localCoordTable;
    private static ThreadLocal<Long> nextTimeout;

    public static void initContexts(int capacity) {
        contexts = new ThreadLocal();
        coordTable = new Hashtable(capacity);
        localCoordTable = new Hashtable(capacity);
    }

    public static GTID getAssociatedTransactionID() {
        return (GTID)contexts.get();
    }

    public static void associateTransactionID(GTID gtid) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM3._5532_LEVEL)) {
            logger.logp(JeusMessage_TM3._5532_LEVEL, "TMServer", "associateThread", JeusMessage_TM3._5532, new Object[]{Thread.currentThread(), gtid});
        }
        if (gtid != null && gtid.getExternalXid() == null && (coord = ThreadContexts.getCoordinator(gtid.getLTID())) != null) {
            gtid.setExternalXid(coord.getExternalXid());
        }
        contexts.set(gtid);
    }

    public static void dissociateTransactionID() {
        contexts.set(null);
    }

    public static List getAssociatedLocalTransactions() {
        return (List)localTxList.get();
    }

    public static void associateLocalTransaction(Object localTx) {
        ArrayList<Object> list;
        if (logger.isLoggable(JeusMessage_TM3._5539_LEVEL)) {
            logger.logp(JeusMessage_TM3._5539_LEVEL, "TMServer", "enlistLocalTransaction", JeusMessage_TM3._5539, (Object)Thread.currentThread());
        }
        if ((list = ThreadContexts.getAssociatedLocalTransactions()) == null) {
            list = new ArrayList<Object>();
            localTxList.set(list);
        }
        list.add(localTx);
    }

    public static void dissociateLocalTransaction(Object localTx) {
        List list;
        if (logger.isLoggable(JeusMessage_TM3._5540_LEVEL)) {
            logger.logp(JeusMessage_TM3._5540_LEVEL, "TMServer", "delistLocalTransaction", JeusMessage_TM3._5540, (Object)Thread.currentThread());
        }
        if ((list = ThreadContexts.getAssociatedLocalTransactions()) != null) {
            list.remove(localTx);
        }
    }

    public static int getOnGoingLocalTxNum() {
        List list = ThreadContexts.getAssociatedLocalTransactions();
        return list == null ? 0 : list.size();
    }

    public static Coordinator getCurrentCoordinator() throws InvalidTransactionException {
        Coordinator coord;
        GTID gtid;
        if (logger.isLoggable(JeusMessage_TM3._5527_LEVEL)) {
            logger.logp(JeusMessage_TM3._5527_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5527, (Object)Thread.currentThread());
        }
        if ((gtid = ThreadContexts.getAssociatedTransactionID()) == null || gtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM3._5528_LEVEL)) {
                logger.logp(JeusMessage_TM3._5528_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5528, (Object)Thread.currentThread());
            }
            return null;
        }
        if (gtid.isLocal()) {
            if (logger.isLoggable(JeusMessage_TM3._5529_LEVEL)) {
                logger.logp(JeusMessage_TM3._5529_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5529, new Object[]{Thread.currentThread(), gtid});
            }
            coord = (Coordinator)localCoordTable.get(new Long(gtid.getLTID()));
        } else {
            if (logger.isLoggable(JeusMessage_TM3._5530_LEVEL)) {
                logger.logp(JeusMessage_TM3._5530_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5530, new Object[]{Thread.currentThread(), gtid});
            }
            coord = ThreadContexts.getCoordinator(gtid);
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5531_LEVEL)) {
                logger.logp(JeusMessage_TM3._5531_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5531, (Object)Thread.currentThread());
            }
            if (logger.isLoggable(JeusMessage_TM3._5556_LEVEL)) {
                logger.logp(JeusMessage_TM3._5556_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5556, (Object)Thread.currentThread());
            }
            ThreadContexts.dissociateTransactionID();
            throw new InvalidTransactionException();
        }
        return coord;
    }

    static Coordinator dissociateFromThread() {
        GTID gtid;
        if (logger.isLoggable(JeusMessage_TM3._5533_LEVEL)) {
            logger.logp(JeusMessage_TM3._5533_LEVEL, "TMServer", "dissociateThread", JeusMessage_TM3._5533, (Object)Thread.currentThread());
        }
        if ((gtid = ThreadContexts.getAssociatedTransactionID()) == null || gtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM3._5534_LEVEL)) {
                logger.logp(JeusMessage_TM3._5534_LEVEL, "TMServer", "dissociateThread", JeusMessage_TM3._5534, (Object)Thread.currentThread());
            }
            return null;
        }
        ThreadContexts.dissociateTransactionID();
        if (gtid.isLocal()) {
            if (logger.isLoggable(JeusMessage_TM3._5535_LEVEL)) {
                logger.logp(JeusMessage_TM3._5535_LEVEL, "TMServer", "dissociateThread", JeusMessage_TM3._5535, new Object[]{Thread.currentThread(), gtid});
            }
            return (Coordinator)localCoordTable.get(new Long(gtid.getLTID()));
        }
        if (logger.isLoggable(JeusMessage_TM3._5536_LEVEL)) {
            logger.logp(JeusMessage_TM3._5536_LEVEL, "TMServer", "dissociateThread", JeusMessage_TM3._5536, new Object[]{Thread.currentThread(), gtid});
        }
        return ThreadContexts.getCoordinator(gtid);
    }

    public static Vector getLocalCoordinatorList() {
        if (logger.isLoggable(JeusMessage_TM3._5520_LEVEL)) {
            logger.logp(JeusMessage_TM3._5520_LEVEL, "TMServer", "getLocalCoordinatorList", JeusMessage_TM3._5520);
        }
        return new Vector(localCoordTable.values());
    }

    public static Vector getSubCoordinatorList() {
        return new Vector(coordTable.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCoordinator(GTID gtid) {
        if (logger.isLoggable(JeusMessage_TM3._5523_LEVEL)) {
            logger.logp(JeusMessage_TM3._5523_LEVEL, "TMServer", "removeCoordinator", JeusMessage_TM3._5523, (Object)gtid);
        }
        coordTable.remove(gtid);
        if (coordTable.size() == 0) {
            Object object = sync;
            synchronized (object) {
                sync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCoordinator(long ltid) {
        if (logger.isLoggable(JeusMessage_TM3._5524_LEVEL)) {
            logger.logp(JeusMessage_TM3._5524_LEVEL, "TMServer", "removeCoordinator", JeusMessage_TM3._5524, (Object)("0x" + Long.toHexString(ltid)));
        }
        localCoordTable.remove(new Long(ltid));
        if (localCoordTable.size() == 0) {
            Object object = sync;
            synchronized (object) {
                sync.notifyAll();
            }
        }
    }

    public static Coordinator getCoordinator(GTID gtid) {
        if (gtid.isLocal()) {
            return ThreadContexts.getCoordinator(gtid.getLTID());
        }
        if (logger.isLoggable(JeusMessage_TM3._5525_LEVEL)) {
            logger.logp(JeusMessage_TM3._5525_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5525, (Object)gtid);
        }
        return (Coordinator)coordTable.get(gtid);
    }

    public static RootCoordinator getCoordinator(long ltid) {
        if (logger.isLoggable(JeusMessage_TM3._5526_LEVEL)) {
            logger.logp(JeusMessage_TM3._5526_LEVEL, "TMServer", "getCoordinator", JeusMessage_TM3._5526, (Object)("0x" + Long.toHexString(ltid)));
        }
        return (RootCoordinator)localCoordTable.get(new Long(ltid));
    }

    public static void putCoordinator(GTID gtid, Coordinator coord) {
        coordTable.put(gtid, coord);
    }

    public static void putCoordinator(long ltid, Coordinator coord) {
        localCoordTable.put(new Long(ltid), coord);
    }

    public static boolean hasActiveCoordinator() {
        return coordTable.size() > 0 || localCoordTable.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForActiveCoordinator() {
        try {
            Object object = sync;
            synchronized (object) {
                while (coordTable.size() > 0 || localCoordTable.size() > 0) {
                    if (logger.isLoggable(Level.WARNING)) {
                        StringBuffer ltids = new StringBuffer();
                        for (Long aLong : localCoordTable.keySet()) {
                            ltids.append(aLong).append(", ");
                        }
                        StringBuffer gtids = new StringBuffer();
                        for (GTID aLong : coordTable.keySet()) {
                            ltids.append(aLong.toString()).append(", ");
                        }
                        if (logger.isLoggable(JeusMessage_TM3._5564_LEVEL)) {
                            logger.log(JeusMessage_TM3._5564_LEVEL, JeusMessage_TM3._5564, new Object[]{ltids.toString(), gtids.toString()});
                        }
                    }
                    sync.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static long getNextTimeout() {
        Long t = nextTimeout.get();
        if (t == null) {
            return TMConfig.activeTO;
        }
        return t;
    }

    public static void setNextTimeout(long millis) {
        if (millis <= 0L) {
            ThreadContexts.initNextTimeout();
        } else {
            nextTimeout.set(millis);
        }
    }

    public static void initNextTimeout() {
        nextTimeout.remove();
    }

    static {
        nextTimeout = new ThreadLocal();
    }
}

