/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.client;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.client.RemoteGTID;
import jeus.transaction.client.TMClient;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM0;

public final class ClientUserTransactionImpl
implements UserTransaction,
Serializable {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    public static final ClientUserTransactionImpl userTx = new ClientUserTransactionImpl();

    protected ClientUserTransactionImpl() {
        if (logger.isLoggable(JeusMessage_TM0._1101_LEVEL)) {
            logger.logp(JeusMessage_TM0._1101_LEVEL, "ClientUserTransactionImpl", "<init>", JeusMessage_TM0._1101);
        }
    }

    public final void begin() throws NotSupportedException, SystemException {
        if (logger.isLoggable(JeusMessage_TM0._1102_LEVEL)) {
            logger.logp(JeusMessage_TM0._1102_LEVEL, "ClientUserTransactionImpl", "begin", JeusMessage_TM0._1102);
        }
        TMClient.create(null, ThreadContexts.getNextTimeout());
        if (logger.isLoggable(JeusMessage_TM0._1103_LEVEL)) {
            logger.logp(JeusMessage_TM0._1103_LEVEL, "ClientUserTransactionImpl", "begin", JeusMessage_TM0._1103);
        }
    }

    public final void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM0._1104_LEVEL)) {
            logger.logp(JeusMessage_TM0._1104_LEVEL, "ClientUserTransactionImpl", "commit", JeusMessage_TM0._1104);
        }
        TMClient.commit();
        if (logger.isLoggable(JeusMessage_TM0._1105_LEVEL)) {
            logger.logp(JeusMessage_TM0._1105_LEVEL, "ClientUserTransactionImpl", "commit", JeusMessage_TM0._1105);
        }
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (logger.isLoggable(JeusMessage_TM0._1106_LEVEL)) {
            logger.logp(JeusMessage_TM0._1106_LEVEL, "ClientUserTransactionImpl", "rollback", JeusMessage_TM0._1106);
        }
        TMClient.rollback(null);
        if (logger.isLoggable(JeusMessage_TM0._1107_LEVEL)) {
            logger.logp(JeusMessage_TM0._1107_LEVEL, "ClientUserTransactionImpl", "rollback", JeusMessage_TM0._1107);
        }
    }

    public final void setRollbackOnly() throws IllegalStateException, SystemException {
        RemoteGTID rgtid;
        if (logger.isLoggable(JeusMessage_TM0._1108_LEVEL)) {
            logger.logp(JeusMessage_TM0._1108_LEVEL, "ClientUserTransactionImpl", "setRollbackOnly", JeusMessage_TM0._1108);
        }
        if ((rgtid = TMClient.getRemoteGTID()) == null || rgtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM0._1109_LEVEL)) {
                logger.logp(JeusMessage_TM0._1109_LEVEL, "ClientUserTransactionImpl", "setRollbackOnly", JeusMessage_TM0._1109);
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1109));
        }
        rgtid.setRollbackOnly();
        if (logger.isLoggable(JeusMessage_TM0._1110_LEVEL)) {
            logger.logp(JeusMessage_TM0._1110_LEVEL, "ClientUserTransactionImpl", "setRollbackOnly", JeusMessage_TM0._1110);
        }
    }

    public static boolean getRollbackOnly() throws IllegalStateException {
        RemoteGTID rgtid;
        if (logger.isLoggable(JeusMessage_TM0._1111_LEVEL)) {
            logger.logp(JeusMessage_TM0._1111_LEVEL, "ClientUserTransactionImpl", "getRollbackOnly", JeusMessage_TM0._1111);
        }
        if ((rgtid = TMClient.getRemoteGTID()) == null || rgtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM0._1112_LEVEL)) {
                logger.logp(JeusMessage_TM0._1112_LEVEL, "ClientUserTransactionImpl", "getRollbackOnly", JeusMessage_TM0._1112);
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1112));
        }
        boolean isRollback = rgtid.isRollbackOnly();
        if (logger.isLoggable(JeusMessage_TM0._1113_LEVEL)) {
            logger.logp(JeusMessage_TM0._1113_LEVEL, "ClientUserTransactionImpl", "getRollbackOnly", JeusMessage_TM0._1113, (Object)(isRollback ? "" : "not "));
        }
        return isRollback;
    }

    public final int getStatus() throws SystemException {
        RemoteGTID rgtid;
        if (logger.isLoggable(JeusMessage_TM0._1114_LEVEL)) {
            logger.logp(JeusMessage_TM0._1114_LEVEL, "ClientUserTransactionImpl", "getStatus", JeusMessage_TM0._1114);
        }
        if ((rgtid = TMClient.getRemoteGTID()) == null || rgtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM0._1115_LEVEL)) {
                logger.logp(JeusMessage_TM0._1115_LEVEL, "ClientUserTransactionImpl", "getStatus", JeusMessage_TM0._1115);
            }
            return 6;
        }
        int state = rgtid.getStatus();
        if (logger.isLoggable(JeusMessage_TM0._1116_LEVEL)) {
            logger.logp(JeusMessage_TM0._1116_LEVEL, "ClientUserTransactionImpl", "getStatus", JeusMessage_TM0._1116, (Object)TxStatus.getState(state));
        }
        return state;
    }

    public final void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            if (logger.isLoggable(JeusMessage_TM0._1117_LEVEL)) {
                logger.logp(JeusMessage_TM0._1117_LEVEL, "ClientUserTransactionImpl", "setTransactionTimeout", JeusMessage_TM0._1117, (Object)String.valueOf(seconds));
            }
            throw new SystemException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1117, (Object)String.valueOf(seconds)));
        }
        ThreadContexts.setNextTimeout(seconds * 1000);
        if (logger.isLoggable(JeusMessage_TM0._1118_LEVEL)) {
            logger.logp(JeusMessage_TM0._1118_LEVEL, "ClientUserTransactionImpl", "setTransactionTimeout", JeusMessage_TM0._1118, (Object)String.valueOf(seconds));
        }
    }
}

