/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.transaction.HeuristicMixedException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.management.JMXUtility;
import jeus.management.RemoteMBeanServerFactory;
import jeus.management.j2ee.JTAResourceMBean;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.client.RemoteGTID;
import jeus.transaction.client.TMClient;
import jeus.transaction.comm.TMLink;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;

public final class InterposedTransactionManager
implements XAResource {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private static final ConcurrentHashMap XID_MAPPER;
    private static final ConcurrentHashMap XID_TABLE;
    private static final ConcurrentHashMap PREPARED_XIDS;
    private long timeout = TMConfig.activeTO;
    private Hashtable env = null;

    public InterposedTransactionManager(Hashtable env) {
        this.env = env;
        if (this.env == null) {
            this.env = new Hashtable();
        }
    }

    public final int getTransactionTimeout() throws XAException {
        long seconds = this.timeout / 1000L;
        if (seconds > Integer.MAX_VALUE) {
            seconds = Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    public final boolean setTransactionTimeout(int seconds) {
        if (seconds < 0) {
            return false;
        }
        this.timeout = seconds * 1000;
        return true;
    }

    public final boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource instanceof InterposedTransactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Xid[] recover(int flag) throws XAException {
        JTAResourceMBean[] mbeans;
        MBeanServerConnection mbsc = RemoteMBeanServerFactory.getMBeanServer(this.env);
        try {
            mbeans = JMXUtility.getProxy(mbsc, JMXUtility.queryJTAResources(mbsc), JTAResourceMBean.class, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
        ArrayList<Xid> recoverXids = new ArrayList<Xid>();
        ConcurrentHashMap concurrentHashMap = XID_TABLE;
        synchronized (concurrentHashMap) {
            XID_TABLE.clear();
            for (int j = 0; j < mbeans.length; ++j) {
                JTAResourceMBean mbean = mbeans[j];
                Xid[] xids = mbean.recover(flag);
                for (int i = 0; i < xids.length; ++i) {
                    XID_TABLE.put(XidToString.getGtidStringFromXid(xids[i]), mbean);
                    recoverXids.add(xids[i]);
                }
            }
        }
        if (PREPARED_XIDS.size() > 0) {
            recoverXids.addAll(PREPARED_XIDS.values());
        }
        return recoverXids.toArray(new Xid[recoverXids.size()]);
    }

    public final int prepare(Xid xid) throws XAException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        try {
            byte response;
            RemoteGTID rgtid = (RemoteGTID)XID_MAPPER.get(xidString);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "prepare called for the xid : " + xid + ", jeus gtid : " + rgtid);
            }
            if (PREPARED_XIDS.containsKey(xidString) || rgtid == null) {
                return 3;
            }
            this.checkGTID(rgtid, xid, false);
            if (rgtid.isUnspecified()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "start was called but no JEUS resource has been used for this xid : " + xid);
                }
                XID_MAPPER.remove(xidString);
                rgtid.invalidate();
                XID_TABLE.remove(xidString);
                return 3;
            }
            try {
                TMLink link = TMClient.linkManager.getLink(rgtid.getTMInfo());
                TMClient.responseCollector.put(rgtid, rgtid);
                link.remoteXAPrepare(rgtid.getLTID());
                response = rgtid.collector.waiting(TMConfig.commitTO);
            }
            catch (TMException ex) {
                ex.printStackTrace();
                throw new XAException(106);
            }
            finally {
                TMClient.responseCollector.remove(rgtid);
            }
            switch (response) {
                case 0: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "return XA_OK for this xid : " + xid);
                    }
                    PREPARED_XIDS.put(xidString, xid);
                    return 0;
                }
                case 3: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "return XA_RONLY for this xid : " + xid);
                    }
                    XID_MAPPER.remove(xidString);
                    rgtid.invalidate();
                    XID_TABLE.remove(xidString);
                    return 3;
                }
            }
            throw new XAException(response);
        }
        catch (XAException ex) {
            RemoteGTID rgtid = (RemoteGTID)XID_MAPPER.remove(xidString);
            rgtid.invalidate();
            XID_TABLE.remove(xidString);
            throw ex;
        }
        catch (Throwable t) {
            RemoteGTID rgtid = (RemoteGTID)XID_MAPPER.remove(xidString);
            rgtid.invalidate();
            XID_TABLE.remove(xidString);
            t.printStackTrace();
            throw new XAException(-3);
        }
    }

    public final void forget(Xid xid) throws XAException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        Xid preparedXid = (Xid)PREPARED_XIDS.get(xidString);
        if (preparedXid != null) {
            throw new XAException("cannot forget a prepared transaction");
        }
        JTAResourceMBean mbean = (JTAResourceMBean)XID_TABLE.get(xidString);
        if (mbean != null) {
            mbean.forget(xid);
        }
    }

    public final void rollback(Xid xid) throws XAException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        JTAResourceMBean mbean = (JTAResourceMBean)XID_TABLE.get(xidString);
        if (mbean != null) {
            try {
                mbean.rollback(xid);
            }
            catch (XAException e) {
                throw e;
            }
            finally {
                RemoteGTID rgtid = (RemoteGTID)XID_MAPPER.remove(xidString);
                if (rgtid != null) {
                    rgtid.invalidate();
                }
                XID_TABLE.remove(xidString);
                PREPARED_XIDS.remove(xidString);
            }
            return;
        }
        RemoteGTID rgtid = null;
        try {
            rgtid = (RemoteGTID)XID_MAPPER.remove(xidString);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "rollback called for the xid : " + xid + ", jeus gtid : " + rgtid);
            }
            this.rollback(rgtid, xid);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new XAException(-3);
        }
        finally {
            if (rgtid != null) {
                rgtid.invalidate();
            }
            PREPARED_XIDS.remove(xidString);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollback(RemoteGTID rgtid, Xid xid) throws XAException {
        this.checkGTID(rgtid, xid, true);
        if (rgtid.isUnspecified()) {
            if (!logger.isLoggable(Level.FINE)) return;
            logger.log(Level.FINE, "start was called but no JEUS resource has been used for this xid : " + xid);
            return;
        }
        try {
            TMLink link = TMClient.linkManager.getLink(rgtid.getTMInfo());
            TMClient.responseCollector.put(rgtid, rgtid);
            link.remoteXACommit(rgtid.getLTID(), false);
            byte response = rgtid.collector.waiting(TMConfig.commitTO);
            switch (response) {
                case 4: {
                    throw new XAException(5);
                }
            }
            return;
        }
        catch (TMException ex) {
            ex.printStackTrace();
            throw new XAException(106);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new XAException(-3);
        }
        finally {
            TMClient.responseCollector.remove(rgtid);
        }
    }

    public final void end(Xid xid, int flags) throws XAException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        try {
            RemoteGTID rgtid;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "end called for the xid : " + xid + ", and flag " + flags + ", rgtid : " + XID_MAPPER.get(xidString));
            }
            if (flags == 0x20000000 && (rgtid = (RemoteGTID)XID_MAPPER.remove(xidString)) != null) {
                if (!rgtid.isUnspecified()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "end called with TMFail for the xid : " + xid + ", rollback JEUS transaction");
                    }
                    this.rollback(rgtid, xid);
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "end called with TMFail for the xid : " + xid + ", invalidate JEUS gtid");
                    }
                    rgtid.invalidate();
                }
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new XAException(-3);
        }
    }

    public final void start(Xid xid, int flag) throws XAException {
        try {
            String xidString;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "start called for the xid : " + xid + ", and flag " + flag + ", gtid : " + Utility.getDump((byte[])xid.getGlobalTransactionId()) + ", bq : " + Utility.getDump((byte[])xid.getBranchQualifier()) + ", format ID : " + xid.getFormatId());
            }
            if (!XID_MAPPER.containsKey(xidString = XidToString.getGtidStringFromXid(xid))) {
                TMClient.create(xid, this.timeout);
                RemoteGTID gtid = (RemoteGTID)TMClient.contexts.get();
                XID_MAPPER.put(xidString, gtid);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Jeus GTID for the xid : " + xid + " is " + gtid);
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "the xid is already started, just return : " + xid);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new XAException(-3);
        }
        catch (NotSupportedException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void commit(Xid xid, boolean onePhaseCommit) throws XAException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        JTAResourceMBean mbean = (JTAResourceMBean)XID_TABLE.get(xidString);
        if (mbean != null) {
            try {
                mbean.commit(xid);
                return;
            }
            catch (XAException e) {
                throw e;
            }
            finally {
                RemoteGTID rgtid = (RemoteGTID)XID_MAPPER.remove(xidString);
                if (rgtid != null) {
                    rgtid.invalidate();
                }
                XID_TABLE.remove(xidString);
                PREPARED_XIDS.remove(xidString);
            }
        }
        RemoteGTID rgtid = null;
        try {
            byte response;
            rgtid = (RemoteGTID)XID_MAPPER.remove(xidString);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "commit called for xid " + xid + " with onePhaseCommit " + onePhaseCommit + ", jeus gtid : " + rgtid);
            }
            this.checkGTID(rgtid, xid, false);
            if (rgtid.isUnspecified()) {
                if (!logger.isLoggable(Level.FINE)) return;
                logger.log(Level.FINE, "start was called but no JEUS resource has been used for this xid : " + xid);
                return;
            }
            if (onePhaseCommit) {
                try {
                    TMClient.commit();
                    return;
                }
                catch (RollbackException e) {
                    e.printStackTrace();
                    throw new XAException(100);
                }
                catch (HeuristicMixedException e) {
                    e.printStackTrace();
                    throw new XAException(5);
                }
                catch (SystemException e) {
                    e.printStackTrace();
                    throw new XAException(-3);
                }
            }
            try {
                TMLink link = TMClient.linkManager.getLink(rgtid.getTMInfo());
                TMClient.responseCollector.put(rgtid, rgtid);
                link.remoteXACommit(rgtid.getLTID(), true);
                response = rgtid.collector.waiting(TMConfig.commitTO);
            }
            catch (TMException ex) {
                ex.printStackTrace();
                throw new XAException(106);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new XAException(-3);
            }
            finally {
                TMClient.responseCollector.remove(rgtid);
            }
            switch (response) {
                case 0: {
                    return;
                }
                case 1: {
                    throw new XAException(6);
                }
                case 4: {
                    throw new XAException(5);
                }
            }
            return;
        }
        finally {
            if (rgtid != null) {
                rgtid.invalidate();
            }
            PREPARED_XIDS.remove(xidString);
        }
    }

    private void checkGTID(RemoteGTID rgtid, Xid xid, boolean invalidateGTID) throws XAException {
        if (rgtid == null || rgtid.isInvalid()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "start is not called for this xid : " + xid);
            }
            throw new XAException(-4);
        }
        if (invalidateGTID) {
            rgtid.invalidate();
        }
    }

    static {
        try {
            TMClient.init(null);
        }
        catch (TMException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        XID_MAPPER = new ConcurrentHashMap();
        XID_TABLE = new ConcurrentHashMap();
        PREPARED_XIDS = new ConcurrentHashMap();
    }
}

