/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.xa.XAResource;
import jeus.connector.ConnectorFactory;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.transaction.TMException;
import jeus.transaction.logging.AbstractXAResourceFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_TM3;

public final class ConnectorXAResourceFactory
extends AbstractXAResourceFactory {
    private static final long serialVersionUID = -134614200505131685L;
    private transient ManagedConnection managedConnection;

    public ConnectorXAResourceFactory(Reference ref) {
        super(ref);
    }

    protected void open() throws Exception {
        String factoryClassName = this.ref.getFactoryClassName();
        if (factoryClassName.equals(ConnectorFactory.class.getName())) {
            String exportName;
            String moduleName = (String)this.ref.get(0).getContent();
            ManagedConnectionFactory mcf = ConnectorFactory.getManagedConnectionFactory(moduleName, exportName = (String)this.ref.get(1).getContent());
            if (mcf == null) {
                logger.logp(JeusMessage_TM3._5502_LEVEL, "TMServer", "getControlSession", JeusMessage_TM3._5502);
                ResourceAdapterModule.addRecoveredReference(this.ref);
                throw new ResourceException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM3._5502));
            }
            logger.logp(JeusMessage_TM3._5503_LEVEL, "TMServer", "getControlSession", JeusMessage_TM3._5503);
            this.managedConnection = mcf.createManagedConnection(null, null);
            logger.logp(JeusMessage_TM3._5504_LEVEL, "TMServer", "getControlSession", JeusMessage_TM3._5504);
            try {
                this.xaResource = this.managedConnection.getXAResource();
            }
            catch (ResourceException e) {
                this.close(null);
                throw e;
            }
        } else {
            throw new TMException("Unknown resource reference : " + factoryClassName);
        }
        logger.logp(JeusMessage_TM3._5505_LEVEL, "TMServer", "getControlSession", JeusMessage_TM3._5505);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(XAResource xaResource) {
        if (this.managedConnection != null) {
            try {
                logger.logp(JeusMessage_TM3._5493_LEVEL, "TMServer", "resyncXAResources", JeusMessage_TM3._5493);
                this.managedConnection.destroy();
            }
            catch (Throwable t) {
                logger.logp(JeusMessage_TM3._5494_LEVEL, "TMServer", "resyncXAResources", JeusMessage_TM3._5494, t);
            }
            finally {
                this.managedConnection = null;
            }
        }
        this.xaResource = null;
    }

    public String toString() {
        return "ConnectorXAResourceFactory[" + this.ref.getFactoryClassName() + ":" + this.ref.getClassName() + "]";
    }
}

