/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.management.j2ee.transaction.ReferenceInfo;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.TxStatus;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.XidImpl;
import jeus.transaction.external.OTSXid;
import jeus.transaction.logging.CoordinatorXAResourceFactory;
import jeus.transaction.logging.HowlLogManager;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.XidInfo;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.util.XidHashTable;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TMRecovery0;
import jeus.util.properties.JeusTMProperties;
import org.objectweb.howl.log.xa.XACommittingTx;

public class TxRecoveryDelegator {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.recovery");
    private final Object recoverySync = new Object();
    private boolean inRecovery = true;
    private final Map incompletedTxList = new Hashtable();
    private final Map incompletedTxXidList = new XidHashTable();
    private final Map incompletedOtsTxList = new Hashtable();
    private final Map currentResourceRefs = new Hashtable();
    private final Map recoveredResourceRefs = new Hashtable();
    private Map failedReferences;
    private HowlLogManager logManager;
    private TMInfo tmServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void doTxRecovery() {
        block19: {
            block18: {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1219_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1219_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1219);
                    logger.logp(JeusMessage_TMRecovery0._1220_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1220, (Object)new Integer(this.recoveredResourceRefs.size()));
                    logger.logp(JeusMessage_TMRecovery0._1221_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1221, (Object)new Integer(this.incompletedTxList.size()));
                    logger.logp(JeusMessage_TMRecovery0._1222_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1222, (Object)new Integer(this.incompletedTxXidList.size()));
                    logger.logp(JeusMessage_TMRecovery0._1232_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1232, (Object)new Integer(this.incompletedOtsTxList.size()));
                }
                if (!this.inRecovery) break block18;
                try {
                    Object resourceMonitor;
                    this.failedReferences = this.resyncXAResources(this.recoveredResourceRefs, true);
                    if (this.failedReferences.size() > 0 || this.logManager.moreIncompletedSubTx()) {
                        resourceMonitor = new Thread((Runnable)new ResourceMonitor(), "Resource Monitor");
                        ((Thread)resourceMonitor).setDaemon(true);
                        ((Thread)resourceMonitor).start();
                    } else if (JeusTMProperties.REMOVE_INCOMPLETE_TX) {
                        this.removeRecoveredIncompleteTxs();
                    }
                    resourceMonitor = this.recoverySync;
                }
                catch (Throwable throwable) {
                    Object object = this.recoverySync;
                    // MONITORENTER : object
                    this.inRecovery = false;
                    this.recoverySync.notifyAll();
                    // MONITOREXIT : object
                    throw throwable;
                }
                this.inRecovery = false;
                this.recoverySync.notifyAll();
                // MONITOREXIT : resourceMonitor
                break block19;
            }
            Map map = this.incompletedTxList;
            // MONITORENTER : map
            Map map2 = this.currentResourceRefs;
            // MONITORENTER : map2
            Map currentFailedReferences = this.resyncXAResources(this.currentResourceRefs, false);
            // MONITOREXIT : map2
            if (currentFailedReferences.size() == 0 && JeusTMProperties.REMOVE_INCOMPLETE_TX) {
                this.removeCurrentIncompleteTx();
            }
            // MONITOREXIT : map
        }
        if (!logger.isLoggable(JeusMessage_TMRecovery0._1223_LEVEL)) return;
        logger.logp(JeusMessage_TMRecovery0._1223_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1223);
        logger.logp(JeusMessage_TMRecovery0._1220_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1220, (Object)new Integer(this.recoveredResourceRefs.size()));
        logger.logp(JeusMessage_TMRecovery0._1221_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1221, (Object)new Integer(this.incompletedTxList.size()));
        Iterator i = this.incompletedTxList.keySet().iterator();
        block10: while (true) {
            if (!i.hasNext()) {
                logger.logp(JeusMessage_TMRecovery0._1222_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1222, (Object)new Integer(this.incompletedTxXidList.size()));
                logger.logp(JeusMessage_TMRecovery0._1232_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1232, (Object)new Integer(this.incompletedOtsTxList.size()));
                logger.logp(JeusMessage_TMRecovery0._1230_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1230, (Object)this.logManager.getSubXidContainer().getInformation("\t"));
                logger.logp(JeusMessage_TMRecovery0._1229_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1229, (Object)new Integer(this.failedReferences.size()));
                return;
            }
            IncompletedTx incompletedTx = (IncompletedTx)i.next();
            logger.logp(JeusMessage_TMRecovery0._1224_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1224, (Object)new Long(incompletedTx.getLTID()));
            logger.logp(JeusMessage_TMRecovery0._1225_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1225, (Object)new Integer(incompletedTx.getTime()));
            logger.logp(JeusMessage_TMRecovery0._1226_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1226, (Object)XidToString.getXidString(incompletedTx.getExternalXid()));
            logger.logp(JeusMessage_TMRecovery0._1227_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1227);
            ArrayList childXids = incompletedTx.getChildXids();
            int j = 0;
            while (true) {
                if (j >= childXids.size()) continue block10;
                XidInfo xidInfo = (XidInfo)childXids.get(j);
                logger.logp(JeusMessage_TMRecovery0._1228_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1228, (Object)XidToString.getXidString(xidInfo.getXid()));
                ++j;
            }
            break;
        }
    }

    private void removeCurrentIncompleteTx() {
        Iterator i = this.incompletedTxList.keySet().iterator();
        while (i.hasNext()) {
            IncompletedTx incompletedTx = (IncompletedTx)i.next();
            if (incompletedTx.isRecovered() || incompletedTx.getExternalXid() != null) continue;
            this.logManager.logXaDone((XACommittingTx)incompletedTx.getHandback());
            i.remove();
        }
    }

    private void removeRecoveredIncompleteTxs() {
        Iterator i = this.incompletedTxList.keySet().iterator();
        while (i.hasNext()) {
            IncompletedTx incompletedTx = (IncompletedTx)i.next();
            if (incompletedTx.getExternalXid() != null || !incompletedTx.isRecovered()) continue;
            this.logManager.logXaDone((XACommittingTx)incompletedTx.getHandback());
            i.remove();
        }
    }

    public boolean recoverAllTx(Xid[] xids, XAResource xaResource, ReferenceInfo info) {
        HashSet<Xid> notRecoveredXids = new HashSet<Xid>();
        HashMap<IncompletedTx, IncompletedTx> recoverTx = new HashMap<IncompletedTx, IncompletedTx>();
        for (int k = 0; k < xids.length; ++k) {
            GTID gtid;
            Xid xid = xids[k];
            if (xid == null || (gtid = TxRecoveryDelegator.getGTIDFromXid(xid)) == null) continue;
            if (this.tmServer.isGeneratedAtThisTM(gtid)) {
                IncompletedTx tx = this.getIncompletedTx(gtid.getLTID(), gtid.getTime());
                if (tx == null) {
                    if (this.logManager.isRunningTx(gtid.getLTID())) {
                        continue;
                    }
                } else {
                    recoverTx.put(tx, tx);
                }
                byte decision = TxRecoveryDelegator.getDecision(tx);
                if (logger.isLoggable(JeusMessage_TMRecovery0._1204_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1204_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1204, new Object[]{XidToString.getXidString(xid), decision == -1 ? "external" : "root", TxStatus.getState(decision), gtid});
                }
                try {
                    if (TxRecoveryDelegator.applyDecision(decision, xid, xaResource)) continue;
                    notRecoveredXids.add(xid);
                    if (tx == null) continue;
                    tx.addChildXid(xid, info);
                }
                catch (Throwable ex) {
                    notRecoveredXids.add(xid);
                    if (tx != null) {
                        tx.addChildXid(xid, info);
                    }
                    if (!logger.isLoggable(JeusMessage_TMRecovery0._1208_LEVEL)) continue;
                    logger.logp(JeusMessage_TMRecovery0._1208_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1208, new Object[]{XidToString.getXidString(xid), TxStatus.getState(decision)}, ex);
                }
                continue;
            }
            if (TxRecoveryDelegator.isXidAssociatedWithThisTM(xid)) {
                notRecoveredXids.add(xid);
                TMInfo tmInfo = gtid.getTMInfo();
                if (logger.isLoggable(JeusMessage_TMRecovery0._1204_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1204_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1204, new Object[]{XidToString.getXidString(xid), "sub", "unknown", gtid});
                }
                this.logManager.addToSubXidContainer(tmInfo, xid, info);
                continue;
            }
            if (!logger.isLoggable(JeusMessage_TMRecovery0._1210_LEVEL)) continue;
            logger.logp(JeusMessage_TMRecovery0._1210_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1210, (Object)XidToString.getXidString(xid));
        }
        Iterator iter = recoverTx.values().iterator();
        while (iter.hasNext()) {
            this.checkChildXids((IncompletedTx)iter.next());
        }
        recoverTx.clear();
        if (notRecoveredXids.size() == 0) {
            return true;
        }
        info.setPendingXids(notRecoveredXids);
        return false;
    }

    private boolean checkChildXids(IncompletedTx tx) {
        if (tx == null) {
            return true;
        }
        ArrayList childs = tx.getChildXids();
        if (childs == null) {
            return true;
        }
        if (childs.isEmpty()) {
            this.logManager.logXaDone((XACommittingTx)tx.getHandback());
            Xid externalXid = tx.getExternalXid();
            if (externalXid != null) {
                this.removeTxFromXidList(externalXid, tx.getResource());
            }
            this.removeTxFromIncompletedTxList(tx);
            return true;
        }
        return false;
    }

    static GTID getGTIDFromXid(Xid xid) {
        if (xid.getFormatId() == 9736) {
            try {
                return new GTID(xid.getGlobalTransactionId());
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1209_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1209_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1209, (Object)XidToString.getXidString(xid));
                }
                return null;
            }
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1209_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1209_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1209, (Object)XidToString.getXidString(xid));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map resyncCurrentXAResources() {
        Map map = this.currentResourceRefs;
        synchronized (map) {
            return this.resyncXAResources(this.currentResourceRefs, false);
        }
    }

    public Map resyncXAResources(Map recoveredResourceMap, boolean removeResource) {
        Hashtable<ReferenceInfo, ReferenceInfo> failedReferenceList = new Hashtable<ReferenceInfo, ReferenceInfo>();
        ArrayList<XAResourceItem> oldXaResourceItems = new ArrayList<XAResourceItem>();
        Iterator iterator = recoveredResourceMap.keySet().iterator();
        while (iterator.hasNext()) {
            XAResource xaResource = null;
            ReferenceInfo reference = (ReferenceInfo)iterator.next();
            XAResourceFactory xaResourceFactory = reference.getResourceReference();
            if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)reference);
            }
            try {
                xaResource = xaResourceFactory.getXAResource();
                if (xaResource == null) {
                    throw new TMException("failed to get a XAResource. XAResource is null");
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1211_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1211_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1211, (Object)reference, (Throwable)e);
                }
                failedReferenceList.put(reference, reference);
                continue;
            }
            if (!this.isAlreadyRecovered(xaResource, oldXaResourceItems)) {
                oldXaResourceItems.add(new XAResourceItem(xaResourceFactory, xaResource));
                Xid[] xids = null;
                try {
                    xids = xaResource.recover(0x1000000);
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_TMRecovery0._1217_LEVEL) && ex instanceof XAException) {
                        logger.logp(JeusMessage_TMRecovery0._1217_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1217, (Object)XidToString.getXAErrorCode(((XAException)ex).errorCode), ex);
                    }
                    if (logger.isLoggable(JeusMessage_TMRecovery0._1212_LEVEL)) {
                        logger.logp(JeusMessage_TMRecovery0._1212_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1212, (Object)xaResource, ex);
                    }
                    failedReferenceList.put(reference, reference);
                    continue;
                }
                if (logger.isLoggable(JeusMessage_TMRecovery0._1203_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1203_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1203, new Object[]{xaResource, String.valueOf(xids.length)});
                }
                if (!this.recoverAllTx(xids, xaResource, reference) || !removeResource) continue;
                this.logManager.logResourceDone((XACommittingTx)reference.getHandback());
                iterator.remove();
                continue;
            }
            if (logger.isLoggable(JeusMessage_TMRecovery0._1202_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1202_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1202, (Object)xaResource);
            }
            if (removeResource) {
                iterator.remove();
                this.logManager.logResourceDone((XACommittingTx)reference.getHandback());
            }
            if (xaResource == null) continue;
            xaResourceFactory.close(xaResource);
        }
        for (XAResourceItem storedXaResourceItem : oldXaResourceItems) {
            storedXaResourceItem.getXaResourceFactory().close(storedXaResourceItem.getXaResource());
        }
        oldXaResourceItems.clear();
        return failedReferenceList;
    }

    private boolean isAlreadyRecovered(XAResource currentXaResource, List oldXaResourceItems) {
        for (XAResourceItem xaResourceItem : oldXaResourceItems) {
            try {
                if (!currentXaResource.isSameRM(xaResourceItem.getXaResource())) continue;
                return true;
            }
            catch (XAException e) {
                if (!logger.isLoggable(JeusMessage_TMRecovery0._1231_LEVEL)) continue;
                logger.logp(JeusMessage_TMRecovery0._1231_LEVEL, "TxRecoveryDelegator", "isAlreadyRecovered", JeusMessage_TMRecovery0._1231, new Object[]{XidToString.getXAErrorCode(e.errorCode), currentXaResource}, (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resyncChildTx(IncompletedTx tx, Xid xid) {
        byte decision = TxRecoveryDelegator.getDecision(tx);
        ArrayList childrenXids = tx.getChildXids();
        Iterator iter = childrenXids.iterator();
        while (iter.hasNext()) {
            XidInfo xidInfo = (XidInfo)iter.next();
            ReferenceInfo refInfo = xidInfo.getReferenceInfo();
            XAResourceFactory xaResourceFactory = refInfo.getResourceReference();
            Xid childXid = xidInfo.getXid();
            XAResource xaResource = null;
            try {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)refInfo);
                }
                xaResource = xaResourceFactory.getXAResource();
                if (logger.isLoggable(JeusMessage_TMRecovery0._1213_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1213_LEVEL, "TxRecoveryDelegator", "resyncChildTx", JeusMessage_TMRecovery0._1213, new Object[]{TxStatus.getState(decision), XidToString.getXidString(childXid), XidToString.getXidString(xid), xaResource});
                }
                if (!TxRecoveryDelegator.applyDecision(decision, childXid, xaResource)) continue;
                refInfo.removePendingXid(childXid);
                iter.remove();
            }
            catch (XAException e) {
                if (!logger.isLoggable(JeusMessage_TMRecovery0._1233_LEVEL)) continue;
                logger.logp(JeusMessage_TMRecovery0._1233_LEVEL, "TxRecoveryDelegator", "isAlreadyRecovered", JeusMessage_TMRecovery0._1233, (Object)XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (xaResource == null) continue;
                xaResourceFactory.close(xaResource);
            }
        }
        return this.checkChildXids(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forgetChildTx(List childrenXids, Xid xid) {
        boolean completionDone = true;
        if (childrenXids == null) {
            return completionDone;
        }
        Iterator iter = childrenXids.iterator();
        while (iter.hasNext()) {
            XidInfo xidInfo = (XidInfo)iter.next();
            ReferenceInfo refInfo = xidInfo.getReferenceInfo();
            XAResourceFactory xaResourceFactory = refInfo.getResourceReference();
            Xid childXid = xidInfo.getXid();
            XAResource xaResource = null;
            try {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)refInfo);
                }
                xaResource = xaResourceFactory.getXAResource();
                if (logger.isLoggable(JeusMessage_TMRecovery0._1213_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1213_LEVEL, "TxRecoveryDelegator", "resyncChildTx", JeusMessage_TMRecovery0._1213, new Object[]{"forget", XidToString.getXidString(childXid), XidToString.getXidString(xid), xaResource});
                }
                xaResource.forget(childXid);
                refInfo.removePendingXid(childXid);
                iter.remove();
            }
            catch (XAException e) {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1233_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1233_LEVEL, "TxRecoveryDelegator", "isAlreadyRecovered", JeusMessage_TMRecovery0._1233, (Object)XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
                }
                completionDone = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                completionDone = false;
            }
            finally {
                if (xaResource == null) continue;
                xaResourceFactory.close(xaResource);
            }
        }
        return completionDone;
    }

    public static boolean applyDecision(byte decision, Xid xid, XAResource xaRsc) throws XAException {
        if (decision == 0) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1205_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1205_LEVEL, "TxRecoveryDelegator", "applyDecision", JeusMessage_TMRecovery0._1205, new Object[]{XidToString.getXidString(xid), xaRsc});
            }
            xaRsc.commit(xid, false);
            return true;
        }
        if (decision == 1) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1206_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1206_LEVEL, "TxRecoveryDelegator", "applyDecision", JeusMessage_TMRecovery0._1206, new Object[]{XidToString.getXidString(xid), xaRsc});
            }
            xaRsc.rollback(xid);
            return true;
        }
        if (decision == -1 && logger.isLoggable(JeusMessage_TMRecovery0._1207_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1207_LEVEL, "TxRecoveryDelegator", "applyDecision", JeusMessage_TMRecovery0._1207, (Object)XidToString.getXidString(xid));
        }
        return false;
    }

    public static byte getDecision(IncompletedTx tx) {
        if (tx == null) {
            return 1;
        }
        return tx.getDecision();
    }

    static boolean isXidAssociatedWithThisTM(Xid xid) {
        byte[] bq = xid.getBranchQualifier();
        for (int j = 0; j < TMServer.bqbase.length - 4; ++j) {
            if (TMServer.bqbase[j] == bq[j + 1]) continue;
            return false;
        }
        return true;
    }

    IncompletedTx getIncompletedTx(long ltid, int time) {
        IncompletedTx tx = new IncompletedTx(ltid, time);
        tx = (IncompletedTx)this.incompletedTxList.get(tx);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceInfo[] getRecoveredXAResourceInfo() {
        Map map = this.recoveredResourceRefs;
        synchronized (map) {
            Collection set = this.recoveredResourceRefs.values();
            return set.toArray(new ReferenceInfo[set.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceInfo[] getCurrentXAResourceInfo() {
        Map map = this.currentResourceRefs;
        synchronized (map) {
            Collection set = this.currentResourceRefs.values();
            return set.toArray(new ReferenceInfo[set.size()]);
        }
    }

    public IncompletedTx[] getAllIncompletedTx() {
        Collection collection = this.incompletedTxList.values();
        return collection.toArray(new IncompletedTx[collection.size()]);
    }

    public boolean hasIncompletedTx() {
        return this.incompletedTxList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForRecovery() {
        if (!this.inRecovery) {
            return;
        }
        Object object = this.recoverySync;
        synchronized (object) {
            if (!this.inRecovery) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TMRecovery0._1214_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1214_LEVEL, "TxRecoveryDelegator", "resyncChildTx", JeusMessage_TMRecovery0._1214);
            }
            try {
                this.recoverySync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean failedRsrcRemains() {
        if (this.failedReferences.size() > 0) {
            for (ReferenceInfo refInfo : this.failedReferences.keySet()) {
                XAResourceFactory rsc = refInfo.getResourceReference();
                if (rsc instanceof CoordinatorXAResourceFactory) continue;
                return true;
            }
        }
        return false;
    }

    public int failedResourceSize() {
        if (this.failedReferences == null) {
            return -1;
        }
        return this.failedReferences.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCurrentResourceRef(ReferenceInfo key, ReferenceInfo value) {
        Map map = this.currentResourceRefs;
        synchronized (map) {
            this.currentResourceRefs.put(key, value);
        }
    }

    public void start(HowlLogManager howlLogManager, TMInfo tmServer) {
        this.logManager = howlLogManager;
        this.tmServer = tmServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCurrentResourceReferences() {
        Map map = this.currentResourceRefs;
        synchronized (map) {
            for (ReferenceInfo info : this.currentResourceRefs.keySet()) {
                this.logManager.logResourceDone((XACommittingTx)info.getHandback());
            }
            this.currentResourceRefs.clear();
        }
    }

    public void addIncompletedTx(IncompletedTx key, IncompletedTx value, Xid xid, ResourceImpl otsResource) {
        IncompletedTx oldIncompletedTx = null;
        if (xid != null) {
            if (!(xid instanceof OTSXid)) {
                oldIncompletedTx = this.incompletedTxXidList.put(xid, value);
            } else if (otsResource != null) {
                oldIncompletedTx = this.incompletedTxXidList.put(xid, value);
                this.incompletedOtsTxList.put(otsResource, value);
            }
        }
        if (oldIncompletedTx != null) {
            this.incompletedTxList.remove(oldIncompletedTx);
            this.incompletedTxList.put(key, value);
        } else {
            this.incompletedTxList.put(key, value);
        }
    }

    public IncompletedTx getTxFromXidList(Xid xid) {
        IncompletedTx tx = (IncompletedTx)this.incompletedTxXidList.get(xid);
        if (tx == null && xid.getFormatId() != 9736) {
            XidImpl xidClone = new XidImpl(xid.getGlobalTransactionId(), xid.getBranchQualifier(), 9736);
            tx = (IncompletedTx)this.incompletedTxXidList.get(xidClone);
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1215_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1215_LEVEL, "TxRecoveryDelegator", "getTxFromXidList", JeusMessage_TMRecovery0._1215, new Object[]{XidToString.getXidString(xid), tx});
        }
        return tx;
    }

    public IncompletedTx removeTxFromXidList(Xid xid, ResourceImpl resource) {
        Object obj;
        IncompletedTx tx = (IncompletedTx)this.incompletedTxXidList.remove(xid);
        if (resource != null && (obj = this.incompletedOtsTxList.remove(resource)) == null) {
            throw new RuntimeException("Internal error");
        }
        return tx;
    }

    public IncompletedTx removeTxFromIncompletedTxList(IncompletedTx tx) {
        return (IncompletedTx)this.incompletedTxList.remove(tx);
    }

    public ReferenceInfo removeRecoveredResourceRef(ReferenceInfo info) {
        return (ReferenceInfo)this.recoveredResourceRefs.remove(info);
    }

    public Xid[] getIncompletedExternalXids() {
        Set xidSet = this.incompletedTxXidList.keySet();
        return xidSet.toArray(new Xid[xidSet.size()]);
    }

    public void addRecorveredResourceRef(ReferenceInfo key, ReferenceInfo value) {
        this.recoveredResourceRefs.put(key, value);
    }

    public boolean inRecovery() {
        return this.inRecovery;
    }

    public boolean isCompletedTx(IncompletedTx tx) {
        return tx == null || this.incompletedTxList.containsKey(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.recoverySync;
        synchronized (object) {
            this.inRecovery = false;
            this.recoverySync.notifyAll();
        }
        this.incompletedTxList.clear();
        this.incompletedTxXidList.clear();
        this.incompletedOtsTxList.clear();
        this.recoveredResourceRefs.clear();
        this.currentResourceRefs.clear();
        if (this.failedReferences != null) {
            this.failedReferences.clear();
            this.failedReferences = null;
        }
    }

    ResourceImpl[] getIncompletedOtsResources() {
        return this.incompletedOtsTxList.keySet().toArray(new ResourceImpl[this.incompletedOtsTxList.size()]);
    }

    public IncompletedTx getIncompletedOtsTx(ResourceImpl rsc) {
        return (IncompletedTx)this.incompletedOtsTxList.get(rsc);
    }

    public Map getIncompletedTxList() {
        return this.incompletedTxList;
    }

    public Map getIncompletedTxXidList() {
        return this.incompletedTxXidList;
    }

    public Map getCurrentResourcesRefs() {
        return this.currentResourceRefs;
    }

    public Map getRecoveredResourcesRefs() {
        return this.recoveredResourceRefs;
    }

    private final class ResourceMonitor
    implements Runnable {
        private int retryCount = 0;

        private ResourceMonitor() {
        }

        public final void run() {
            try {
                while ((TxRecoveryDelegator.this.failedReferences.size() > 0 || TxRecoveryDelegator.this.logManager.moreIncompletedSubTx()) && ++this.retryCount <= JeusTMProperties.RECOVERY_RETRIAL) {
                    if (logger.isLoggable(JeusMessage_TMRecovery0._1218_LEVEL)) {
                        logger.logp(JeusMessage_TMRecovery0._1218_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1218, (Object)Integer.toString(this.retryCount));
                    }
                    if (TxRecoveryDelegator.this.logManager.moreIncompletedSubTx()) {
                        TxRecoveryDelegator.this.logManager.replayCompletionForSubTx();
                    }
                    Thread.sleep(120000L);
                    if (TxRecoveryDelegator.this.failedReferences.size() <= 0) continue;
                    TxRecoveryDelegator.this.failedReferences = TxRecoveryDelegator.this.resyncXAResources(TxRecoveryDelegator.this.failedReferences, true);
                }
                if (JeusTMProperties.REMOVE_INCOMPLETE_TX) {
                    TxRecoveryDelegator.this.removeRecoveredIncompleteTxs();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class XAResourceItem {
        private XAResourceFactory xaResourceFactory;
        private XAResource xaResource;

        public XAResourceItem(XAResourceFactory xaResourceFactory, XAResource xaResource) {
            this.xaResourceFactory = xaResourceFactory;
            this.xaResource = xaResource;
        }

        public XAResourceFactory getXaResourceFactory() {
            return this.xaResourceFactory;
        }

        public XAResource getXaResource() {
            return this.xaResource;
        }
    }
}

