/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jeus.transaction.TMServer;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import jeus.util.properties.JeusTMProperties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class RecoveryManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");

    public void startOtsRecovery() {
        ResourceImpl[] resources = TMServer.getIncompletedOtsResources();
        if (logger.isLoggable(JeusMessage_OTS0._1101_LEVEL)) {
            logger.logp(JeusMessage_OTS0._1101_LEVEL, "RecoveryManager", "startOtsRecovery", JeusMessage_OTS0._1101, (Object)new Integer(resources.length));
        }
        if (resources.length > 0) {
            ArrayList<ResourceImpl> list = new ArrayList<ResourceImpl>();
            for (int i = 0; i < resources.length; ++i) {
                list.add(resources[i]);
            }
            OTSRecoveryThread otsRecoveryThread = new OTSRecoveryThread(list);
            otsRecoveryThread.setDaemon(true);
            otsRecoveryThread.start();
        }
    }

    public void replayOtsRecovery(ResourceImpl resource) {
        ArrayList<ResourceImpl> list = new ArrayList<ResourceImpl>();
        list.add(resource);
        if (logger.isLoggable(JeusMessage_OTS0._1102_LEVEL)) {
            logger.logp(JeusMessage_OTS0._1102_LEVEL, "RecoveryManager", "startOtsRecovery", JeusMessage_OTS0._1102);
        }
        OTSRecoveryThread otsRecoveryThread = new OTSRecoveryThread(list);
        otsRecoveryThread.setDaemon(true);
        otsRecoveryThread.start();
    }

    private boolean setDecision(RecoveryCoordinator coord, ResourceImpl resources) {
        block27: {
            Status decision;
            Resource rsc = resources.object();
            try {
                if (logger.isLoggable(JeusMessage_OTS0._1103_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1103_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1103, (Object)resources.getOTSXid());
                }
                decision = coord.replay_completion(rsc);
            }
            catch (OBJECT_NOT_EXIST ex) {
                decision = Status.StatusRolledBack;
                ex.printStackTrace();
            }
            catch (NotPrepared notPrepared) {
                if (logger.isLoggable(JeusMessage_OTS0._1104_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1104_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1104, (Object)rsc);
                }
                notPrepared.printStackTrace();
                return false;
            }
            catch (COMM_FAILURE ex) {
                if (logger.isLoggable(JeusMessage_OTS0._1105_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1105_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1105, (Object)rsc);
                }
                ex.printStackTrace();
                return false;
            }
            if (logger.isLoggable(JeusMessage_OTS0._1106_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1106_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1106, new Object[]{resources.getOTSXid(), this.getDecisionString(decision)});
            }
            try {
                switch (decision.value()) {
                    case 4: {
                        if (logger.isLoggable(JeusMessage_OTS0._1107_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1107_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1107, (Object)rsc);
                        }
                        resources.rollback();
                        return true;
                    }
                    case 3: {
                        if (logger.isLoggable(JeusMessage_OTS0._1108_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1108_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1108, (Object)rsc);
                        }
                        resources.commit();
                        return true;
                    }
                    case 5: {
                        if (logger.isLoggable(JeusMessage_OTS0._1109_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1109_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1109, (Object)rsc);
                        }
                        break;
                    }
                    default: {
                        if (logger.isLoggable(JeusMessage_OTS0._1110_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1110_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1110, new Object[]{this.getDecisionString(decision), rsc});
                        }
                        break;
                    }
                }
            }
            catch (NotPrepared notPrepared) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1111, (Object)rsc, (Throwable)((Object)notPrepared));
                }
            }
            catch (HeuristicMixed heuristicMixed) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1111, (Object)rsc, (Throwable)((Object)heuristicMixed));
                }
            }
            catch (HeuristicHazard heuristicHazard) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1111, (Object)rsc, (Throwable)((Object)heuristicHazard));
                }
            }
            catch (HeuristicRollback heuristicRollback) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1111, (Object)rsc, (Throwable)((Object)heuristicRollback));
                }
            }
            catch (HeuristicCommit heuristicCommit) {
                if (!logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) break block27;
                logger.logp(JeusMessage_OTS0._1111_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1111, (Object)rsc, (Throwable)((Object)heuristicCommit));
            }
        }
        return false;
    }

    private String getDecisionString(Status decision) {
        switch (decision.value()) {
            case 0: {
                return "StatusActive";
            }
            case 3: {
                return "StatusCommitted";
            }
            case 8: {
                return "StatusCommitting";
            }
            case 1: {
                return "StatusMarkedRollback";
            }
            case 6: {
                return "StatusNoTransaction";
            }
            case 2: {
                return "StatusPrepared";
            }
            case 7: {
                return "StatusPreparing";
            }
            case 4: {
                return "StatusRolledBack";
            }
            case 9: {
                return "StatusRollingBack";
            }
            case 5: {
                return "StatusUnknown";
            }
        }
        return "UnknownValue";
    }

    private class OTSRecoveryThread
    extends Thread {
        private List resourceImplList;

        public OTSRecoveryThread(List list) {
            this.resourceImplList = list;
        }

        public void run() {
            while (this.resourceImplList.size() > 0) {
                if (logger.isLoggable(JeusMessage_OTS0._1112_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1112_LEVEL, "RecoveryManager", "setDecision", JeusMessage_OTS0._1112, (Object)new Integer(this.resourceImplList.size()));
                }
                Iterator i = this.resourceImplList.iterator();
                while (i.hasNext()) {
                    ResourceImpl resource = (ResourceImpl)i.next();
                    RecoveryCoordinator coord = resource.getRecoveryCoordinator();
                    if (!RecoveryManager.this.setDecision(coord, resource)) continue;
                    i.remove();
                }
                try {
                    Thread.sleep(JeusTMProperties.OTS_REPLAY_INTERVAL);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

