/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import java.util.logging.Level;
import jeus.ejb.interop.ORBUtil;
import jeus.transaction.GTID;
import jeus.transaction.ThreadContexts;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.GlobalTID;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.StatusHolder;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;

public class SenderImpl
implements Sender {
    public static final int JEUS_TX_FORMAT_ID = 9736;
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");

    public void sending_request(int i, PropagationContextHolder propagationcontextholder) {
        PropagationContext ctx;
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "sending_request called, gtid : {0}", (Object)gtid);
            if (gtid != null) {
                logger.log(Level.FINER, "gtid byte : {0}", (Object)Utility.getDump((byte[])gtid.toBytes()));
            }
        }
        if (gtid == null || gtid.isInvalid()) {
            INVALID_TRANSACTION ex2 = new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
            throw ex2;
        }
        propagationcontextholder.value = ctx = SenderImpl.get_txcontext(gtid);
    }

    public void received_reply(int i, PropagationContext context, Environment environment) throws WrongTransaction {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        if (gtid == null || gtid.isInvalid()) {
            return;
        }
        Exception ctxExc = environment.exception();
        if (ctxExc instanceof SystemException) {
            RootCoordinator coord = ThreadContexts.getCoordinator(gtid.getLTID());
            if (coord == null) {
                return;
            }
            coord.setRollbackOnly();
        }
        if (context == null || context.current == null || context.current.coord == null || context.current.otid.formatID == -1) {
            return;
        }
        StatusHolder outStatus = new StatusHolder();
        outStatus.value = Status.StatusRolledBack;
        GlobalTID globalTID = new GlobalTID(((OTSXid)gtid.getExternalXid()).getPropagationContext().current.otid);
        if (!globalTID.equals(context.current.otid)) {
            throw new WrongTransaction();
        }
    }

    public static PropagationContext get_txcontext(GTID gtid) {
        OTSXid xid = (OTSXid)gtid.getExternalXid();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "existing xid for gtid {0} : {1}", new Object[]{gtid, xid});
        }
        if (xid != null) {
            return xid.getPropagationContext();
        }
        RootCoordinator coord = ThreadContexts.getCoordinator(gtid.getLTID());
        long timeLeft = coord.getTimeout() - System.currentTimeMillis();
        int timeout = 0;
        if (timeLeft > 0L) {
            timeout = timeLeft / 1000L > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(timeLeft / 1000L);
        }
        Coordinator otsCoordinator = coord.getOTSCoordinator();
        return SenderImpl.makePropagationContext(gtid, otsCoordinator, timeout);
    }

    public static PropagationContext makePropagationContext(GTID gtid, Coordinator otsCoordinator, int timeout) {
        byte[] jeus_otid = new byte[OTSXid.JEUS_TID_PREFIX.length + gtid.getByteLength() + 1];
        gtid.toBytes(jeus_otid, OTSXid.JEUS_TID_PREFIX.length);
        System.arraycopy(OTSXid.JEUS_TID_PREFIX, 0, jeus_otid, 0, OTSXid.JEUS_TID_PREFIX.length);
        TransIdentity current = new TransIdentity(otsCoordinator, null, new otid_t(9736, 1, jeus_otid));
        PropagationContext context = new PropagationContext(timeout, current, new TransIdentity[0], ORBUtil.implementation_specific_data);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "context made, jeus_gtid : {0}", (Object)Utility.getDump((byte[])jeus_otid));
        }
        gtid.setExternalXid(new OTSXid(context));
        return context;
    }
}

