/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.impl;

import javax.transaction.xa.XAException;
import jeus.transaction.TMXAResource;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.Configuration;
import jeus.transaction.ots.jta.JTAConverter;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class ResourceImpl
extends ResourcePOA
implements Resource {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");
    private static final TMXAResource manager = TMXAResource.getTMXAResource();
    private OTSXid xid;
    private RecoveryCoordinator recoveryCoord;
    private transient boolean isAlreadyCompleted;
    private transient POA poa;
    private transient Resource thisRef;

    public ResourceImpl(OTSXid xid) {
        this.xid = xid;
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        int result;
        try {
            result = manager.prepare(this.xid, this);
        }
        catch (XAException e) {
            if (logger.isLoggable(JeusMessage_Manager1._468_LEVEL)) {
                logger.log(JeusMessage_Manager1._468_LEVEL, JeusMessage_Manager1._468, (java.lang.Object)XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
            }
            e.printStackTrace();
            return Vote.VoteRollback;
        }
        return JTAConverter.getTxVote(result);
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        if (this.isAlreadyCompleted) {
            if (logger.isLoggable(JeusMessage_Manager1._467_LEVEL)) {
                logger.log(JeusMessage_Manager1._467_LEVEL, JeusMessage_Manager1._467, (java.lang.Object)this.xid);
            }
            return;
        }
        try {
            manager.rollback(this.xid);
        }
        catch (XAException e) {
            if (logger.isLoggable(JeusMessage_Manager1._449_LEVEL)) {
                logger.log(JeusMessage_Manager1._449_LEVEL, JeusMessage_Manager1._449, (java.lang.Object)XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
            }
            throw new HeuristicHazard();
        }
        finally {
            this.isAlreadyCompleted = true;
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        if (this.isAlreadyCompleted) {
            if (logger.isLoggable(JeusMessage_Manager1._467_LEVEL)) {
                logger.log(JeusMessage_Manager1._467_LEVEL, JeusMessage_Manager1._467, (java.lang.Object)this.xid);
            }
            return;
        }
        try {
            manager.commit(this.xid, false);
        }
        catch (XAException e) {
            if (logger.isLoggable(JeusMessage_Manager1._450_LEVEL)) {
                logger.log(JeusMessage_Manager1._450_LEVEL, JeusMessage_Manager1._450, (Throwable)e);
            }
        }
        finally {
            this.isAlreadyCompleted = true;
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit_one_phase() throws HeuristicHazard {
        if (this.isAlreadyCompleted) {
            if (logger.isLoggable(JeusMessage_Manager1._467_LEVEL)) {
                logger.log(JeusMessage_Manager1._467_LEVEL, JeusMessage_Manager1._467, (java.lang.Object)this.xid);
            }
            return;
        }
        try {
            try {
                manager.commit(this.xid, true);
            }
            catch (XAException e) {
                if (logger.isLoggable(JeusMessage_Manager1._450_LEVEL)) {
                    logger.log(JeusMessage_Manager1._450_LEVEL, JeusMessage_Manager1._450, (java.lang.Object)XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
                }
                throw new HeuristicHazard();
            }
        }
        finally {
            this.isAlreadyCompleted = true;
            this.destroy();
        }
    }

    public void forget() {
        if (this.isAlreadyCompleted) {
            if (logger.isLoggable(JeusMessage_Manager1._467_LEVEL)) {
                logger.log(JeusMessage_Manager1._467_LEVEL, JeusMessage_Manager1._467, (java.lang.Object)this.xid);
            }
            return;
        }
        try {
            manager.forget(this.xid);
        }
        catch (XAException e) {
            this.isAlreadyCompleted = true;
            e.printStackTrace();
        }
    }

    public void setRecoveryCoordinator(RecoveryCoordinator recoveryCoord) {
        this.recoveryCoord = recoveryCoord;
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this.recoveryCoord;
    }

    public final synchronized Resource object() {
        if (this.thisRef == null) {
            if (this.poa == null) {
                this.poa = Configuration.getPOA("OTSCoordinatorPOA");
            }
            try {
                byte[] idBytes = this.xid.getOTID();
                this.poa.activate_object_with_id(idBytes, (Servant)this);
                Object obj = this.poa.create_reference_with_id(idBytes, ResourceHelper.id());
                this.thisRef = ResourceHelper.narrow(obj);
            }
            catch (Exception exc) {
                if (logger.isLoggable(JeusMessage_OTS0._1209_LEVEL)) {
                    logger.log(JeusMessage_OTS0._1209_LEVEL, JeusMessage_OTS0._1209, (Throwable)exc);
                }
                throw new INTERNAL("jts.create_coordinator_object_error");
            }
        }
        return this.thisRef;
    }

    public final synchronized void destroy() {
        block6: {
            try {
                if (this.poa != null && this.thisRef != null) {
                    this.poa.deactivate_object(this.poa.reference_to_id((Object)this.thisRef));
                    this.thisRef = null;
                } else {
                    POA rcPoa = this.poa == null ? Configuration.getPOA("OTSCoordinatorPOA") : this.poa;
                    if (this.thisRef == null) {
                        rcPoa.deactivate_object(rcPoa.servant_to_id((Servant)this));
                    } else {
                        rcPoa.deactivate_object(rcPoa.reference_to_id((Object)this.thisRef));
                        this.thisRef = null;
                    }
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(JeusMessage_OTS0._1205_LEVEL)) break block6;
                logger.logp(JeusMessage_OTS0._1205_LEVEL, "RecoveryCoordinatorImpl", "destroy", JeusMessage_OTS0._1205, (Throwable)exc);
            }
        }
    }

    public void _release() {
    }

    public int _hash(int maximum) {
        return 0;
    }

    public DomainManager[] _get_domain_managers() {
        return new DomainManager[0];
    }

    public Object _duplicate() {
        return null;
    }

    public boolean _is_equivalent(Object other) {
        return false;
    }

    public Policy _get_policy(int policy_type) {
        return null;
    }

    public Request _request(String operation) {
        return null;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        return null;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        return null;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exclist, ContextList ctxlist) {
        return null;
    }

    public OTSXid getOTSXid() {
        return this.xid;
    }
}

