/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.root;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.net.ConnectorException;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM2;

public final class CoordinatorResource
implements XAResource {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private final TMInfo tmServer;

    public CoordinatorResource(TMInfo tmServer) {
        this.tmServer = tmServer;
    }

    public final TMInfo getTMServer() {
        if (logger.isLoggable(JeusMessage_TM2._4002_LEVEL)) {
            logger.logp(JeusMessage_TM2._4002_LEVEL, "CoordinatorResource", "getTMServer", JeusMessage_TM2._4002, (Object)this.tmServer);
        }
        return this.tmServer;
    }

    public final void prepare(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4003_LEVEL)) {
            logger.logp(JeusMessage_TM2._4003_LEVEL, "CoordinatorResource", "prepare", JeusMessage_TM2._4003, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).prepare(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4004_LEVEL)) {
            logger.logp(JeusMessage_TM2._4004_LEVEL, "CoordinatorResource", "prepare", JeusMessage_TM2._4004);
        }
    }

    public final void commit(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4005_LEVEL)) {
            logger.logp(JeusMessage_TM2._4005_LEVEL, "CoordinatorResource", "commit", JeusMessage_TM2._4005, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).commit(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4006_LEVEL)) {
            logger.logp(JeusMessage_TM2._4006_LEVEL, "CoordinatorResource", "commit", JeusMessage_TM2._4006);
        }
    }

    public final void rollback(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4007_LEVEL)) {
            logger.logp(JeusMessage_TM2._4007_LEVEL, "CoordinatorResource", "rollback", JeusMessage_TM2._4007, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).rollback(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4008_LEVEL)) {
            logger.logp(JeusMessage_TM2._4008_LEVEL, "CoordinatorResource", "rollback", JeusMessage_TM2._4008);
        }
    }

    public final void onePhaseCommit(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4009_LEVEL)) {
            logger.logp(JeusMessage_TM2._4009_LEVEL, "CoordinatorResource", "onePhaseCommit", JeusMessage_TM2._4009, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).onePhaseCommit(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4010_LEVEL)) {
            logger.logp(JeusMessage_TM2._4010_LEVEL, "CoordinatorResource", "onePhaseCommit", JeusMessage_TM2._4010);
        }
    }

    public final void registered(long ltid, boolean successful) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4011_LEVEL)) {
            logger.logp(JeusMessage_TM2._4011_LEVEL, "CoordinatorResource", "registered", JeusMessage_TM2._4011, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).registered(ltid, successful);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4012_LEVEL)) {
            logger.logp(JeusMessage_TM2._4012_LEVEL, "CoordinatorResource", "registered", JeusMessage_TM2._4012);
        }
    }

    public final void commitLocalXAResource(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4013_LEVEL)) {
            logger.logp(JeusMessage_TM2._4013_LEVEL, "CoordinatorResource", "commitLocalXAResource", JeusMessage_TM2._4013, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).commitLocalXAResource(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4014_LEVEL)) {
            logger.logp(JeusMessage_TM2._4014_LEVEL, "CoordinatorResource", "commitLocalXAResource", JeusMessage_TM2._4014);
        }
    }

    public final void beforeCompletion(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4015_LEVEL)) {
            logger.logp(JeusMessage_TM2._4015_LEVEL, "CoordinatorResource", "beforeCompletion", JeusMessage_TM2._4015, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).beforeCompletion(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4016_LEVEL)) {
            logger.logp(JeusMessage_TM2._4016_LEVEL, "CoordinatorResource", "beforeCompletion", JeusMessage_TM2._4016);
        }
    }

    public final void flush(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM2._4017_LEVEL)) {
            logger.logp(JeusMessage_TM2._4017_LEVEL, "CoordinatorResource", "flush", JeusMessage_TM2._4017, new Object[]{this.tmServer, this.getGTID(ltid)});
        }
        try {
            TMServer.getLink(this.tmServer).flush(ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM2._4018_LEVEL)) {
            logger.logp(JeusMessage_TM2._4018_LEVEL, "CoordinatorResource", "flush", JeusMessage_TM2._4018);
        }
    }

    public final String toString() {
        return this.tmServer.toString();
    }

    public final void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            int code = TMServer.getLink(this.tmServer).resourceCompletion(xid, true);
            if (code != 0) {
                throw new XAException(code);
            }
        }
        catch (TMException e) {
            throw new XAException(-3);
        }
        catch (ConnectorException e) {
            throw new XAException(-3);
        }
    }

    public final void end(Xid xid, int flags) throws XAException {
    }

    public final void forget(Xid xid) throws XAException {
        try {
            TMServer.getLink(this.tmServer).forget(xid);
        }
        catch (ConnectorException e) {
            throw new XAException(-3);
        }
    }

    public final int getTransactionTimeout() throws XAException {
        return 0;
    }

    public final boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    public final int prepare(Xid xid) throws XAException {
        return 0;
    }

    public final Xid[] recover(int flag) throws XAException {
        try {
            return TMServer.getLink(this.tmServer).recover();
        }
        catch (ConnectorException e) {
            throw new XAException(-3);
        }
    }

    public final void rollback(Xid xid) throws XAException {
        try {
            int code = TMServer.getLink(this.tmServer).resourceCompletion(xid, false);
            if (code != 0) {
                throw new XAException(code);
            }
        }
        catch (ConnectorException e) {
            throw new XAException(-3);
        }
        catch (TMException e) {
            throw new XAException(-3);
        }
    }

    public final boolean setTransactionTimeout(int seconds) {
        return false;
    }

    public final void start(Xid xid, int flags) {
    }

    private String getGTID(long ltid) {
        TMInfo rootInfo = TMServer.getTMInfo();
        if (rootInfo != null) {
            return rootInfo.getGTID(ltid);
        }
        return null;
    }
}

