/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import com.sun.management.OperatingSystemMXBean;
import sun.management.ManagementFactory;

public class CPUUsageUtility {
    private static boolean cpuUsageSupport;
    private static OperatingSystemMXBean mxBean;
    private static int cpuNum;
    private static CPUMonitorThread monitoringThread;
    private static boolean export;

    public static synchronized void export(String name, int interval) {
        if (export) {
            return;
        }
        if (cpuUsageSupport) {
            monitoringThread.setName(name);
            monitoringThread.setMonitorInterval(interval);
            monitoringThread.setDaemon(true);
            monitoringThread.start();
        }
        export = true;
    }

    public static synchronized void unexport() {
        if (!export) {
            return;
        }
        if (cpuUsageSupport) {
            monitoringThread.cancel();
        }
        export = false;
    }

    public static synchronized double getProcessCPUUsage() {
        if (!export) {
            throw new IllegalStateException("CPUUsageUtility is not exported");
        }
        if (!cpuUsageSupport) {
            throw new IllegalStateException("CPU Usage is not supported");
        }
        return monitoringThread.getUsage();
    }

    public static boolean isCpuUsageSupport() {
        return cpuUsageSupport;
    }

    static {
        export = false;
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            Class.forName("sun.management.ManagementFactory");
            mxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            cpuNum = Runtime.getRuntime().availableProcessors();
            monitoringThread = new CPUMonitorThread();
            cpuUsageSupport = true;
        }
        catch (Throwable e) {
            mxBean = null;
            cpuUsageSupport = false;
        }
    }

    private static final class CPUMonitorThread
    extends Thread {
        private final int minElapsedTime = 100;
        private boolean running = false;
        private int monitorInterval = 500;
        private CPUUsageSnapshot previousSnapshot = null;
        private double cpuUsage;

        private CPUMonitorThread() {
        }

        public synchronized double getUsage() {
            return this.cpuUsage;
        }

        public void setMonitorInterval(int monitorInterval) {
            if (monitorInterval <= 0 || monitorInterval <= 100) {
                throw new IllegalArgumentException("monitorInterval must be at least 100ms");
            }
            this.monitorInterval = monitorInterval;
        }

        public void cancel() {
            this.running = false;
        }

        private double getProcessCPUUsage(CPUUsageSnapshot start, CPUUsageSnapshot end) {
            if (start == null) {
                throw new IllegalArgumentException("null input: start");
            }
            if (end == null) {
                throw new IllegalArgumentException("null input: end");
            }
            if (end.systemTime < start.systemTime + 100L) {
                throw new IllegalArgumentException("end time must be at least 100 ms later than start time");
            }
            return (double)(end.cpuTime - start.cpuTime) / (double)(end.systemTime - start.systemTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            while (this.running) {
                CPUUsageSnapshot currentSnapshot = new CPUUsageSnapshot(System.currentTimeMillis(), mxBean.getProcessCpuTime() / (long)(1000000 * cpuNum));
                if (this.previousSnapshot != null) {
                    CPUMonitorThread cPUMonitorThread = this;
                    synchronized (cPUMonitorThread) {
                        this.cpuUsage = 100.0 * this.getProcessCPUUsage(this.previousSnapshot, currentSnapshot);
                    }
                }
                this.previousSnapshot = currentSnapshot;
                try {
                    Thread.sleep(this.monitorInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static final class CPUUsageSnapshot {
        public final long systemTime;
        public final long cpuTime;

        private CPUUsageSnapshot(long systemTime, long cpuTime) {
            this.systemTime = systemTime;
            this.cpuTime = cpuTime;
        }
    }
}

