/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import com.tmax.jce.provider.TmaxProvider;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.PasswordFileManager;
import jeus.server.manager.JeusCommanderException;
import jeus.server.manager.JeusVersion;
import jeus.server.service.JeusLogServiceMBean;
import jeus.util.CUtility;
import jeus.util.ErrorMsgManager;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.SecurityUtil;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Console;
import jeus.util.message.JeusMessage_EJB;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.regex.CharSequence;
import jeus.util.regex.Matcher;
import jeus.util.regex.Pattern;
import jeus.util.regex.StringCharSequence;

public abstract class ConsoleUtil {
    protected static JeusLogger logger;
    protected BufferedReader input;
    protected String prompt;
    private static final int LOGIN_RETRY_COUNT = 3;
    protected String realNodeName;
    protected String nodeName;
    public static final int[] ZERO_INT_ARRAY;

    public static String[] addElements(String[] args, String value) {
        String[] temp = new String[args.length + 1];
        temp[0] = value;
        for (int i = 0; i < args.length; ++i) {
            temp[i + 1] = args[i];
        }
        return temp;
    }

    public static String[] removeElements(String[] args) {
        return ConsoleUtil.removeElements(args, ZERO_INT_ARRAY);
    }

    public static String[] removeElements(String[] args, int[] idxs) {
        String[] temp = new String[args.length - idxs.length];
        int removed = 0;
        block0: for (int i = 0; i < args.length; ++i) {
            for (int j = 0; j < idxs.length; ++j) {
                if (i != idxs[j]) continue;
                ++removed;
                continue block0;
            }
            temp[i - removed] = args[i];
        }
        return temp;
    }

    public static String[] getCommandStrings(BufferedReader input, String prompt) {
        String buf = "";
        try {
            System.out.print(prompt + ">");
            while ((buf = input.readLine()) == null) {
            }
            StringTokenizer st = new StringTokenizer(buf, " ");
            int count = st.countTokens();
            String[] result = new String[count];
            for (int i = 0; i < count; ++i) {
                result[i] = st.nextToken();
            }
            return result;
        }
        catch (Exception e) {
            throw new JeusRuntimeException(JeusMessage_Console.Console_1, (Object)buf, (Throwable)e);
        }
    }

    public static String[] getUserPassword(JeusLogger logger, BufferedReader input) {
        String[] logins = ConsoleUtil.getCommandStrings(input, "Login name");
        if (logins.length != 1) {
            throw new JeusRuntimeException(JeusMessage_Console.Console_3);
        }
        System.out.print("Password>");
        String pass = new String(CUtility.getInputBytes());
        logger.directLog("");
        return new String[]{logins[0], pass};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] checkLoginCmd(String[] args) {
        String[] logins = null;
        if (args.length >= 1 && args[0].startsWith("-U")) {
            if (args.length < 2) throw new JeusRuntimeException(JeusMessage_Console.Console_2);
            if (!args[1].startsWith("-P")) throw new JeusRuntimeException(JeusMessage_Console.Console_2);
            return new String[]{args[0].substring(2), args[1].substring(2)};
        }
        if (args.length < 1) return logins;
        if (!args[0].startsWith("-f")) return logins;
        try {
            EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security", (Provider)new TmaxProvider());
            return PasswordFileManager.getUnamePassPair(args[0].substring(2));
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e.getMessage());
        }
    }

    protected void mainMethod(String[] args) {
        try {
            logger = JeusLogger.createDefaultConsoleJeusLogger((String)"jeus");
        }
        catch (Throwable ex) {
            System.out.println(JeusMessage_Console.Console_4);
            ex.printStackTrace();
            return;
        }
        if (args.length == 0) {
            this.printCommandHelp();
            return;
        }
        if (args.length >= 1 && args[0].equals("-verbose")) {
            logger.setLevel(Level.FINEST);
            args = ConsoleUtil.removeElements(args);
        }
        try {
            this.input = new BufferedReader(new FileReader(FileDescriptor.in));
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Console.Console_5_LEVEL)) {
                logger.log(JeusMessage_Console.Console_5_LEVEL, JeusMessage_Console.Console_5);
            }
            return;
        }
        try {
            args = this.processCmdArgs(args);
            VirtualDNS.setLocalNode(this.nodeName);
        }
        catch (Throwable e) {
            logger.log(JeusMessage_Console.Console_8_LEVEL, JeusMessage_Console.Console_8, e);
            System.exit(1);
        }
        String[] logins = ConsoleUtil.checkLoginCmd(args);
        if (logins == null) {
            this.processConsoleLogin();
        } else {
            args = args.length >= 1 && args[0].startsWith("-f") ? ConsoleUtil.removeElements(args) : ConsoleUtil.removeElements(args, new int[]{0, 1});
            this.checkSecurity(logins[0], logins[1]);
        }
        try {
            Set<ObjectName> results;
            MBeanServerConnection connection = this.initializeConnection();
            ObjectName objectName = this.getTargetObjectName();
            if (objectName != null && (results = connection.queryNames(objectName, null)).isEmpty()) {
                throw new JeusRuntimeException(JeusMessage_Console._13);
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Console.Console_11_LEVEL)) {
                logger.log(JeusMessage_Console.Console_11_LEVEL, JeusMessage_Console.Console_11, ex);
            }
            return;
        }
        if (args.length >= 1) {
            this.processOneStepRequest(args);
            System.exit(0);
        } else {
            logger.log(Level.INFO, this.getWelcomeMessage());
            this.getRequest();
        }
    }

    private void processConsoleLogin() {
        int i = 3;
        while (true) {
            block9: {
                try {
                    if (i <= 0) {
                        System.exit(0);
                    }
                    String[] logins = ConsoleUtil.getUserPassword(logger, this.input);
                    try {
                        SecurityUtil.installClientSecurity(this.nodeName);
                    }
                    catch (Exception ex) {
                        if (logger.isLoggable(JeusMessage_Console.Console_9_LEVEL)) {
                            logger.log(JeusMessage_Console.Console_9_LEVEL, JeusMessage_Console.Console_9, (Throwable)ex);
                        }
                        System.exit(1);
                    }
                    LoginService.login(Subject.makeSubject("SYSTEM_DOMAIN", logins[0], logins[1]));
                    break;
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                    if (logger.isLoggable(JeusMessage_Console._12_LEVEL)) {
                        logger.log(JeusMessage_Console._12_LEVEL, JeusMessage_Console._12, (Throwable)e);
                    }
                    System.exit(1);
                }
                catch (SecurityException e) {
                    if (!logger.isLoggable(JeusMessage_Console.Console_10_LEVEL)) break block9;
                    logger.log(JeusMessage_Console.Console_10_LEVEL, JeusMessage_Console.Console_10);
                }
            }
            --i;
        }
    }

    protected void printCommandHelp() {
    }

    protected void processOneStepRequest(String[] args) {
        this.processRequest(args);
    }

    protected void checkSecurity(String userName, String password) {
        try {
            SecurityUtil.installClientSecurity(this.nodeName);
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_Console.Console_9_LEVEL)) {
                logger.log(JeusMessage_Console.Console_9_LEVEL, JeusMessage_Console.Console_9, (Throwable)ex);
            }
            System.exit(1);
        }
        try {
            LoginService.login(Subject.makeSubject("SYSTEM_DOMAIN", userName, password));
        }
        catch (ServiceException e) {
            if (logger.isLoggable(JeusMessage_Console._12_LEVEL)) {
                logger.log(JeusMessage_Console._12_LEVEL, JeusMessage_Console._12, (Throwable)e);
            }
            System.exit(1);
        }
        catch (SecurityException e) {
            if (logger.isLoggable(JeusMessage_Console.Console_10_LEVEL)) {
                logger.log(JeusMessage_Console.Console_10_LEVEL, JeusMessage_Console.Console_10);
            }
            System.exit(0);
        }
    }

    protected void getRequest() {
        while (true) {
            try {
                while (true) {
                    this.prompt = this.getPrompt();
                    String[] cmds = ConsoleUtil.getCommandStrings(this.input, this.prompt);
                    if (cmds == null) continue;
                    this.processRequest(cmds);
                }
            }
            catch (Throwable ex2) {
                ex2.printStackTrace();
                if (!logger.isLoggable(JeusMessage_Console.Console_6_LEVEL)) continue;
                logger.log(JeusMessage_Console.Console_6_LEVEL, JeusMessage_Console.Console_6, ex2);
                continue;
            }
            break;
        }
    }

    protected void processRequest(String[] cmds) {
        block9: {
            if (cmds == null || cmds.length == 0) {
                return;
            }
            try {
                if (cmds[0].equals("help") || cmds[0].equals("h")) {
                    if (cmds.length == 1) {
                        this.printHelp();
                        return;
                    }
                    throw new JeusImproperCommanderException(JeusMessage_EJB.EJB_14);
                }
                if ("exit".equals(cmds[0]) || "quit".equals(cmds[0])) {
                    if (cmds.length == 1) {
                        System.exit(0);
                    }
                    throw new JeusImproperCommanderException(JeusMessage_EJB.EJB_14);
                }
                this.processRequestOwn(cmds);
            }
            catch (JeusImproperCommanderException ex1) {
                logger.log(Level.SEVERE, ex1.getMessage());
            }
            catch (JeusCommanderException ex1) {
                logger.log(JeusMessage_Console.Console_30_LEVEL, JeusMessage_Console.Console_30, (Throwable)((Object)ex1));
            }
            catch (Throwable e) {
                if (!logger.isLoggable(JeusMessage_Console.Console_7_LEVEL)) break block9;
                logger.log(JeusMessage_Console.Console_7_LEVEL, JeusMessage_Console.Console_7, e);
            }
        }
    }

    protected String getMessage(int num) {
        return new String(ErrorMsgManager.getErrMessage((int)num).getErrorString((Object)JeusVersion.getVersion()));
    }

    protected abstract void processRequestOwn(String[] var1) throws Exception;

    protected abstract void printHelp();

    protected abstract String getPrompt();

    protected abstract String getWelcomeMessage();

    protected abstract MBeanServerConnection initializeConnection() throws Exception;

    protected abstract ObjectName getTargetObjectName() throws Exception;

    protected abstract String[] processCmdArgs(String[] var1) throws Exception;

    protected boolean hasNoArgument(String[] cmds) {
        return cmds[1].startsWith("-") || cmds.length <= 2;
    }

    protected static JEUSManagerMBean getJeusManagerMoMBean(String node, MBeanServerConnection utility) throws IOException {
        return JMXUtility.getProxy(utility, JMXUtility.queryJeusManager(utility, node), JEUSManagerMBean.class, false);
    }

    protected void setLoggingLevel(MBeanServerConnection utility, String[] cmds, String node) throws IOException, IllegalJeusSystemNameException {
        cmds = ConsoleUtil.removeElements(cmds, new int[]{0});
        String container = null;
        boolean forced = false;
        boolean setHandler = false;
        while (cmds.length > 0) {
            if (cmds[0].equals("-con")) {
                container = cmds[1];
                node = StringUtil.getNodeNameFromContainerName((String)container);
                cmds = ConsoleUtil.removeElements(cmds, new int[]{0, 1});
                continue;
            }
            if (cmds[0].equals("-node")) {
                node = cmds[1];
                cmds = ConsoleUtil.removeElements(cmds, new int[]{0, 1});
                continue;
            }
            if (cmds[0].equals("-set-handler")) {
                setHandler = true;
                cmds = ConsoleUtil.removeElements(cmds, new int[]{0});
                continue;
            }
            if (!cmds[0].equals("-f")) break;
            forced = true;
            cmds = ConsoleUtil.removeElements(cmds, new int[]{0});
        }
        if (cmds.length == 0) {
            throw new JeusImproperCommanderException(JeusMessage_Manager.MGR_20);
        }
        String loggerName = cmds[0];
        String handler = null;
        String level = null;
        if (cmds.length > 2) {
            handler = cmds[1];
            level = cmds[2];
        } else if (cmds.length > 1) {
            level = cmds[1];
        }
        ObjectName logServiceName = JMXUtility.queryLogService(utility, node, container);
        JeusLogServiceMBean logService = JMXUtility.getProxy(utility, logServiceName, JeusLogServiceMBean.class, false);
        boolean isNodeJeusLogger = logServiceName.getKeyProperty("J2EEServer").equals("null");
        if (level == null) {
            level = logService.getLogLevel(loggerName);
            logger.log(JeusMessage_Console.Console_31_LEVEL, JeusMessage_Console.Console_31, new Object[]{loggerName, level});
            while (loggerName != null) {
                String[] handlerNames = logService.getHandlerList(loggerName);
                boolean isConsoleHandlerIncluded = false;
                for (int i = 0; i < handlerNames.length; ++i) {
                    String handlerName = handlerNames[i];
                    String handlerLevel = logService.getHandlerLevel(loggerName, handlerName);
                    String handlerType = logService.getHandlerClassName(loggerName, handlerName);
                    if (handlerType.equals(ConsoleHandler.class.getName())) {
                        isConsoleHandlerIncluded = true;
                    }
                    logger.log(JeusMessage_Console.Console_32_LEVEL, JeusMessage_Console.Console_32, new Object[]{handlerName, handlerType, handlerLevel});
                }
                boolean useParentHandler = logService.isUseParentHandler(loggerName);
                logger.log(JeusMessage_Console.Console_33_LEVEL, JeusMessage_Console.Console_33, (Object)useParentHandler);
                if (!isNodeJeusLogger && loggerName.equals("jeus") && isConsoleHandlerIncluded) {
                    loggerName = "jeus";
                    logService = JMXUtility.getProxy(utility, JMXUtility.queryLogService(utility, node, null), JeusLogServiceMBean.class, false);
                    logger.log(JeusMessage_Console.Console_34_LEVEL, JeusMessage_Console.Console_34);
                    isNodeJeusLogger = true;
                    continue;
                }
                if (useParentHandler) {
                    if ((loggerName = logService.getParentLogger(loggerName)) == null) {
                        logger.log(JeusMessage_Console.Console_35_LEVEL, JeusMessage_Console.Console_35);
                        continue;
                    }
                    logger.log(JeusMessage_Console.Console_36_LEVEL, JeusMessage_Console.Console_36, (Object)loggerName);
                    continue;
                }
                break;
            }
        } else if (handler != null) {
            logService.setHandlerLevel(loggerName, handler, level);
        } else {
            logService.setLogLevel(loggerName, level, forced);
            level = logService.getLogLevel(loggerName);
            logger.log(JeusMessage_Console.Console_37_LEVEL, JeusMessage_Console.Console_37, new Object[]{loggerName, level});
            Level levelObject = JeusLevel.parse((String)level);
            while (loggerName != null) {
                String[] handlerNames = logService.getHandlerList(loggerName);
                boolean isConsoleHandlerIncluded = false;
                for (int i = 0; i < handlerNames.length; ++i) {
                    String handlerName = handlerNames[i];
                    String handlerLevel = logService.getHandlerLevel(loggerName, handlerName);
                    String handlerType = logService.getHandlerClassName(loggerName, handlerName);
                    if (handlerType.equals(ConsoleHandler.class.getName())) {
                        isConsoleHandlerIncluded = true;
                    }
                    if (levelObject.intValue() < JeusLevel.parse((String)handlerLevel).intValue()) {
                        if (setHandler) {
                            logService.setHandlerLevel(loggerName, handlerName, levelObject.getName());
                            logger.log(JeusMessage_Console.Console_38_LEVEL, JeusMessage_Console.Console_38, new Object[]{handlerName, handlerLevel, levelObject});
                            continue;
                        }
                        logger.log(JeusMessage_Console.Console_39_LEVEL, JeusMessage_Console.Console_39, new Object[]{handlerName, handlerLevel});
                        continue;
                    }
                    logger.log(JeusMessage_Console.Console_40_LEVEL, JeusMessage_Console.Console_40, new Object[]{handlerName, handlerLevel});
                }
                boolean useParentHandler = logService.isUseParentHandler(loggerName);
                logger.log(JeusMessage_Console.Console_41_LEVEL, JeusMessage_Console.Console_41, (Object)useParentHandler);
                if (!isNodeJeusLogger && loggerName.equals("jeus") && isConsoleHandlerIncluded) {
                    loggerName = "jeus";
                    logService = JMXUtility.getProxy(utility, JMXUtility.queryLogService(utility, node, null), JeusLogServiceMBean.class, false);
                    logger.log(JeusMessage_Console.Console_34_LEVEL, JeusMessage_Console.Console_34);
                    isNodeJeusLogger = true;
                    continue;
                }
                if (useParentHandler) {
                    if ((loggerName = logService.getParentLogger(loggerName)) == null) {
                        logger.log(JeusMessage_Console.Console_35_LEVEL, JeusMessage_Console.Console_35);
                        continue;
                    }
                    logger.log(JeusMessage_Console.Console_36_LEVEL, JeusMessage_Console.Console_36, (Object)loggerName);
                    continue;
                }
                break;
            }
        }
    }

    protected static String[] getMatchedString(String pattern, String[] names, boolean isRegEx) {
        if (!isRegEx) {
            pattern = pattern.replaceAll("\\.", "\\\\.");
            pattern = pattern.replaceAll("\\*", ".*");
            pattern = pattern.replace('?', '.');
            pattern = new StringBuffer().append("^").append(pattern).append("$").toString();
        }
        Pattern modulePattern = Pattern.compile((String)pattern);
        Matcher moduleMatcher = modulePattern.matcher((CharSequence)new StringCharSequence(""));
        ArrayList<String> matchedNames = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            moduleMatcher.reset((CharSequence)new StringCharSequence(name));
            if (!moduleMatcher.matches()) continue;
            matchedNames.add(name);
        }
        names = matchedNames.toArray(new String[matchedNames.size()]);
        return names;
    }

    public String[] getValueBetweenDoubleQuotationMarks(String[] cmds, int startIndex) throws JeusCommanderException {
        String value;
        block2: {
            value = cmds[startIndex];
            cmds = ConsoleUtil.removeElements(cmds, new int[]{startIndex});
            if (value.startsWith("\"")) {
                int limit = 0;
                do {
                    ++limit;
                    value = value + " " + cmds[startIndex];
                    if (!(cmds = ConsoleUtil.removeElements(cmds, new int[]{startIndex}))[startIndex].endsWith("\"")) continue;
                    value = value + " " + cmds[startIndex];
                    cmds = ConsoleUtil.removeElements(cmds, new int[]{startIndex});
                    value = value.substring(1, value.length() - 1);
                    break block2;
                } while (limit <= 30);
                throw new JeusCommanderException("can not find a closing quotation mark");
            }
        }
        return ConsoleUtil.addElements(cmds, value);
    }

    static {
        ZERO_INT_ARRAY = new int[]{0};
    }
}

