/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jeus.deploy.archivist.FileArchive;
import jeus.util.FileMonitor;
import jeus.util.ScheduleTask;
import jeus.util.StringUtil;

public class FileMonitorTask
extends ScheduleTask {
    private HashMap fileMap = new HashMap();
    private FileMonitor monitor;

    public FileMonitorTask(FileArchive[] archives, FileMonitor monitor) {
        this(archives, null, monitor);
    }

    public FileMonitorTask(FileArchive[] archives, String[] checkFileList, FileMonitor monitor) {
        this.monitor = monitor;
        for (int i = archives.length - 1; i >= 0; --i) {
            FileArchive classpathLoader = archives[i];
            Enumeration classes = classpathLoader.entries();
            while (classes.hasMoreElements()) {
                String aClass = (String)classes.nextElement();
                if (checkFileList != null && !StringUtil.isMemberOf((String)aClass, (String[])checkFileList)) continue;
                File f = classpathLoader.getFile(aClass);
                this.fileMap.put(f, new Long(f.lastModified()));
            }
        }
    }

    public void run() {
        try {
            for (Map.Entry entry : this.fileMap.entrySet()) {
                File f = (File)entry.getKey();
                long modified = (Long)entry.getValue();
                long lastModified = f.lastModified();
                if (lastModified == modified) continue;
                this.fileMap.put(f, new Long(lastModified));
                this.monitor.fileChanged(f);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

