/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import jeus.util.JeusBootstrapProperties;

public class JeusBootstrapPropertyValues {
    public static final String fs = File.separator;
    public static final String lineSeparator;
    public static final float JAVA_VERSION;
    public static final String FILE_ENCODING;
    public static final String CURRENT_DIRECTORY;
    protected static Set jeusProperties;

    private static String setStaticProperties(String name, String defaultVale) {
        String temp = null;
        try {
            temp = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (temp == null) {
            return defaultVale;
        }
        return temp;
    }

    public static String getSystemProperty(String propertyName, String defaultValue) {
        try {
            jeusProperties.remove(propertyName);
            String property = System.getProperty(propertyName);
            if (property != null) {
                return property;
            }
            return defaultValue;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static String getSystemProperty(String propertyName) {
        try {
            jeusProperties.remove(propertyName);
            return System.getProperty(propertyName);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static String getSystemProperty(String propertyName, String defaultValueIfJeusHomeSet, String defaultValue) {
        try {
            jeusProperties.remove(propertyName);
            String property = System.getProperty(propertyName);
            if (property != null) {
                return property;
            }
            if (JeusBootstrapProperties.JEUS_HOME != null) {
                return defaultValueIfJeusHomeSet;
            }
            return defaultValue;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static int getIntSystemProperty(String propertyName, int defaultValue) {
        try {
            jeusProperties.remove(propertyName);
            String timeout = System.getProperty(propertyName);
            if (timeout != null) {
                return Integer.parseInt(timeout);
            }
            return defaultValue;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static int getIntSystemPropertyWithRange(String propertyName, int defaultValue, int minValue, int maxValue) {
        try {
            jeusProperties.remove(propertyName);
            String timeout = System.getProperty(propertyName);
            if (timeout != null) {
                int value = Integer.parseInt(timeout);
                if (value < minValue || value > maxValue) {
                    throw new RuntimeException("The value of system property " + propertyName + " is not in the range between " + minValue + " and " + maxValue + " : " + value);
                }
                return value;
            }
            return defaultValue;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static int getIntSystemPropertyWithoutCatchException(String propertyName, int defaultValue) {
        jeusProperties.remove(propertyName);
        String timeout = System.getProperty(propertyName);
        if (timeout != null) {
            try {
                return Integer.parseInt(timeout);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static long getLongSystemProperty(String propertyName, long defaultValue) {
        jeusProperties.remove(propertyName);
        try {
            String timeout = System.getProperty(propertyName);
            if (timeout != null) {
                return Long.parseLong(timeout);
            }
            return defaultValue;
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Long getWrapperLongSystemProperty(String propertyName, Long defaultValue) {
        Long property = JeusBootstrapPropertyValues.getWrapperLongSystemProperty(propertyName);
        return property == null ? defaultValue : property;
    }

    public static Long getWrapperLongSystemProperty(String propertyName) {
        jeusProperties.remove(propertyName);
        String property = System.getProperty(propertyName);
        if (property != null) {
            return Long.parseLong(property);
        }
        return null;
    }

    public static boolean getBooleanSystemProperty(String propertyName, boolean defaultValue) {
        jeusProperties.remove(propertyName);
        try {
            String fastDeploy = System.getProperty(propertyName);
            if (fastDeploy == null) {
                return defaultValue;
            }
            if (defaultValue) {
                return !fastDeploy.equalsIgnoreCase("false");
            }
            return fastDeploy.equalsIgnoreCase("true");
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static String getAndSetSystemProperty(String propertyName, String defaultValue) {
        jeusProperties.remove(propertyName);
        try {
            String property = System.getProperty(propertyName);
            if (property == null) {
                System.setProperty(propertyName, defaultValue);
                return defaultValue;
            }
            return property;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static String getChoiceSystemProperty(String propertyName, String chechValue, String defaultValue) {
        jeusProperties.remove(propertyName);
        try {
            String property = System.getProperty(propertyName);
            if (property != null && property.equalsIgnoreCase(chechValue)) {
                return chechValue;
            }
            return defaultValue;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static String getDirectorySystemProperty(String propertyName, String defaultValue) {
        jeusProperties.remove(propertyName);
        try {
            String jeusHome = System.getProperty(propertyName);
            if (jeusHome != null && !jeusHome.equals("")) {
                int index = jeusHome.lastIndexOf(fs) + 1;
                if (jeusHome.length() == index) {
                    jeusHome = jeusHome.substring(0, index - 1);
                }
                return jeusHome;
            }
            return defaultValue;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static boolean getBooleanParamValue(String _targetValue, boolean defaultValue) {
        return JeusBootstrapPropertyValues.getBooleanSystemProperty(_targetValue, defaultValue);
    }

    public static int getIntParamValue(String _targetValue, int defaultValue) {
        return JeusBootstrapPropertyValues.getIntSystemProperty(_targetValue, defaultValue);
    }

    public static long getLongParamValue(String _targetValue, long defaultValue) {
        return JeusBootstrapPropertyValues.getLongSystemProperty(_targetValue, defaultValue);
    }

    public static URL makeUrlFromPath(String filePath) throws MalformedURLException {
        File f = new File(filePath);
        return f.toURL();
    }

    public static Set getMissingProperties() {
        return jeusProperties;
    }

    public static boolean isUpperJDK4() {
        return (double)JAVA_VERSION > 1.35;
    }

    public static boolean isUpperJDK5() {
        return (double)JAVA_VERSION > 1.45;
    }

    static {
        CURRENT_DIRECTORY = System.getProperty("user.dir");
        lineSeparator = JeusBootstrapPropertyValues.setStaticProperties("line.separator", "\r\n");
        JAVA_VERSION = Float.parseFloat(JeusBootstrapPropertyValues.setStaticProperties("java.specification.version", "1.5"));
        FILE_ENCODING = JeusBootstrapPropertyValues.setStaticProperties("file.encoding", "EUC-KR");
        jeusProperties = Collections.synchronizedSet(new HashSet());
        try {
            Properties p = System.getProperties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (!propertyName.startsWith("jeus.")) continue;
                jeusProperties.add(propertyName);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

