/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusLocalizedException;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.LogBufferedOutputStream;
import jeus.util.logging.SimpleFormatter;
import jeus.util.trace.GID;

public class Logger {
    public static final int FATAL = 0;
    public static final int NOTICE = 1;
    public static final int INFORMATION = 2;
    public static final int DEBUG = 3;
    public static final String forwardPrefix = "stdout:";
    public static PrintStream out = null;
    private static PrintStream forward = null;
    private static final PrintStream sysout = System.out;
    public static int logLevel = 2;
    private static boolean isFileLogging = false;
    private static boolean forwordToStdout = false;
    private static LogBufferedOutputStream bos = null;
    private static SimpleDateFormat fileformat = new SimpleDateFormat("MMddyyyy");
    public static SimpleDateFormat logformat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static int prevCreatedDay = -1;
    private static String fileroot = null;
    private static int bufferSize;
    private static Thread logThread;
    private static Class oracleError;
    private static Method oracleErrorMethod;
    private static Object[] noArgs;
    public static final String stackTrPrefix = "<<__Exception__>>";
    public static final String stackTrPostfix = "<<__!Exception__>>";

    public static void createLogger(String destination, int bsize) {
        if (destination.equals("")) {
            Logger.innerCreateLogger("", 0, false);
        } else {
            fileroot = destination;
            bufferSize = bsize;
            if (bufferSize == 0) {
                bufferSize = 1;
            }
            prevCreatedDay = Calendar.getInstance().get(6);
            String filename = fileroot + "_" + fileformat.format(Calendar.getInstance().getTime()) + ".log";
            Logger.innerCreateLogger(filename, bufferSize, fileroot.startsWith(forwardPrefix));
            if (logThread == null) {
                try {
                    LogThread t = new LogThread();
                    t.setDaemon(true);
                    t.start();
                    logThread = t;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void innerCreateLogger(String filepath, int bsize, boolean isForwarded) {
        Logger.close();
        if (filepath.equals("")) {
            out = new PrintStream(sysout, true);
            isFileLogging = false;
        } else {
            File file;
            if (isForwarded) {
                forwordToStdout = true;
                forward = new PrintStream(sysout, true);
                filepath = filepath.substring(forwardPrefix.length());
            }
            if ((file = new File(filepath)).getParent() != null) {
                new File(file.getParent()).mkdirs();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file.toString(), true);
                bos = new LogBufferedOutputStream(fos, bsize);
                out = new PrintStream(bos, true);
                isFileLogging = true;
            }
            catch (IOException ioe) {
                try {
                    fos.close();
                    bos.close();
                    out.close();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                throw new JeusRuntimeException((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLogFile() {
        int thisDay = Calendar.getInstance().get(6);
        if (isFileLogging && thisDay != prevCreatedDay) {
            PrintStream printStream = out;
            synchronized (printStream) {
                out.flush();
                prevCreatedDay = thisDay;
                String filename = fileroot + "_" + fileformat.format(Calendar.getInstance().getTime()) + ".log";
                try {
                    Logger.innerCreateLogger(filename, bufferSize, fileroot.startsWith(forwardPrefix));
                }
                catch (Throwable ex) {
                    Logger.log(10311, fileroot, ex, 0);
                }
            }
        }
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        if (out == null) {
            return;
        }
        if (isFileLogging) {
            PrintStream printStream = out;
            synchronized (printStream) {
                try {
                    out.flush();
                    bos.forcedFlush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (forwordToStdout) {
                forward.flush();
            }
        } else {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            if (isFileLogging) {
                try {
                    out.close();
                    bos.forcedFlush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (forwordToStdout) {
                    forwordToStdout = false;
                    forward = null;
                }
            }
            out = null;
        }
    }

    public static void log(String msg, int level) {
        if (out == null) {
            return;
        }
        if (level <= logLevel) {
            Logger.printLogMessage(msg, level, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLogMessage(String msg, int level, Throwable e) {
        if (out == null) {
            return;
        }
        if (level <= logLevel) {
            String gidString = GID.useGID && GID.getCurrentGID() != null ? "[" + GID.getCurrentGID().toString() + "] " : "";
            PrintStream printStream = out;
            synchronized (printStream) {
                out.println("[" + logformat.format(new Date()) + "] " + gidString + msg);
                if (forwordToStdout) {
                    forward.println("[" + logformat.format(new Date()) + "] " + gidString + msg);
                }
                if (e != null) {
                    Logger.printStackTraces(e);
                }
                if (level == 0 && isFileLogging) {
                    bos.forcedFlush();
                }
            }
        }
    }

    public static void log(int msgID, int level) {
        Logger.printLogMessage(ErrorMsgManager.getLocalizedString((int)msgID), level, null);
    }

    public static void log(int msgID, String arg, int level) {
        Logger.printLogMessage(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg), level, null);
    }

    public static void log(int msgID, String[] args, int level) {
        Logger.printLogMessage(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args), level, null);
    }

    public static void log(String msg, Throwable e, int level) {
        Logger.printLogMessage(msg, level, e);
    }

    public static void log(int msgID, Throwable e, int level) {
        Logger.printLogMessage(ErrorMsgManager.getLocalizedString((int)msgID), level, e);
    }

    public static void log(int msgID, String arg, Throwable e, int level) {
        Logger.printLogMessage(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg), level, e);
    }

    public static void log(int msgID, String[] args, Throwable e, int level) {
        Logger.printLogMessage(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args), level, e);
    }

    private static void printStackTraces(Throwable t) {
        Throwable nextT;
        int msgID = -1;
        Object arg = null;
        Object[] args = null;
        if (t instanceof JeusLocalizedException) {
            JeusLocalizedException e = (JeusLocalizedException)t;
            nextT = e.getCause();
            msgID = e.getMessageNumber();
            arg = e.getParameter();
            args = e.getParameters();
        } else if (t instanceof RemoteException) {
            RemoteException e = (RemoteException)t;
            nextT = e.detail;
        } else if (t instanceof SQLException) {
            SQLException e = (SQLException)t;
            nextT = e.getNextException();
        } else if (t instanceof NamingException) {
            NamingException e = (NamingException)t;
            nextT = e.getRootCause();
        } else {
            return;
        }
        nextT = SimpleFormatter.getCauseException((Throwable)nextT);
        if (msgID != -1) {
            if (arg != null) {
                out.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg) + " : " + t.toString());
                if (forwordToStdout) {
                    forward.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg) + " : " + t.toString());
                }
            } else if (args != null) {
                out.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args) + " : " + t.toString());
                if (forwordToStdout) {
                    forward.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args) + " : " + t.toString());
                }
            } else {
                out.println(ErrorMsgManager.getLocalizedString((int)msgID) + " : " + t.toString());
                if (forwordToStdout) {
                    forward.println(ErrorMsgManager.getLocalizedString((int)msgID) + " : " + t.toString());
                }
            }
        } else if (oracleError != null && oracleError.isInstance(t)) {
            try {
                out.println("[ORA - " + oracleErrorMethod.invoke((Object)t, noArgs) + "] : " + t.getMessage());
                if (forwordToStdout) {
                    forward.println("[ORA - " + oracleErrorMethod.invoke((Object)t, noArgs) + "] : " + t.getMessage());
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        t.printStackTrace(out);
        if (forwordToStdout) {
            t.printStackTrace(forward);
        }
        if (nextT != null) {
            Logger.printStackTraces(nextT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(Throwable t) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            Logger.printStackTraces(t);
            if (forwordToStdout) {
                t.printStackTrace(forward);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirect(String msg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print(msg);
            if (forwordToStdout) {
                forward.print(msg);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(String msg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(msg);
            if (forwordToStdout) {
                forward.println(msg);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog2(String msg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print(msg);
            out.flush();
            if (forwordToStdout) {
                forward.println(msg);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(int msgID) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(ErrorMsgManager.getLocalizedString((int)msgID));
            if (forwordToStdout) {
                forward.println(ErrorMsgManager.getLocalizedString((int)msgID));
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(int msgID, String arg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg));
            if (forwordToStdout) {
                forward.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg));
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(int msgID, String[] args) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args));
            if (forwordToStdout) {
                forward.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args));
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(String msg, Throwable e) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(msg);
            if (forwordToStdout) {
                forward.println(msg);
            }
            Logger.printStackTraces(e);
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(int msgID, Throwable e) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(ErrorMsgManager.getLocalizedString((int)msgID));
            if (forwordToStdout) {
                forward.println(ErrorMsgManager.getLocalizedString((int)msgID));
            }
            Logger.printStackTraces(e);
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(int msgID, String arg, Throwable e) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg));
            if (forwordToStdout) {
                forward.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg));
            }
            Logger.printStackTraces(e);
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directLog(int msgID, String[] args, Throwable e) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args));
            if (forwordToStdout) {
                forward.println(ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args));
            }
            Logger.printStackTraces(e);
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemOutPrint(String msg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print(msg);
            if (forwordToStdout) {
                forward.print(msg);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemOutPrint(char[] msg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print(msg);
            if (forwordToStdout) {
                forward.print(msg);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemOutPrintln() {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println();
            if (forwordToStdout) {
                forward.println();
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemOutPrintln(char[] msg) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(msg);
            if (forwordToStdout) {
                forward.println(msg);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemOutWrite(byte[] x, int y, int z) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.write(x, y, z);
            if (forwordToStdout) {
                forward.write(x, y, z);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemOutWrite(int x) {
        if (out == null) {
            return;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.write(x);
            if (forwordToStdout) {
                forward.write(x);
            }
            if (isFileLogging) {
                bos.forcedFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean systemOutCheckError() {
        if (out == null) {
            return false;
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            if (forwordToStdout) {
                return forward.checkError();
            }
            return out.checkError();
        }
    }

    static {
        logThread = null;
        oracleError = null;
        oracleErrorMethod = null;
        noArgs = new Object[0];
        try {
            oracleError = JeusRootClassLoader.loader.loadClass("oracle.jdbc.xa.OracleXAException");
            oracleErrorMethod = oracleError.getMethod("getOracleError", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Throwable t) {
            // empty catch block
        }
        String logFileName = null;
        String bsize = null;
        String loglevel = null;
        try {
            logFileName = System.getProperty("jeus.log.filename");
            bsize = System.getProperty("jeus.log.bufsize");
            loglevel = System.getProperty("jeus.log.level");
        }
        catch (SecurityException t) {
            // empty catch block
        }
        if (logFileName == null) {
            logFileName = "";
            bsize = "0";
        } else if (bsize == null) {
            bsize = "10000";
        }
        try {
            Logger.createLogger(logFileName, Integer.parseInt(bsize));
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(t);
        }
        if (loglevel == null) {
            Logger.setLogLevel(1);
        } else {
            String level = loglevel.toUpperCase();
            if (level.equals("FATAL") || level.equals("SEVERE")) {
                Logger.setLogLevel(0);
            } else if (level.equals("NOTICE") || level.equals("WARNING")) {
                Logger.setLogLevel(1);
            } else if (level.equals("INFORMATION") || level.equals("INFO")) {
                Logger.setLogLevel(2);
            } else if (level.equals("DEBUG") || level.equals("FINE") || level.equals("FINER") || level.equals("FINEST") || level.equals("CONFIG") || level.equals("ALL")) {
                Logger.setLogLevel(3);
            } else {
                Logger.setLogLevel(1);
            }
        }
    }

    public static class LogThread
    extends Thread {
        public LogThread() {
            super("jeus.util.LogThread");
        }

        public void run() {
            Thread t = Thread.currentThread();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                        Logger.checkLogFile();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

