/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ReflectionUtils {
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return ReflectionUtils.invokeMethod(object, methodName, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return ReflectionUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if (args == null) {
            args = emptyObjectArray;
        }
        if ((method = ReflectionUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return ReflectionUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return ReflectionUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = emptyObjectArray;
        }
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if ((method = ReflectionUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return ReflectionUtils.getAccessibleMethod(clazz, methodName, parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            return ReflectionUtils.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = ReflectionUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method != null || (method = ReflectionUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            Method method;
            block8: {
                method = clazz.getMethod(methodName, parameterTypes);
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException se) {
                    if (loggedAccessibleWarning) break block8;
                    loggedAccessibleWarning = true;
                }
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            int paramSize = parameterTypes.length;
            Method[] methods = clazz.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                Method method;
                block9: {
                    Class<?>[] methodsParams;
                    int methodParamSize;
                    if (!methods[i].getName().equals(methodName) || (methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) != paramSize) continue;
                    boolean match = true;
                    for (int n = 0; n < methodParamSize; ++n) {
                        if (ReflectionUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) continue;
                        match = false;
                        break;
                    }
                    if (!match || (method = ReflectionUtils.getAccessibleMethod(methods[i])) == null) continue;
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        if (loggedAccessibleWarning) break block9;
                        loggedAccessibleWarning = true;
                    }
                }
                return method;
            }
            return null;
        }
    }

    protected static final boolean isAssignmentCompatible(Class parameterType, Class parameterization) {
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            if (Boolean.TYPE.equals(parameterType)) {
                return Boolean.class.equals((Object)parameterization);
            }
            if (Float.TYPE.equals(parameterType)) {
                return Float.class.equals((Object)parameterization);
            }
            if (Long.TYPE.equals(parameterType)) {
                return Long.class.equals((Object)parameterization);
            }
            if (Integer.TYPE.equals(parameterType)) {
                return Integer.class.equals((Object)parameterization);
            }
            if (Double.TYPE.equals(parameterType)) {
                return Double.class.equals((Object)parameterization);
            }
        }
        return false;
    }

    public static void setAccessible(final AccessibleObject member, final boolean flag) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                member.setAccessible(flag);
                return null;
            }
        });
    }

    public static void setAccessible(final AccessibleObject[] members, final boolean flag) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AccessibleObject.setAccessible(members, flag);
                return null;
            }
        });
    }
}

