/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jeus.util.AbstractMap;
import jeus.util.HashMap;

public class SecondChanceCacheMap
extends AbstractMap
implements Map {
    private transient int capacity;
    private transient Map map;
    private transient LinkedList list;
    private transient Set entrySet;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public SecondChanceCacheMap(int i) {
        this.capacity = i;
        this.map = new HashMap();
        this.list = new LinkedList();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsValue(Object obj) {
        return this.map.containsValue(obj);
    }

    public boolean containsKey(Object obj) {
        return this.map.containsKey(obj);
    }

    public Object get(Object obj) {
        SecondChanceEntry secondchanceentry = (SecondChanceEntry)this.map.get(obj);
        if (secondchanceentry == null) {
            return null;
        }
        secondchanceentry.setSecondChance(true);
        return secondchanceentry.getValue();
    }

    public synchronized Object put(Object obj, Object obj1) {
        SecondChanceEntry secondchanceentry = new SecondChanceEntry(obj, obj1);
        this.list.add(secondchanceentry);
        SecondChanceEntry secondchanceentry2 = this.map.put(obj, secondchanceentry);
        if (secondchanceentry2 != null) {
            secondchanceentry2.setValid(false);
            return secondchanceentry2.getValue();
        }
        while (this.size() > this.capacity) {
            SecondChanceEntry secondchanceentry1 = (SecondChanceEntry)this.list.removeFirst();
            if (!secondchanceentry1.getValid()) continue;
            if (secondchanceentry1.getSecondChance()) {
                secondchanceentry1.setSecondChance(false);
                this.list.add(secondchanceentry1);
                continue;
            }
            secondchanceentry2 = secondchanceentry1;
            this.map.remove(secondchanceentry1.getKey());
        }
        if (secondchanceentry2 != null) {
            return secondchanceentry2.getValue();
        }
        return null;
    }

    public synchronized Object remove(Object obj) {
        SecondChanceEntry secondchanceentry = (SecondChanceEntry)this.map.remove(obj);
        if (secondchanceentry == null) {
            return null;
        }
        secondchanceentry.setValid(false);
        return secondchanceentry.getValue();
    }

    public synchronized void clear() {
        this.map = new HashMap();
        this.list = new LinkedList();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new SecondChanceIterator(2);
                }

                public boolean contains(Object obj) {
                    if (!(obj instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)obj;
                    return SecondChanceCacheMap.this.map.get(entry.getKey()) != null;
                }

                public boolean remove(Object obj) {
                    if (!(obj instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)obj;
                    Object obj1 = SecondChanceCacheMap.this.remove(entry.getKey());
                    return obj1 != null;
                }

                public int size() {
                    return SecondChanceCacheMap.this.size();
                }

                public void clear() {
                    SecondChanceCacheMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private class SecondChanceEntry
    implements Map.Entry {
        private transient Object key;
        private transient Object value;
        private transient boolean secondChance;
        private transient boolean valid;

        public boolean getSecondChance() {
            return this.secondChance;
        }

        public void setSecondChance(boolean flag) {
            this.secondChance = flag;
        }

        public boolean getValid() {
            return this.valid;
        }

        public void setValid(boolean flag) {
            this.valid = flag;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object obj) {
            Object obj1 = this.value;
            this.value = obj;
            return obj1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return (this.key != null ? this.key.equals(entry.getKey()) : entry.getKey() == null) && (this.value != null ? this.value.equals(entry.getValue()) : entry.getValue() == null);
        }

        public int hashCode() {
            return (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
        }

        public String toString() {
            return "jeus.util.SecondChanceCacheMap.SecondChanceEntry - key: " + this.key.toString() + " value: " + this.value.toString();
        }

        public SecondChanceEntry(Object obj, Object obj1) {
            this.key = obj;
            this.value = obj1;
            this.secondChance = false;
            this.valid = true;
        }
    }

    private class SecondChanceIterator
    implements Iterator {
        Iterator mapIterator;
        int type;

        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        public Object next() {
            SecondChanceEntry secondchanceentry = (SecondChanceEntry)this.mapIterator.next();
            return this.type != 0 ? (this.type != 1 ? secondchanceentry : secondchanceentry.getValue()) : secondchanceentry.getKey();
        }

        public void remove() {
            this.mapIterator.remove();
        }

        public SecondChanceIterator(int i) {
            this.mapIterator = SecondChanceCacheMap.this.map.values().iterator();
            this.type = i;
        }
    }
}

