/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.security.Permission;
import java.security.Provider;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.net.ssl.SSLContext;
import jeus.deploy.archivist.FileArchive;
import jeus.io.helper.IOComponentCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.net.Endpoint;
import jeus.net.JeusSSLConfiguration;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.Password;
import jeus.security.spi.LoginService;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoginUtil;
import jeus.util.EnvironmentCall;
import jeus.util.ExecutionContext;
import jeus.util.JeusPort;
import jeus.util.VirtualDNS;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;

public class ServerEnvironmentCall
extends EnvironmentCall {
    private static boolean isRunCalled;

    protected void checkPermissionInternal(Permission permission) throws Exception {
        LoginService.checkPermission(permission);
    }

    public Object createSubject(String userName, String password) throws JMSException {
        try {
            return userName == null ? Subject.makeAnonymousSubject() : Subject.makeSubject(userName, password);
        }
        catch (Throwable e) {
            throw new JMSException("failed to create subject " + e);
        }
    }

    public void authorize(Object subject, Permission permission) throws JMSException {
        try {
            LoginService.login((Subject)subject);
            LoginService.checkPermission(permission);
        }
        catch (Throwable e) {
            throw new JMSException("failed to acquire permission by " + e);
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
    }

    protected void checkCodeSubjectInternal() {
        LoginService.checkCodeSubject();
    }

    protected void logoutWithRuntimeExceptionInternal() {
        LoginUtil.logoutWithRuntimeException();
    }

    protected FileArchive getConfigArchiveInternal() {
        return JeusManagerPropertyValues.getConfigArchive();
    }

    protected Object[] getUserPasswordsInternal() {
        Subject subject = LoginUtil.getLatestUserSubjectWithRuntimeException();
        String userName = null;
        String[] passwords = null;
        if (subject != null && subject.getPrincipal() != null) {
            userName = subject.getPrincipal().getName();
            Set credentials = subject.getCredentials(Password.class);
            passwords = new String[credentials.size()];
            Iterator it = credentials.iterator();
            int index = 0;
            while (it.hasNext()) {
                Password password = (Password)it.next();
                passwords[index++] = password.getPassword();
            }
        }
        return new Object[]{userName, passwords};
    }

    protected String getEnvNameInternal() {
        return ExecutionContext.getExecutionContext().getAppName();
    }

    protected void loginCodeSubjectInternal() throws ServiceException, SecurityException {
        LoginUtil.loginCodeSubjectWithRuntimeException();
    }

    protected Object createJMSConsoleInternal(Object obj) {
        try {
            Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass("jeus.util.console.JMSConsole");
            return c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return obj;
        }
    }

    protected int getJeusBasePortInternal() {
        return JeusPort.JeusBase;
    }

    protected int getSecuritySSLPortInternal() {
        return JeusPort.Security_SSL;
    }

    protected String getSecurityIDInternal() {
        return JeusPort.Security_ID;
    }

    protected String getLocalFullHostNameInternal() {
        return JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
    }

    protected String getLocalHostNameInternal() {
        return JeusNetPropertyValues.LOCAL_HOSTNAME;
    }

    protected String getLocalVirtualNameInternal() {
        return VirtualDNS.LOCAL_VIRTUALNAME;
    }

    protected String getRealNodeNameInternal(String targetNode) {
        return VirtualDNS.getRealNodeName(targetNode);
    }

    protected IOComponentCreator getSecurityIOComponentInternal(String name, int expectedConnectionNumber, boolean enableNIO) {
        if (enableNIO) {
            return JeusIOComponentCreator.DEFAULT_CREATOR;
        }
        return JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)expectedConnectionNumber);
    }

    protected SSLContext getSecuritySSLContextInternal(boolean enableSSL) {
        if (enableSSL) {
            return JeusSSLConfiguration.sslContext;
        }
        return null;
    }

    protected String getJeusConfigHomeInternal() {
        return JeusManagerProperties.JEUS_CONFIG_HOME;
    }

    protected void initEncryptionUtilInternal(Class c) throws IllegalAccessException, InstantiationException {
        if (c != null) {
            EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + JeusNetPropertyValues.LOCAL_HOSTNAME + JeusPropertyValues.fs + "security", (Provider)c.newInstance());
        } else {
            EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + JeusNetPropertyValues.LOCAL_HOSTNAME + JeusPropertyValues.fs + "security");
        }
    }

    protected Object[] getSecurityNodeAndPortInternal(String nodeName) {
        int port;
        String node;
        int idx;
        String realnode = nodeName;
        if (realnode.indexOf(":") < 0) {
            realnode = VirtualDNS.getRealNodeName(nodeName);
        }
        if ((idx = realnode.indexOf(":")) == -1) {
            node = realnode;
            port = JeusPort.JeusBase;
        } else {
            node = realnode.substring(0, idx);
            port = Integer.parseInt(realnode.substring(idx + 1));
        }
        return new Object[]{node, new Integer(port)};
    }

    static {
        Thread t = new Thread(){

            public void run() {
                try {
                    if (!isRunCalled) {
                        isRunCalled = true;
                        LoginUtil.loginCodeSubjectWithRuntimeException();
                        switch (JeusPropertyValues.JEUS_CATEGORY) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        Endpoint.destroyAllActiveEndpoints();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        t.setName("JEUS_SHUTDOWN_THREAD");
        Runtime.getRuntime().addShutdownHook(t);
    }
}

