/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.FileNotFoundException;
import java.util.List;
import jeus.net.impl.NodeInfo;
import jeus.server.ConfigFile;
import jeus.service.descriptor.VirtualHostDescriptorFile;
import jeus.util.JeusPort;
import jeus.util.JeusProperties;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_Manager1;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.VirtualHostsType;
import jeus.xml.binding.jeusDD.VirtualNodeType;

public class ServerVirtualDNS
extends VirtualDNS {
    private static ConfigFile configFile = new ConfigFile();
    private static VirtualHostsType hosts;
    private static final VirtualHostDescriptorFile file;

    protected void loadFromVhostXML() throws Exception {
        try {
            hosts = (VirtualHostsType)file.getConfigDescriptor(hosts);
        }
        catch (FileNotFoundException e) {
            if (logger.isLoggable(JeusMessage_Manager1._521_LEVEL)) {
                logger.log(JeusMessage_Manager1._521_LEVEL, JeusMessage_Manager1._521, (Object)JeusProperties.VHOST_FILE_PATH);
            }
            hosts = new ObjectFactory().createVirtualHostsType();
        }
        if (configFile.isModified()) {
            VirtualDNS.revers_dns.clear();
            VirtualDNS.nodeInfoMap.clear();
            enabled = enabledBySystemProperty != null ? enabledBySystemProperty.booleanValue() : hosts.isEnable().booleanValue();
            if (enabled) {
                List vhosts = hosts.getHost();
                for (int i = 0; i < vhosts.size(); ++i) {
                    int port;
                    String node;
                    VirtualNodeType vhost = (VirtualNodeType)vhosts.get(i);
                    String realNode = vhost.getName();
                    String virtualNode = vhost.getVirtualName();
                    VirtualDNS.revers_dns.put(realNode, virtualNode);
                    int idx = realNode.indexOf(":");
                    if (idx == -1) {
                        node = realNode;
                        port = JeusPort.JeusBase;
                    } else {
                        node = realNode.substring(0, idx);
                        port = Integer.parseInt(realNode.substring(idx + 1));
                        if (port != JeusPort.JeusBase) {
                            VirtualDNS.useDifferentPorts = true;
                        }
                    }
                    NodeInfo nodeInfo = new NodeInfo(node, port);
                    VirtualDNS.nodeInfoMap.put(virtualNode, nodeInfo);
                }
            }
        }
    }

    static {
        file = new VirtualHostDescriptorFile(configFile, JeusProperties.VHOST_FILE_PATH);
    }
}

