/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class AntJeusEJBCompiler50
extends Task {
    private String taskClassName = "jeus.tool.compiler.AppCompilerBootstrapper";
    private boolean keepGenerated;
    private boolean ear;
    private File ejbJar;
    private File jeusEjbDD;
    private File targetFile;
    private File jeusHome;

    public void execute() {
        if (this.jeusHome == null) {
            String jeusHome = System.getProperty("jeus.home");
            if (jeusHome == null) {
                throw new BuildException("Jeushome : " + jeusHome + " is not valid directory.");
            }
            this.jeusHome = new File(jeusHome);
        }
        if (!this.jeusHome.isDirectory()) {
            throw new BuildException("Jeushome : " + this.jeusHome.getPath() + " is not valid directory.");
        }
        String jvmArgs = "-Djeus.home=" + this.jeusHome.getAbsolutePath();
        Java task = (Java)this.getProject().createTask("java");
        task.setTaskName(this.getTaskName());
        task.setFork(true);
        task.setClassname(this.taskClassName);
        task.createJvmarg().setLine(jvmArgs);
        if (this.keepGenerated) {
            task.createArg().setValue("-keep");
        }
        if (this.ear) {
            task.createArg().setValue("-ear");
        }
        if (this.ejbJar != null) {
            task.createArg().setValue("-ejb-jar");
            task.createArg().setValue(this.ejbJar.getAbsolutePath());
        }
        if (this.jeusEjbDD != null) {
            task.createArg().setValue("-jeus-ejb-dd");
            task.createArg().setValue(this.jeusEjbDD.getAbsolutePath());
        }
        task.createArg().setValue(this.targetFile.getAbsolutePath());
        File bootstrapPath = new File(this.jeusHome, "lib" + File.separator + "system" + File.separator + "bootstrap.jar");
        Path classPath = new Path(this.getProject());
        classPath.setLocation(bootstrapPath);
        task.setClasspath(classPath);
        if (task.executeJava() != 0) {
            throw new BuildException("Error Occured");
        }
    }

    public void setJeusHome(File jeusHome) {
        this.jeusHome = jeusHome;
    }

    public void setKeep(boolean keepGenerated) {
        this.keepGenerated = keepGenerated;
    }

    public void setEar(boolean ear) {
        this.ear = ear;
    }

    public void setEjbJar(File ejbJar) {
        this.ejbJar = ejbJar;
    }

    public void setJeusEjbDD(File jeusEjbDD) {
        this.jeusEjbDD = jeusEjbDD;
    }

    public void setTarget(File target) {
        this.targetFile = target;
    }
}

