/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jeus.util.codegen.CodeUtil;
import jeus.util.codegen.CodeWriter;
import jeus.util.codegen.Element;
import jeus.util.codegen.MethodWriter;

public class ClassWriter
extends CodeWriter {
    public ClassWriter(String packageName, String className, String baseClassName) {
        this(packageName, 1, className, baseClassName, null);
    }

    public ClassWriter(String packageName, int modifiers, String className, String baseClassName, String[] interfaces) {
        super(packageName, modifiers, className, baseClassName);
        String mods = CodeUtil.getModifierDecl(modifiers);
        if (!mods.equals("")) {
            this.classDecl.append(mods).append(" ");
        }
        this.classDecl.append("class ").append(className);
        if (baseClassName != null && !baseClassName.trim().equals("")) {
            this.classDecl.append(this.newline);
            this.classDecl.append("extends ").append(baseClassName);
        }
        if (interfaces != null && interfaces.length > 0) {
            this.classDecl.append(this.newline);
            this.classDecl.append("implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i != 0) {
                    this.classDecl.append(", ");
                }
                this.classDecl.append(interfaces[i]);
            }
        }
    }

    public MethodWriter addStatic() {
        MethodWriter mw = new MethodWriter(this);
        this.elements.add(new Element(Element.Type.STATIC_BLOCK, "static", mw));
        return mw;
    }

    public void addField(String fieldDeclaration) {
        this.elements.add(new Element(Element.Type.FIELD, fieldDeclaration));
    }

    public void addField(int modifiers, String type, String name) {
        this.addField(modifiers, type, name, null);
    }

    public void addField(int modifiers, String type, String name, String defaultValueDeclaration) {
        String decl = CodeUtil.getModifierDecl(modifiers) + " " + type + " " + name;
        if (defaultValueDeclaration != null) {
            decl = decl + " = " + defaultValueDeclaration;
        }
        decl = decl + ";";
        this.addField(decl);
    }

    public void addField(Field field) {
        this.addField(field.getModifiers(), CodeUtil.getClassName(field.getType()), field.getName(), null);
    }

    public void addDefaultConstructor() {
        this.addConstructor(1, null, null);
    }

    public MethodWriter addConstructor(int modifiers, String[] paramTypes, String[] paramNames, String[] exceptions) {
        String decl = "";
        if (paramTypes != null && paramTypes.length > 0) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i != 0) {
                    decl = decl + ", ";
                }
                decl = decl + paramTypes[i] + " " + paramNames[i];
            }
        }
        return this.addConstructor(modifiers, decl, exceptions);
    }

    public MethodWriter addConstructor(int modifiers, String paramDecl, String[] exceptions) {
        String decl = CodeUtil.getModifierDecl(modifiers) + " " + this.className + "(";
        if (paramDecl != null) {
            decl = decl + paramDecl;
        }
        decl = decl + ")";
        if (exceptions != null && exceptions.length > 0) {
            decl = decl + " throws ";
            for (int i = 0; i < exceptions.length; ++i) {
                if (i != 0) {
                    decl = decl + ", ";
                }
                decl = decl + exceptions[i];
            }
        }
        return this.addMethod(decl);
    }

    public MethodWriter addMethod(String methodDeclaration) {
        MethodWriter mw = new MethodWriter(this);
        this.elements.add(new Element(Element.Type.METHOD, methodDeclaration, mw));
        return mw;
    }

    public MethodWriter addMethod(Method m) {
        return this.addMethod(m.getModifiers(), m);
    }

    public MethodWriter addMethod(int modifiers, Method m) {
        return this.addMethod(modifiers, m, m.getExceptionTypes());
    }

    public MethodWriter addMethod(int modifiers, Method m, Class[] exceptions) {
        return this.addMethod(modifiers, m.getReturnType(), m.getName(), m.getParameterTypes(), exceptions);
    }

    public MethodWriter addMethod(int modifiers, Class returnType, String name, Class[] paramTypes, Class[] exceptions) {
        String[] params = CodeUtil.getClassNames(paramTypes);
        String[] paramNames = CodeUtil.nameParameters(paramTypes);
        String[] exs = CodeUtil.getClassNames(exceptions);
        return this.addMethod(modifiers, CodeUtil.getClassName(returnType), name, params, paramNames, exs);
    }

    public MethodWriter addMethod(int modifiers, String returnType, String name) {
        return this.addMethod(modifiers, returnType, name, null);
    }

    public MethodWriter addMethod(int modifiers, String returnType, String name, String[] exceptions) {
        return this.addMethod(modifiers, returnType, name, null, exceptions);
    }

    public MethodWriter addMethod(int modifiers, String returnType, String name, String[] paramTypes, String[] paramNames, String[] exceptions) {
        String decl = "";
        if (paramTypes != null && paramTypes.length > 0) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i != 0) {
                    decl = decl + ", ";
                }
                decl = decl + paramTypes[i] + " " + paramNames[i];
            }
        }
        return this.addMethod(modifiers, returnType, name, decl, exceptions);
    }

    public MethodWriter addMethod(int modifiers, String returnType, String name, String paramDecl, String[] exceptions) {
        String decl = CodeUtil.getModifierDecl(modifiers) + " " + returnType + " " + name + "(";
        if (paramDecl != null) {
            decl = decl + paramDecl;
        }
        decl = decl + ")";
        if (exceptions != null && exceptions.length > 0) {
            decl = decl + " throws ";
            for (int i = 0; i < exceptions.length; ++i) {
                if (i != 0) {
                    decl = decl + ", ";
                }
                decl = decl + exceptions[i];
            }
        }
        return this.addMethod(decl);
    }

    public String getCode() {
        StringBuffer code = new StringBuffer(4096);
        code.append(this.headComment);
        code.append(this.packageDecl).append(this.newline);
        code.append(this.newline);
        code.append(this.importsPart);
        code.append(this.newline);
        code.append(this.classComment);
        code.append(this.classDecl).append(this.newline);
        code.append("{").append(this.newline);
        Element.Type prevType = Element.Type.COMMENT;
        for (Element e : this.elements) {
            Element.Type type = e.getType();
            if (prevType != Element.Type.COMMENT) {
                if (prevType == Element.Type.FIELD) {
                    if (type == Element.Type.STATIC_BLOCK || type == Element.Type.METHOD) {
                        code.append(this.newline);
                    }
                } else {
                    code.append(this.newline);
                }
            }
            switch (e.getType()) {
                case COMMENT: 
                case FIELD: {
                    code.append(this.indentUnit).append(e.getDecl()).append(this.newline);
                    break;
                }
                case STATIC_BLOCK: 
                case METHOD: {
                    code.append(this.indentUnit).append(e.getDecl()).append(this.newline);
                    code.append(this.indentUnit).append("{").append(this.newline);
                    code.append(e.getMethodWriter().getCode());
                    code.append(this.indentUnit).append("}").append(this.newline);
                }
            }
            prevType = type;
        }
        code.append("}").append(this.newline);
        return code.toString();
    }

    public void writeCode(OutputStream out) throws IOException {
        out.write(this.getCode().getBytes());
    }
}

