/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import jeus.util.codegen.CodeUtil;
import jeus.util.codegen.Element;

public abstract class CodeWriter {
    protected String packageName;
    protected int modifiers;
    protected String className;
    protected String baseClassName;
    protected StringBuffer headComment = new StringBuffer();
    protected String packageDecl;
    protected StringBuffer importsPart = new StringBuffer();
    protected StringBuffer classComment = new StringBuffer();
    protected StringBuffer classDecl = new StringBuffer();
    protected List<Element> elements = new Vector<Element>();
    protected String newline = System.getProperty("line.separator");
    protected String indentUnit = "\t";

    protected CodeWriter(String packageName, int modifiers, String className, String baseClassName) {
        this.packageName = packageName;
        this.modifiers = modifiers;
        this.className = className;
        this.baseClassName = baseClassName;
        this.packageDecl = packageName != null && !packageName.trim().equals("") ? "package " + packageName + ";" : "";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return CodeUtil.getFullClassName(this.packageName, this.className);
    }

    public void setLineSeparator(String separator) {
        this.newline = separator;
    }

    public void setIndentUnit(String indentUnit) {
        this.indentUnit = indentUnit;
    }

    public void addHeadComment(String comment) {
        this.headComment.append(comment).append(this.newline);
    }

    public void addImport(String typeName) {
        this.importsPart.append("import ").append(typeName).append(";").append(this.newline);
    }

    public void addClassComment(String comment) {
        this.classComment.append(comment).append(this.newline);
    }

    public void addComment(String comment) {
        this.elements.add(new Element(Element.Type.COMMENT, comment));
    }

    public abstract String getCode();

    public abstract void writeCode(OutputStream var1) throws IOException;
}

