/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.NoInitialContextException;
import jeus.management.JMXManagerException;
import jeus.util.console.AbstractConsole;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;

public class JeusConsole
extends AbstractConsole {
    private ArgumentedOption usernameArgumentOption = new ArgumentedOption("U", "username", "set username", null, true, true);
    private ArgumentedOption passwordArgumentOption = new ArgumentedOption("P", "password", "set password", null, true, true);
    private ArgumentedOption filenameArgumentOption = new ArgumentedOption("f", "filename", "set filename of username and password", null, true, true);
    private Option protectkeyOption = new Option("protectkey", "use protected secret key");
    private Option dynamicOption = new Option("d", "boot dynamic mode");
    private Option xmlOption = new Option("xml", "use XML (deprecated)");
    private String username = null;
    private String password = null;
    private String filename = null;
    private boolean isProtectMode = false;
    private boolean isDynamic = true;
    private boolean usexml = false;

    public JeusConsole(String consoleName, String simpleHelp) {
        super(consoleName, simpleHelp, false);
        this.registerArgument((Argument)this.usernameArgumentOption);
        this.registerArgument((Argument)this.passwordArgumentOption);
        this.registerArgument((Argument)this.filenameArgumentOption);
        this.registerArgument((Argument)this.protectkeyOption);
        this.registerArgument((Argument)this.dynamicOption);
        this.registerArgument((Argument)this.xmlOption);
    }

    public boolean checkArguments(String[] args) {
        try {
            this.consume(args);
        }
        catch (JeusImproperCommanderException e) {
            StringBuffer buf = new StringBuffer();
            for (String arg : args) {
                buf.append(arg + " ");
            }
            out.println("Invalid argument : " + buf.toString());
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (this.getHelpOption().isSet()) {
            this.printConsoleHelp();
            return false;
        }
        if (this.usernameArgumentOption.isSet()) {
            this.username = this.usernameArgumentOption.getValue();
        }
        if (this.passwordArgumentOption.isSet()) {
            this.password = this.passwordArgumentOption.getValue();
        }
        if (this.filenameArgumentOption.isSet()) {
            this.filename = this.filenameArgumentOption.getValue();
        }
        if (this.protectkeyOption.isSet()) {
            this.isProtectMode = true;
        }
        if (this.dynamicOption.isSet()) {
            this.isDynamic = true;
        }
        if (this.xmlOption.isSet()) {
            this.usexml = true;
        }
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isProtectMode() {
        return this.isProtectMode;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getIsDynamic() {
        return this.isDynamic;
    }

    public boolean getUsexml() {
        return this.usexml;
    }

    protected int runConsole() throws JeusImproperCommanderException {
        return 0;
    }

    protected void registerCommands() {
    }

    protected String getPrompt() {
        return null;
    }

    protected String getWelcomeMessage() {
        return null;
    }

    protected MBeanServerConnection initializeConnection() throws JMXManagerException, NoInitialContextException {
        return null;
    }

    protected ObjectName getTargetObjectName() throws Exception {
        return null;
    }
}

