/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.naming.InitialContext;
import javax.naming.NoInitialContextException;
import jeus.management.JMXManagerException;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.security.admin.command.AddCredentialCommand;
import jeus.security.admin.command.AddGroupCommand;
import jeus.security.admin.command.AddPrincipalCommand;
import jeus.security.admin.command.AddSubjectCommand;
import jeus.security.admin.command.AddUserToGroupCommand;
import jeus.security.admin.command.AssignResourceCommand;
import jeus.security.admin.command.AssignRoleCommand;
import jeus.security.admin.command.AuthorizeResourceCommand;
import jeus.security.admin.command.AuthorizeRoleCommand;
import jeus.security.admin.command.CheckResourceCommand;
import jeus.security.admin.command.CheckRoleCommand;
import jeus.security.admin.command.ClearSubjectExpirationCommand;
import jeus.security.admin.command.ExcludeResourceCommand;
import jeus.security.admin.command.ExcludeRoleCommand;
import jeus.security.admin.command.GetGroupCommand;
import jeus.security.admin.command.GetGroupDescriptionCommand;
import jeus.security.admin.command.GetGroupListCommand;
import jeus.security.admin.command.GetGroupNamesCommand;
import jeus.security.admin.command.GetMembersFromGroupCommand;
import jeus.security.admin.command.GetPolicyCommand;
import jeus.security.admin.command.GetPolicyIdsCommand;
import jeus.security.admin.command.GetSubjectCommand;
import jeus.security.admin.command.GetSubjectNamesCommand;
import jeus.security.admin.command.GroupExistCommand;
import jeus.security.admin.command.IncludeResourceCommand;
import jeus.security.admin.command.IncludeRoleCommand;
import jeus.security.admin.command.IsMemberCommand;
import jeus.security.admin.command.LockSubjectCommand;
import jeus.security.admin.command.RemoveCredentialCommand;
import jeus.security.admin.command.RemoveGroupCommand;
import jeus.security.admin.command.RemovePrincipalCommand;
import jeus.security.admin.command.RemoveSubjectCommand;
import jeus.security.admin.command.RemoveUserFromGroupCommand;
import jeus.security.admin.command.SavePolicyCommand;
import jeus.security.admin.command.SaveSubjectCommand;
import jeus.security.admin.command.SetGroupDescriptionCommand;
import jeus.security.admin.command.SetPasswordCommand;
import jeus.security.admin.command.SetSubjectDescriptionCommand;
import jeus.security.admin.command.SetSubjectExpirationCommand;
import jeus.security.admin.command.UnassignResourceCommand;
import jeus.security.admin.command.UnassignRoleCommand;
import jeus.security.admin.command.UncheckResourceCommand;
import jeus.security.admin.command.UncheckRoleCommand;
import jeus.security.admin.command.UnlockSubjectCommand;
import jeus.security.admin.command.UserExistCommand;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.server.NodeControllerStub;
import jeus.server.manager.JeusVersion;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.Runner;
import jeus.util.VirtualDNS;
import jeus.util.console.AbstractConsole;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Command;
import jeus.util.console.Group;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.OptionalLineArgument;
import jeus.util.console.command.AllEngineListCommand;
import jeus.util.console.command.AllNodeListCommand;
import jeus.util.console.command.AppListCommand;
import jeus.util.console.command.BootCommand;
import jeus.util.console.command.ConListCommand;
import jeus.util.console.command.ConnectCommand;
import jeus.util.console.command.DeployCommand;
import jeus.util.console.command.DistributeCommand;
import jeus.util.console.command.DownCommand;
import jeus.util.console.command.DownConCommand;
import jeus.util.console.command.DumpCommand;
import jeus.util.console.command.EJBBeanListCommand;
import jeus.util.console.command.EJBCompileCommand;
import jeus.util.console.command.EJBModuleInfoCommand;
import jeus.util.console.command.EngListCommand;
import jeus.util.console.command.FtpCommand;
import jeus.util.console.command.GCCommand;
import jeus.util.console.command.JDBCConInfoCommand;
import jeus.util.console.command.JDBCControlClusterDataSourceCommand;
import jeus.util.console.command.JDBCCreateCommand;
import jeus.util.console.command.JDBCDisableCommand;
import jeus.util.console.command.JDBCEnableCommand;
import jeus.util.console.command.JDBCInfoCommand;
import jeus.util.console.command.JDBCReconfigCommand;
import jeus.util.console.command.JDBCRefreshCommand;
import jeus.util.console.command.JDBCResyncCommand;
import jeus.util.console.command.JDBCShrinkCommand;
import jeus.util.console.command.JDBCTestConfigCommand;
import jeus.util.console.command.JeusExitCommand;
import jeus.util.console.command.JndiCommand;
import jeus.util.console.command.JndiListCommand;
import jeus.util.console.command.LogLevelCommand;
import jeus.util.console.command.MBeanListCommand2;
import jeus.util.console.command.MemInfoCommand;
import jeus.util.console.command.NodeListCommand;
import jeus.util.console.command.PidListCommand;
import jeus.util.console.command.ReloadCommand;
import jeus.util.console.command.RftpCommand;
import jeus.util.console.command.SelectContainerCommand;
import jeus.util.console.command.StartCommand;
import jeus.util.console.command.StartConCommand;
import jeus.util.console.command.StopCommand;
import jeus.util.console.command.TMResyncCommand;
import jeus.util.console.command.TXListCommand;
import jeus.util.console.command.UndeployCommand;
import jeus.util.console.command.WCClearStatCommand;
import jeus.util.console.command.WCConfigInfoCommand;
import jeus.util.console.command.WCInfoCommand;
import jeus.util.console.command.WCReloadCommand;
import jeus.util.console.command.WCResumeCommand;
import jeus.util.console.command.WCSetConfigInfoCommand;
import jeus.util.console.command.WCStatCommand;
import jeus.util.console.command.WCSuspendCommand;
import jeus.util.console.command.WCThreadInfoCommand;
import jeus.util.console.command.WCWebToBCommand;
import jeus.util.console.group.EJBEngineGroup;
import jeus.util.console.group.JDBCGroup;
import jeus.util.console.group.JeusGroup;
import jeus.util.console.group.SecurityGroup;
import jeus.util.console.group.ServletEngineGroup;
import jeus.util.console.group.TMGroup;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.message.JeusMessage_Manager;

public class JeusadminConsole
extends AbstractConsole {
    private static NodeControllerStub stub;
    private static MBeanServerConnection utility;
    private static String connectorRefJndiName;
    private Option versionOption = new Option("version", "show version");
    private Option fullversionOption = new Option("fullversion", "show full version");
    private Option buildversionOption = new Option("buildversion", "show build version");
    private Option licensedueOption = new Option("licensedue", "show license due");
    private Option licenseinfoOption = new Option("licenseinfo", "show license info");
    private Option verboseOption = new Option("verbose", "show logging information");
    private ArgumentedOption jmxConnectorArgumentOption = new ArgumentedOption("jmx-connector", "jmx_connector_name", "set JMX connector name");
    private OptionalArgument nodeNameOptionalArgument = new OptionalArgument("nodename", "set node name");
    private ArgumentedOption usernameArgumentOption = new ArgumentedOption("U", "username", "set username", null, true, true);
    private ArgumentedOption passwordArgumentOption = new ArgumentedOption("P", "password", "set password", null, true, true);
    private ArgumentedOption filenameArgumentOption = new ArgumentedOption("f", "filename", "set filename of username and password", null, true, true);
    private OptionalArgument commandOptionalArgument = new OptionalArgument("command", "execute the command by one-step");
    private OptionalLineArgument commandOptionOptionalLineArgument = new OptionalLineArgument("command_option", "set options for one-step command executing");

    public JeusadminConsole(String consoleName, String simpleHelp) {
        super(consoleName, simpleHelp, true);
        this.registerArgument((Argument)this.versionOption);
        this.registerArgument((Argument)this.fullversionOption);
        this.registerArgument((Argument)this.buildversionOption);
        this.registerArgument((Argument)this.licensedueOption);
        this.registerArgument((Argument)this.licenseinfoOption);
        this.registerArgument((Argument)this.verboseOption);
        this.registerArgument((Argument)this.jmxConnectorArgumentOption);
        this.registerArgument((Argument)this.nodeNameOptionalArgument);
        this.registerArgument((Argument)this.usernameArgumentOption);
        this.registerArgument((Argument)this.passwordArgumentOption);
        this.registerArgument((Argument)this.filenameArgumentOption);
        this.registerArgument((Argument)this.commandOptionalArgument);
        this.registerArgument((Argument)this.commandOptionOptionalLineArgument);
    }

    protected int runConsole() throws JeusImproperCommanderException {
        if (JeusBootstrapProperties.JEUS_HOME == null) {
            throw new JeusRuntimeException(JeusMessage_Manager.MGR_2);
        }
        try {
            if (this.displayInfos()) {
                return 0;
            }
        }
        catch (Exception e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        if (this.verboseOption.isSet() && !this.enableVerbose()) {
            out.println("[ERROR]Fail to enable verbose mode (logger ON)");
            return -1;
        }
        if (this.jmxConnectorArgumentOption.isSet()) {
            connectorRefJndiName = this.jmxConnectorArgumentOption.getValue();
        }
        if (!this.nodeNameOptionalArgument.isSet()) {
            out.println(JeusMessage_Manager.MGR_38_MSG);
            throw new JeusRuntimeException(JeusMessage_Manager.MGR_38);
        }
        this.nodeName = this.nodeNameOptionalArgument.getValue();
        this.realNodeName = VirtualDNS.getRealNodeName(this.nodeName);
        String username = null;
        String password = null;
        String filename = null;
        String command = null;
        String commandOption = null;
        if (this.usernameArgumentOption.isSet()) {
            username = this.usernameArgumentOption.getValue();
        }
        if (this.passwordArgumentOption.isSet()) {
            password = this.passwordArgumentOption.getValue();
        }
        if (this.filenameArgumentOption.isSet()) {
            filename = this.filenameArgumentOption.getValue();
        }
        VirtualDNS.setLocalNode(this.nodeName);
        if (!this.login(this.nodeName, username, password, filename)) {
            out.println("[ERROR] fail to login");
            return 1;
        }
        if (!this.checkServerRun()) {
            out.println("[ERROR] fail to check server run");
            return 1;
        }
        if (this.commandOptionalArgument.isSet()) {
            command = this.commandOptionalArgument.getValue();
            ArrayList<String> list = new ArrayList<String>();
            list.add(command);
            if (this.commandOptionOptionalLineArgument.isSet()) {
                commandOption = this.commandOptionOptionalLineArgument.getValue();
                StringTokenizer st = new StringTokenizer(commandOption, " ");
                while (st.hasMoreElements()) {
                    list.add(st.nextToken());
                }
            }
            String[] cmds = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                cmds[i] = (String)list.get(i);
            }
            this.processOneStepRequest(cmds);
            return 0;
        }
        return 2;
    }

    private void debugPrintArgument(PrintStream out, Argument arg) {
        out.println("Name: " + arg.getName());
        out.println("Comment: " + arg.getComment());
        out.println("Default Comment: " + arg.getDefaultComment());
        out.println("Value: " + arg.getValue());
        out.println("Expression: " + arg.getExpression());
        if (arg.getDefaultComment() != null) {
            out.println("DefinedValues: " + arg.getDefinedValues().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCommands() {
        JeusGroup jeusGroup = new JeusGroup(this.getConsoleName() + " Commands", this.getConsoleName());
        jeusGroup.setUtility(utility);
        jeusGroup.setNodeName(this.nodeName);
        this.setDefaultGroup(jeusGroup);
        this.registerGroup(jeusGroup);
        Command.setGroupListener((String)"container.name", (Group)jeusGroup);
        jeusGroup.registerCommand(new AllEngineListCommand());
        jeusGroup.registerCommand(new GCCommand());
        jeusGroup.registerCommand(new BootCommand(this.nodeName, this.realNodeName));
        jeusGroup.registerCommand(new DownCommand(this.nodeName, this.input, this.realNodeName));
        jeusGroup.registerCommand(new DownConCommand());
        jeusGroup.registerCommand(new StartConCommand());
        jeusGroup.registerCommand(new EngListCommand());
        jeusGroup.registerCommand(new ConListCommand());
        jeusGroup.registerCommand(new SelectContainerCommand());
        jeusGroup.registerCommand(new FtpCommand(this.nodeName, this.realNodeName));
        jeusGroup.registerCommand(new RftpCommand(this.nodeName, this.realNodeName));
        jeusGroup.registerCommand(new AllNodeListCommand());
        jeusGroup.registerCommand(new NodeListCommand());
        jeusGroup.registerCommand(new JndiCommand());
        jeusGroup.registerCommand(new JndiListCommand());
        jeusGroup.registerCommand(new JeusExitCommand(this.nodeName, this.realNodeName));
        jeusGroup.registerCommand(new PidListCommand());
        jeusGroup.registerCommand(new ConnectCommand());
        jeusGroup.registerCommand(new MemInfoCommand());
        jeusGroup.registerCommand(new DumpCommand());
        jeusGroup.registerCommand(new MBeanListCommand2());
        jeusGroup.registerCommand(new LogLevelCommand());
        jeusGroup.registerCommand(new DistributeCommand());
        jeusGroup.registerCommand(new DeployCommand());
        jeusGroup.registerCommand(new UndeployCommand());
        jeusGroup.registerCommand(new ReloadCommand());
        jeusGroup.registerCommand(new AppListCommand());
        jeusGroup.registerCommand(new StartCommand());
        jeusGroup.registerCommand(new StopCommand());
        EJBEngineGroup ejbGroup = new EJBEngineGroup();
        this.registerGroup(ejbGroup);
        ejbGroup.registerCommand(new EJBModuleInfoCommand());
        ejbGroup.registerCommand(new EJBBeanListCommand());
        ejbGroup.registerCommand(new EJBCompileCommand());
        JDBCGroup dbGroup = new JDBCGroup();
        this.registerGroup(dbGroup);
        Command.setGroupListener((String)"container.name", (Group)dbGroup);
        dbGroup.registerCommand(new JDBCInfoCommand());
        dbGroup.registerCommand(new JDBCEnableCommand());
        dbGroup.registerCommand(new JDBCDisableCommand());
        dbGroup.registerCommand(new JDBCShrinkCommand());
        dbGroup.registerCommand(new JDBCResyncCommand());
        dbGroup.registerCommand(new JDBCReconfigCommand(this.input));
        dbGroup.registerCommand(new JDBCConInfoCommand());
        dbGroup.registerCommand(new JDBCTestConfigCommand());
        dbGroup.registerCommand(new JDBCCreateCommand());
        dbGroup.registerCommand(new JDBCRefreshCommand());
        dbGroup.registerCommand(new JDBCControlClusterDataSourceCommand());
        TMGroup tmGroup = new TMGroup();
        this.registerGroup(tmGroup);
        Command.setGroupListener((String)"container.name", (Group)tmGroup);
        tmGroup.registerCommand(new TMResyncCommand());
        tmGroup.registerCommand(new TXListCommand());
        ServletEngineGroup webGroup = new ServletEngineGroup();
        this.registerGroup(webGroup);
        Command.setGroupListener((String)"container.name", (Group)webGroup);
        webGroup.registerCommand(new WCConfigInfoCommand());
        webGroup.registerCommand(new WCInfoCommand());
        webGroup.registerCommand(new WCSetConfigInfoCommand());
        webGroup.registerCommand(new WCStatCommand());
        webGroup.registerCommand(new WCThreadInfoCommand());
        webGroup.registerCommand(new WCWebToBCommand());
        webGroup.registerCommand(new WCClearStatCommand());
        webGroup.registerCommand(new WCResumeCommand());
        webGroup.registerCommand(new WCReloadCommand());
        webGroup.registerCommand(new WCSuspendCommand());
        SecurityGroup securityGroup = new SecurityGroup();
        securityGroup.setNodeName(this.nodeName);
        this.registerGroup(securityGroup);
        Command.setGroupListener((String)"container.name", (Group)securityGroup);
        securityGroup.registerCommand(new AddSubjectCommand());
        securityGroup.registerCommand(new RemoveSubjectCommand());
        securityGroup.registerCommand(new GetSubjectNamesCommand());
        securityGroup.registerCommand(new GetSubjectCommand());
        securityGroup.registerCommand(new SetPasswordCommand());
        securityGroup.registerCommand(new LockSubjectCommand());
        securityGroup.registerCommand(new UnlockSubjectCommand());
        securityGroup.registerCommand(new SetSubjectExpirationCommand());
        securityGroup.registerCommand(new ClearSubjectExpirationCommand());
        securityGroup.registerCommand(new AddPrincipalCommand());
        securityGroup.registerCommand(new RemovePrincipalCommand());
        securityGroup.registerCommand(new SetSubjectDescriptionCommand());
        securityGroup.registerCommand(new AddCredentialCommand());
        securityGroup.registerCommand(new RemoveCredentialCommand());
        securityGroup.registerCommand(new SaveSubjectCommand());
        securityGroup.registerCommand(new UserExistCommand());
        securityGroup.registerCommand(new AddGroupCommand());
        securityGroup.registerCommand(new AddUserToGroupCommand());
        securityGroup.registerCommand(new RemoveGroupCommand());
        securityGroup.registerCommand(new RemoveUserFromGroupCommand());
        securityGroup.registerCommand(new GetGroupCommand());
        securityGroup.registerCommand(new GetGroupNamesCommand());
        securityGroup.registerCommand(new GetGroupListCommand());
        securityGroup.registerCommand(new GetGroupDescriptionCommand());
        securityGroup.registerCommand(new SetGroupDescriptionCommand());
        securityGroup.registerCommand(new GetMembersFromGroupCommand());
        securityGroup.registerCommand(new IsMemberCommand());
        securityGroup.registerCommand(new GroupExistCommand());
        securityGroup.registerCommand(new GetPolicyCommand());
        securityGroup.registerCommand(new GetPolicyIdsCommand());
        securityGroup.registerCommand(new AssignRoleCommand());
        securityGroup.registerCommand(new UnassignRoleCommand());
        securityGroup.registerCommand(new ExcludeRoleCommand());
        securityGroup.registerCommand(new IncludeRoleCommand());
        securityGroup.registerCommand(new UncheckRoleCommand());
        securityGroup.registerCommand(new CheckRoleCommand());
        securityGroup.registerCommand(new AssignResourceCommand());
        securityGroup.registerCommand(new UnassignResourceCommand());
        securityGroup.registerCommand(new ExcludeResourceCommand());
        securityGroup.registerCommand(new IncludeResourceCommand());
        securityGroup.registerCommand(new UncheckResourceCommand());
        securityGroup.registerCommand(new CheckResourceCommand());
        securityGroup.registerCommand(new SavePolicyCommand());
        securityGroup.registerCommand(new AuthorizeRoleCommand());
        securityGroup.registerCommand(new AuthorizeResourceCommand());
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources("META-INF/command.properties");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = url.openStream();
                try {
                    Properties p = new Properties();
                    p.load(is);
                    for (Object key : p.keySet()) {
                        String groupClassName = (String)key;
                        String commandClasses = p.getProperty(groupClassName);
                        StringTokenizer tokenizer = new StringTokenizer(commandClasses, ",");
                        ArrayList<String> classList = new ArrayList<String>();
                        while (tokenizer.hasMoreTokens()) {
                            classList.add(tokenizer.nextToken());
                        }
                        if (classList.size() <= 0) continue;
                        Class<?> groupClass = loader.loadClass(groupClassName);
                        Group groupInstance = (Group)groupClass.newInstance();
                        this.registerGroup(groupInstance);
                        Command.setGroupListener((String)"container.name", (Group)groupInstance);
                        for (String className : classList) {
                            Constructor<?>[] constructor;
                            Class<?> commandClass = loader.loadClass(className);
                            Command command = null;
                            for (Constructor<?> constructor1 : constructor = commandClass.getConstructors()) {
                                Class<?>[] classes = constructor1.getParameterTypes();
                                if (classes.length != 1 || classes[0] != MBeanServerConnection.class) continue;
                                command = (Command)constructor1.newInstance(utility);
                                break;
                            }
                            if (command == null) {
                                command = (Command)commandClass.newInstance();
                            }
                            groupInstance.registerCommand(command);
                        }
                    }
                }
                catch (Exception e) {
                    out.println("[ERROR] Failed to read properties from the input stream.");
                }
                finally {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            out.println("[ERROR] Failed to open META-INF/command.properties file.");
        }
    }

    private boolean displayInfos() throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        if (this.versionOption.isSet()) {
            out.println(JeusVersion.getVersion());
        } else if (this.fullversionOption.isSet()) {
            out.println(JeusVersion.getFullVersion());
        } else if (this.buildversionOption.isSet()) {
            out.println(JeusVersion.getBuildVersion());
        } else if (this.licensedueOption.isSet()) {
            long time = Runner.getLicenseDue();
            if (time == -1L) {
                out.println("Invalid License");
            } else if (time == -2L) {
                out.println("Unlimited");
            } else if (time == -3L) {
                out.println("-licensedue is not supported in WebToB");
            } else {
                long timeleft = time - System.currentTimeMillis();
                if (timeleft < 0L) {
                    out.println("License Expired");
                } else {
                    out.println(Long.toString(timeleft / 86400000L) + " days left.");
                }
            }
        } else if (this.licenseinfoOption.isSet()) {
            Runner.getLicenseInfo();
        } else {
            return false;
        }
        return true;
    }

    protected String getPrompt() {
        String[] containerNames = Command.getListProperty((String)"container.name");
        String prompt = "";
        if (containerNames == null) {
            return this.nodeName;
        }
        for (String container : containerNames) {
            prompt = prompt + container + ";";
        }
        return prompt.substring(0, prompt.lastIndexOf(";"));
    }

    protected String getWelcomeMessage() {
        return new String(ErrorMsgManager.getErrMessage((int)JeusMessage_Manager.MGR_12).getErrorString((Object)JeusVersion.getVersion()));
    }

    protected MBeanServerConnection initializeConnection() throws JMXManagerException, NoInitialContextException {
        block9: {
            this.nodeName = VirtualDNS.getVirtualNameFromServer(this.realNodeName);
            stub = new NodeControllerStub();
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
            env.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
            env.put("java.naming.provider.url", this.realNodeName);
            if (connectorRefJndiName != null) {
                try {
                    try {
                        Subject s = LoginService.getCurrentSubject();
                        env.put("jeus.subject", s);
                    }
                    catch (Exception e) {
                        throw new JeusRuntimeException(JeusMessage_JMX._74, (Throwable)e);
                    }
                    InitialContext context = new InitialContext(env);
                    JMXConnector connector = (JMXConnector)context.lookup(connectorRefJndiName);
                    try {
                        connector.connect();
                        utility = connector.getMBeanServerConnection();
                        break block9;
                    }
                    catch (IOException ex) {
                        block10: {
                            try {
                                connector.close();
                            }
                            catch (Exception e) {
                                out.println("Exception occurred during closing RemoteMBeanServerConnection");
                                if (!logger.isLoggable(JeusMessage_JMX.JMX_09_LEVEL)) break block10;
                                logger.log(JeusMessage_JMX.JMX_09_LEVEL, JeusMessage_JMX.JMX_09, (Throwable)e);
                            }
                        }
                        throw ex;
                    }
                }
                catch (Exception e) {
                    throw new JeusRuntimeException((Throwable)e);
                }
            }
            utility = MEJBUtility.getMEJBUtility(env);
        }
        return utility;
    }

    protected ObjectName getTargetObjectName() throws Exception {
        String query = "JEUS:jeusType=JeusManager,name=" + this.nodeName + "," + "JMXManager" + "=" + this.nodeName + "," + "*";
        return new ObjectName(query);
    }

    public static void main(String[] args) {
        JeusadminConsole commander = new JeusadminConsole("jeusadmin", "JEUS administration tool");
        int result = commander.mainMethod(args);
        if (result >= 0) {
            System.exit(result);
        }
    }
}

