/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console;

import java.io.PrintStream;
import java.util.Date;
import jeus.util.console.Repeater;

public class TimeRepeater
implements Repeater {
    private long endTime;
    private int count;
    private int interval;
    private boolean started;
    private int repeatTime;
    private int repeatIntval;
    private PrintStream out;

    private TimeRepeater() {
    }

    public TimeRepeater(int repeatTime, int repeatIntval, PrintStream out) {
        this.repeatTime = repeatTime;
        this.repeatIntval = repeatIntval;
        this.out = out;
    }

    public boolean isRepeatable() {
        long ctime = System.currentTimeMillis();
        if (ctime < this.endTime) {
            if (!this.started) {
                this.started = true;
            } else {
                try {
                    Thread.sleep(this.interval * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.out.println("[" + new Date() + "] trials = " + ++this.count);
            return true;
        }
        return false;
    }

    public void reset() {
        long nowTime = System.currentTimeMillis();
        this.endTime = nowTime + (long)(this.repeatTime * 1000);
        this.interval = this.repeatIntval;
        this.started = false;
        this.count = 0;
        this.out.println("total repeat time: " + this.repeatTime + " s, last time: " + new Date(this.endTime) + ", repeat interval: " + this.interval + " s");
    }
}

