/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.util.console.Argument;
import jeus.util.console.DefinedValue;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class AllEngineListCommand
extends JeusMBeanCommand {
    private OptionalArgument nodeNameArg = new OptionalArgument("node_name", "node name in which engines run", "the node admin connected");
    private OptionalArgument engineTypeArg;
    private static final DefinedValue SERVLET = new DefinedValue("servlet", "get a list of all working servlet engines");
    private static final DefinedValue EJB = new DefinedValue("ejb", "get a list of all working ejb engines");
    private static final DefinedValue JMS = new DefinedValue("jms", "get a list of all working jms engines");

    public AllEngineListCommand() {
        super("allenglist", "get a list of all working engines");
        this.registerArgument((Argument)this.nodeNameArg);
        this.engineTypeArg = new OptionalArgument("engineType", "node name in which engines run", "the node admin connected");
        this.engineTypeArg.setDefinedValues(new DefinedValue[]{SERVLET, EJB, JMS}, true);
        this.registerArgument((Argument)this.engineTypeArg);
    }

    public void run(PrintStream out) throws Exception {
        String node = this.nodeNameArg.isSet() ? this.nodeNameArg.getValue() : this.nodeName;
        JEUSManagerMBean manager = this.getJeusManagerMoMBean(node);
        String[] serverNames = manager.getj2eeServers();
        for (int i = 0; i < serverNames.length; ++i) {
            ObjectName serverObjectName = new ObjectName(serverNames[i]);
            J2EEServerMBean server = JMXUtility.getProxy(this.utility, serverObjectName, J2EEServerMBean.class, false);
            out.println("========================================");
            out.println("engines in the container " + serverObjectName.getKeyProperty("name"));
            AllEngineListCommand.printNameValuesWithCondition(out, server.getEngines(), this.engineTypeArg.getValue());
            out.println("========================================");
        }
    }
}

