/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.StateManageable;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.ApplicationCommand;

public class AppListCommand
extends ApplicationCommand {
    protected static final String[] moduleStates = new String[]{"starting", "running", "stopping", "stopped", "failed"};
    private String containerName;

    public AppListCommand() {
        super("applist", "list applications");
    }

    public AppListCommand(String containerConnected) {
        this();
        this.containerName = containerConnected;
    }

    public void run(PrintStream out) throws Exception {
        if (this.containerName != null) {
            this.conOption.setValue(this.containerName);
        }
        ObjectName[] moduleObjectNames = new ObjectName[]{};
        try {
            moduleObjectNames = this.getJ2EEDeployedObjects();
        }
        catch (JeusImproperCommanderException ex) {
            throw ex;
        }
        catch (IllegalArgumentException iae) {
            out.println("there is no module corresponding to the request");
        }
        catch (Exception ex) {
            throw new JeusImproperCommanderException(ex.getMessage());
        }
        for (int i = 0; i < moduleObjectNames.length; ++i) {
            ObjectName moduleObjectName = moduleObjectNames[i];
            StateManageable stateManageble = JMXUtility.getProxy(this.utility, moduleObjectName, StateManageable.class, false);
            out.println("name : " + moduleObjectName.getKeyProperty("name") + "\n\ttype : " + moduleObjectName.getKeyProperty("j2eeType") + "\tEngineContainer : " + moduleObjectName.getKeyProperty("J2EEServer") + "\tnode : " + moduleObjectName.getKeyProperty("JeusManager") + "\tstate : " + moduleStates[stateManageble.getstate()]);
        }
    }
}

