/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.command.DeploymentCommander;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.management.JMXUtility;
import jeus.server.manager.JeusCommanderException;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.StringUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Command;
import jeus.util.console.DefinedValue;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.xml.binding.jeusDD.AllTargetsType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.ApplicationType;

public abstract class ApplicationCommand
extends JeusMBeanCommand {
    protected static DeploymentCommander commander = new DeploymentCommander();
    private OptionalArgument moduleNameArg;
    protected ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container applications run", "all containers in the JEUS Manager");
    protected ArgumentedOption moduleOption;
    private Option regularExpressionOption;
    private ArgumentedOption nameDeployOption;
    protected String nodeName;
    private static final DefinedValue WEBMODULE = new DefinedValue("WebModule", "web module");
    private static final DefinedValue EJBMODULE = new DefinedValue("EJBModule", "ejb module");
    private static final DefinedValue EARMODULE = new DefinedValue("J2EEApplication", "ear module");
    private static final DefinedValue CLIENTMODULE = new DefinedValue("AppClientModule", "application client module");
    private static final DefinedValue RESOURCEMODULE = new DefinedValue("ResourceAdapterModule", "resource adapter module");

    public ApplicationCommand(String name, String comment) {
        super(name, comment);
        this.registerArgument((Argument)this.conOption);
        this.moduleOption = new ArgumentedOption("mod", "module_type", "work for the specified module type", "all module types");
        this.moduleOption.setDefinedValues(new DefinedValue[]{WEBMODULE, EJBMODULE, EARMODULE, CLIENTMODULE, RESOURCEMODULE}, true);
        this.registerArgument((Argument)this.moduleOption);
        this.regularExpressionOption = new Option("r", "regard the module name as regular expression");
        this.registerArgument((Argument)this.regularExpressionOption);
        this.addAdditionalOptions();
        this.nameDeployOption = new ArgumentedOption("n", "application_name", "application registered in JEUSMain.xml");
        this.moduleNameArg = new OptionalArgument("module_name", "module name", "work for all applications");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.nameDeployOption, this.moduleNameArg}));
    }

    protected void addAdditionalOptions() {
    }

    protected ObjectName[] getJ2EEDeployedObjects() throws IOException, IllegalJeusSystemNameException {
        String moduleName = null;
        boolean all = false;
        String[] containers = null;
        String moduleMBeanType = null;
        boolean isRegEx = this.regularExpressionOption.isSet();
        boolean useAliasNameWhenDeploy = false;
        ObjectName[] moduleObjectNames = null;
        boolean isAlltarget = false;
        String node = this.getGroup().getNodeName();
        if (this.moduleNameArg.isSet()) {
            moduleName = this.moduleNameArg.getValue();
        } else if (this.nameDeployOption.isSet()) {
            useAliasNameWhenDeploy = true;
            moduleName = this.nameDeployOption.getValue();
        } else {
            all = true;
        }
        if (this.conOption.isSet()) {
            containers = new String[]{this.conOption.getValue()};
        } else if (!useAliasNameWhenDeploy) {
            containers = Command.getListProperty((String)"container.name");
        }
        if (this.moduleOption.isSet()) {
            moduleMBeanType = this.moduleOption.getValue();
        }
        if (useAliasNameWhenDeploy) {
            if (containers != null && containers.length > 0 || all || moduleMBeanType != null || isRegEx) {
                throw new JeusCommanderException("-n option can not use with -con, -mode or -r options");
            }
            Iterator iter = JeusMainDescriptorJB.getJeusMainDescriptor().getApplication().iterator();
            ApplicationType application = null;
            while (iter.hasNext() && !moduleName.equals(JeusDeploymentManager.getApplicationName(application = (ApplicationType)iter.next()))) {
                application = null;
            }
            if (application == null) {
                throw new JeusImproperCommanderException("The given name does not exist in JEUSMain.xml : " + moduleName);
            }
            List targets = application.getDeploymentTarget().getAllTargetsOrTarget();
            for (int j = 0; j < targets.size(); ++j) {
                Object target = targets.get(j);
                if (target instanceof AppTargetType) {
                    AppTargetType t = (AppTargetType)target;
                    String containerName = t.getEngineContainerName();
                    String nodeName = t.getNodeName();
                    if (containerName != null) {
                        containers = new String[]{containerName};
                        node = StringUtil.getNodeNameFromContainerName((String)containers[0]);
                        continue;
                    }
                    node = nodeName;
                    continue;
                }
                if (!(target instanceof AllTargetsType)) continue;
                isAlltarget = true;
            }
        }
        if (isAlltarget) {
            moduleObjectNames = JMXUtility.queryJ2EEDeployedApplications(this.utility, null, null, null, moduleName);
        } else {
            if (containers == null || containers.length == 0) {
                moduleObjectNames = JMXUtility.queryJ2EEDeployedApplications(this.utility, node, null, moduleMBeanType, null);
            } else {
                ArrayList moduleObjectNameList = new ArrayList();
                ArrayList<Object> moduleObjectNameListInAContainer = new ArrayList();
                for (int i = 0; i < containers.length; ++i) {
                    moduleObjectNameListInAContainer = JMXUtility.queryJ2EEDeployedApplicationList(this.utility, node, containers[i], moduleMBeanType, null);
                    if (moduleObjectNameListInAContainer == null) continue;
                    moduleObjectNameList.addAll(moduleObjectNameListInAContainer);
                }
                if (moduleObjectNameList.toArray() != null) {
                    moduleObjectNames = moduleObjectNameList.toArray(new ObjectName[moduleObjectNameList.size()]);
                }
            }
            if (moduleName != null && !moduleName.equals("") && moduleObjectNames != null) {
                moduleObjectNames = ApplicationCommand.getMatchedString(moduleName, moduleObjectNames, isRegEx);
            }
        }
        if (moduleObjectNames.length == 0) {
            throw new IllegalArgumentException("there is no module corresponding to the request");
        }
        return moduleObjectNames;
    }

    private String[] deleteDupulicatedStrings(String[] modules) {
        if (modules.length < 2) {
            return modules;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(modules[0]);
        for (int i = 1; i < modules.length; ++i) {
            String st2;
            String st1 = modules[i];
            for (int j = 0; j < i && !st1.equals(st2 = modules[j]); ++j) {
                if (j != i - 1) continue;
                nameList.add(st1);
            }
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    protected boolean isAll() {
        return !this.nameDeployOption.isSet() && !this.moduleNameArg.isSet();
    }
}

