/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.StringTokenizer;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.TargetImpl;
import jeus.deploy.command.DeploymentCommander;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.runtime.ApplicationRuntimeDDFile;
import jeus.deploy.status.DeploymentStatusImpl;
import jeus.deploy.status.JeusProgressObject;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.server.manager.JeusCommanderException;
import jeus.util.JeusProperties;
import jeus.util.StringUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Command;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JeusGroup;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.AllTargetsType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.AutoDeployType;
import jeus.xml.binding.jeusDD.ClassFtpUnitType;
import jeus.xml.binding.jeusDD.ClassloadingType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.WebContextGroupType;

public class DistributeCommand
extends JeusMBeanCommand {
    private static DeploymentCommander commander = new DeploymentCommander();
    private String jeusMainNode;
    Argument moduleNameArg;
    ArgumentedOption absolutePathOption;
    ArgumentedOption nameDeployOption;
    ArgumentedOption asOption;
    ArgumentedOption conOption;
    ArgumentedOption nodeOption;
    ArgumentedOption contextGroupOption;
    ArgumentedOption virtualHostOption;
    Option fastDeployOption;
    Option notFastDeployOption;
    Option keepOption;
    Option notKeepOption;
    Option permanentOption;
    Option writeAppDDOption;
    ArgumentedOption classloadingOption;
    ArgumentedOption classFtpUnitOption;
    ArgumentedOption autoOption;
    ArgumentedOption jeusEjbDDOption;
    boolean onlyDistribute;
    protected String containerName;

    public DistributeCommand() {
        this("distribute", "distribute application");
        this.onlyDistribute = true;
    }

    protected DistributeCommand(String name, String comment) {
        super(name, comment);
        this.jeusMainNode = this.nodeName;
        this.conOption = new ArgumentedOption("con", "container_name", "container to deploy", "deploy to all containers in the JEUS Manager");
        this.nodeOption = new ArgumentedOption("node", "node_name", "deploy to all containers in the specified node", "the node admin connected");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.conOption, this.nodeOption}));
        this.contextGroupOption = new ArgumentedOption("cg", "context_group_name", "context group for web application", "the first context group in the WebMain.xml");
        this.registerArgument((Argument)this.contextGroupOption);
        this.virtualHostOption = new ArgumentedOption("vh", "virtual_host_name", "virtual host for web application", "the first virtual host in the WebMain.xml");
        this.registerArgument((Argument)this.virtualHostOption);
        this.fastDeployOption = new Option("f", "fast deploy");
        this.notFastDeployOption = new Option("nf", "DO NOT use fast deploy");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.fastDeployOption, this.notFastDeployOption}));
        this.keepOption = new Option("keep", "keep generated class source");
        this.notKeepOption = new Option("nkeep", "DO NOT keep generated class source");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.keepOption, this.notKeepOption}));
        this.permanentOption = new Option("per", "insert to JEUSMain.xml so that make this application be deployed at booting time");
        this.registerArgument((Argument)this.permanentOption);
        this.classloadingOption = new ArgumentedOption("classloading", "SHARED|ISOLATED", "set the classloading mode to SHARED or ISOLATED", "ISOLATED");
        this.registerArgument((Argument)this.classloadingOption);
        this.writeAppDDOption = new Option("writeAppDD", "save generated jeus-application-dd.xml to the application archive");
        this.registerArgument((Argument)this.writeAppDDOption);
        this.classFtpUnitOption = new ArgumentedOption("class-ftp-unit", "CLASS|JAR", "set class ftp unit to CLASS or JAR", "JAR");
        this.registerArgument((Argument)this.classFtpUnitOption);
        this.autoOption = new ArgumentedOption("auto", "auto_deploy_interval", "watch application archive for auto-redeploy");
        this.registerArgument((Argument)this.autoOption);
        this.jeusEjbDDOption = new ArgumentedOption("jeus-ejb-dd", "path", "use jeus-ejb-dd.xml from the specified path");
        this.registerArgument((Argument)this.jeusEjbDDOption);
        this.moduleNameArg = new Argument("module_name", "module to deploy");
        this.absolutePathOption = new ArgumentedOption("absolute-path", "path", "deploy application located at the absolute path");
        this.nameDeployOption = new ArgumentedOption("n", "application_name", "deploy application registered in JEUSMain.xml");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.absolutePathOption, this.nameDeployOption, this.moduleNameArg}));
        this.asOption = new ArgumentedOption("as", "application_name", "name for application", "use module name as the appilcation name", false);
        this.registerArgument((Argument)this.asOption);
    }

    public DistributeCommand(String containerConnected) {
        this();
        this.containerName = containerConnected;
    }

    public void run(PrintStream out) throws Exception {
        int fastDeploy = -1;
        int isKeepGenerated = -1;
        long autoDeployInterval = 0L;
        boolean useAliasNameWhenDeploy = false;
        String classloading = null;
        String absolutePath = null;
        String aliaseName = null;
        String classFtpUnit = null;
        String[] containers = null;
        boolean isNodeSet = false;
        String node = this.jeusMainNode;
        String contextGroup = null;
        String virtualHostList = null;
        String ejbDDPath = null;
        String ejbJarPath = null;
        String deployName = null;
        if (this.containerName != null) {
            this.conOption.setValue(this.containerName);
        }
        String moduleName = null;
        if (this.moduleNameArg.isSet()) {
            moduleName = this.moduleNameArg.getValue();
        } else if (this.absolutePathOption.isSet()) {
            absolutePath = this.absolutePathOption.getValue();
        } else if (this.nameDeployOption.isSet()) {
            useAliasNameWhenDeploy = true;
            aliaseName = this.nameDeployOption.getValue();
        } else {
            throw new JeusImproperCommanderException("deploy or distribute command needs one of module name, absolute path and name registered in JEUSMain.xml");
        }
        if (this.asOption.isSet()) {
            deployName = this.asOption.getValue();
        }
        if (this.conOption.isSet()) {
            String containerName = this.conOption.getValue();
            if (!this.isContainerInNode(containerName) || !this.isContainerRunning(containerName)) {
                out.println(containerName + " is not container in the node " + this.nodeName + " or is not running");
                return;
            }
            containers = new String[]{this.conOption.getValue()};
            node = StringUtil.getNodeNameFromContainerName((String)containers[0]);
        } else if (this.nodeOption.isSet()) {
            isNodeSet = true;
            node = this.nodeOption.getValue();
        } else {
            containers = Command.getListProperty((String)"container.name");
        }
        if (this.contextGroupOption.isSet()) {
            contextGroup = this.contextGroupOption.getValue();
        }
        if (this.virtualHostOption.isSet()) {
            virtualHostList = this.virtualHostOption.getValue();
        }
        if (this.fastDeployOption.isSet()) {
            fastDeploy = 1;
        } else if (this.notFastDeployOption.isSet()) {
            fastDeploy = 0;
        }
        if (this.keepOption.isSet()) {
            isKeepGenerated = 1;
        } else if (this.notKeepOption.isSet()) {
            isKeepGenerated = 0;
        }
        boolean permanent = this.permanentOption.isSet();
        if (this.classloadingOption.isSet()) {
            classloading = this.classloadingOption.getValue();
        }
        boolean writeAppDD = this.writeAppDDOption.isSet();
        if (this.classFtpUnitOption.isSet()) {
            classFtpUnit = this.classFtpUnitOption.getValue();
        }
        if (this.autoOption.isSet()) {
            autoDeployInterval = Integer.parseInt(this.autoOption.getValue());
        }
        if (this.jeusEjbDDOption.isSet()) {
            ejbDDPath = this.jeusEjbDDOption.getValue();
        }
        ApplicationType appType = null;
        J2EEServerMBean[] servers = null;
        String modulePath = null;
        if (useAliasNameWhenDeploy) {
            if (writeAppDD) {
                throw new JeusCommanderException("-wirteAppDD option can not use with -n option");
            }
            if (absolutePath != null) {
                throw new JeusCommanderException("-absolute-path option can not use with -n option");
            }
            if (permanent) {
                throw new JeusCommanderException("-per option can not use with -n option");
            }
            List applicationList = JeusMainDescriptorJB.getJeusMainDescriptor().getApplication();
            for (ApplicationType application : applicationList) {
                if (!aliaseName.equals(JeusDeploymentManager.getApplicationName(application))) continue;
                appType = application;
                break;
            }
            if (appType == null) {
                for (ApplicationType application : applicationList) {
                    String name;
                    if (JeusDeploymentManager.getApplicationName(application) != null || !aliaseName.equals(name = StringUtil.getFileNameFromPathExceptExtension((String)JeusDeploymentManager.getApplicationPath(application)))) continue;
                    appType = application;
                    break;
                }
                if (appType == null) {
                    throw new JeusImproperCommanderException("The given name does not exist in JEUSMain.xml : " + aliaseName);
                }
            }
            modulePath = FileUtils.getFileNameWithExtension((String)JeusDeploymentManager.getApplicationPath(appType));
        }
        if (useAliasNameWhenDeploy && !isNodeSet && (containers == null || containers.length == 0)) {
            List targets = appType.getDeploymentTarget().getAllTargetsOrTarget();
            for (int j = 0; j < targets.size(); ++j) {
                Object target = targets.get(j);
                if (target instanceof AppTargetType) {
                    AppTargetType t = (AppTargetType)target;
                    String containerName = t.getEngineContainerName();
                    String nodeName = t.getNodeName();
                    if (containerName != null) {
                        containers = new String[]{containerName};
                        node = StringUtil.getNodeNameFromContainerName((String)containers[0]);
                        servers = new J2EEServerMBean[]{this.getJ2EEServerMBean(containers[0])};
                        continue;
                    }
                    node = nodeName;
                    servers = this.getJ2EEServerMBeans(node);
                    continue;
                }
                if (!(target instanceof AllTargetsType)) continue;
                servers = this.getJ2EEServerMBeans(null);
            }
        } else {
            servers = containers != null && containers.length == 1 ? new J2EEServerMBean[]{this.getJ2EEServerMBean(containers[0])} : (isNodeSet ? this.getJ2EEServerMBeans(node) : JeusGroup.getCachedJ2EEServerMBeans());
        }
        if (servers == null || servers.length == 0) {
            throw new JeusImproperCommanderException("There is no container");
        }
        J2EEServerMBean serverWithAppDD = servers[0];
        if (!useAliasNameWhenDeploy) {
            if (absolutePath != null) {
                absolutePath = FileUtils.getAbsolutePath((String)absolutePath);
                moduleName = FileUtils.separatePath((String)absolutePath)[1];
            }
            J2EEServerMBean representiveServer = servers[0];
            if (absolutePath == null) {
                String realModuleName = representiveServer.getRealModuleName(moduleName);
                if (realModuleName == null) {
                    throw new JeusImproperCommanderException("There is no application for the name " + moduleName);
                }
                moduleName = realModuleName;
            }
            modulePath = moduleName;
            ModuleType type = serverWithAppDD.getModuleType(absolutePath, moduleName).getModuleType();
            appType = this.getAppDDFromServer(serverWithAppDD, modulePath, absolutePath);
            if (appType == null) {
                appType = this.makeAppForServerDeploy(serverWithAppDD, modulePath, type, moduleName, absolutePath);
            }
            if (appType.getNameAndPathAndDeploymentType() == null || appType.getNameAndPathAndDeploymentType().isEmpty()) {
                String moduleNameToSet = FileUtils.getFileNameWithoutExtension((String)modulePath);
                String modulePathToSet = absolutePath != null ? absolutePath : modulePath;
                JeusDeploymentManager.setApplicationName(appType, moduleNameToSet);
                JeusDeploymentManager.setApplicationPath(appType, modulePathToSet);
                ObjectFactory objFact = new ObjectFactory();
                List appList = appType.getNameAndPathAndDeploymentType();
                if (type.equals(ModuleType.EAR)) {
                    appList.add(objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"EAR")));
                } else {
                    appList.add(objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"COMPONENT")));
                    if (type.equals(ModuleType.EJB)) {
                        appList.add(objFact.createApplicationTypeEjbComponent(objFact.createEjbComponentType()));
                    } else if (type.equals(ModuleType.WAR)) {
                        appList.add(objFact.createApplicationTypeWebComponent(objFact.createWebComponentType()));
                    } else if (type.equals(ModuleType.CAR)) {
                        appList.add(objFact.createApplicationTypeClientComponent(objFact.createClientComponentType()));
                    } else if (type.equals(ModuleType.RAR)) {
                        appList.add(objFact.createApplicationTypeConnectorComponent(objFact.createConnectorComponentType()));
                    }
                }
            }
            if (deployName != null) {
                JeusDeploymentManager.setApplicationName(appType, deployName);
            }
        }
        if (classloading != null) {
            appType.setClassloading(ClassloadingType.valueOf((String)classloading));
        }
        if (autoDeployInterval > 0L) {
            if (appType.getAutoDeploy() == null) {
                ObjectFactory jeusMainFactory = new ObjectFactory();
                AutoDeployType autodeploy = jeusMainFactory.createAutoDeployType();
                autodeploy.setAutoDeployCheckInterval(Long.valueOf(autoDeployInterval));
                appType.setAutoDeploy(autodeploy);
            } else {
                appType.getAutoDeploy().setAutoDeployCheckInterval(Long.valueOf(autoDeployInterval));
            }
        }
        if (absolutePath != null) {
            JeusDeploymentManager.setApplicationPath(appType, absolutePath);
            appType.getInfoMap().put("absolute-path", absolutePath);
        }
        if (classFtpUnit != null) {
            appType.setClassFtpUnit(ClassFtpUnitType.valueOf((String)classFtpUnit));
        }
        if (fastDeploy >= 0) {
            if (fastDeploy > 0) {
                appType.setFastDeploy(Boolean.valueOf(true));
            } else {
                appType.setFastDeploy(Boolean.valueOf(false));
            }
        }
        if (isKeepGenerated >= 0) {
            if (isKeepGenerated > 0) {
                appType.setKeepGenerated(Boolean.valueOf(true));
            } else {
                appType.setKeepGenerated(Boolean.valueOf(false));
            }
        }
        List appList = appType.getNameAndPathAndDeploymentType();
        for (int i = 0; i < appList.size(); ++i) {
            JAXBElement element = (JAXBElement)appList.get(i);
            Object obj = element.getValue();
            if (!(obj instanceof EjbComponentType)) continue;
            EjbComponentType ejbComponentType = (EjbComponentType)obj;
            if (ejbDDPath != null) {
                ejbComponentType.setJeusEjbDd(ejbDDPath);
            }
            if (ejbJarPath == null) continue;
            ejbComponentType.setEjbJar(ejbJarPath);
        }
        if (!useAliasNameWhenDeploy || useAliasNameWhenDeploy && (isNodeSet || containers != null && containers.length > 0 || contextGroup != null || virtualHostList != null)) {
            ObjectFactory objectFactory = new ObjectFactory();
            DeploymentTargetType deploymentTarget = this.createDeploymentTargetType(objectFactory, containers, node, contextGroup, virtualHostList);
            appType.setDeploymentTarget(deploymentTarget);
        }
        if (writeAppDD) {
            this.writeAppDD(serverWithAppDD, appType, modulePath, absolutePath);
        }
        out.println("using the following application info : " + StringUtil.lineSeparator + appType.strip2());
        Target[] targets = new Target[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            J2EEServerMBean server = servers[i];
            ObjectName objectName = server.getObjectName();
            targets[i] = new TargetImpl(objectName);
        }
        JeusProgressObject po = new JeusProgressObject();
        commander.distribute(targets, appType, this.utility, po, false);
        TargetModuleID[] successIDs = po.getResultTargetModuleIDs();
        if (successIDs == null || successIDs.length != targets.length) {
            Exception message = ((DeploymentStatusImpl)po.getDeploymentStatus()).getFailException();
            if (message != null) {
                message.printStackTrace();
            }
            po = new JeusProgressObject();
            commander.undeploy(successIDs, this.utility, po);
            throw new JeusImproperCommanderException(JeusMessage_Manager._386, useAliasNameWhenDeploy ? aliaseName : moduleName, (Throwable)message);
        }
        if (!this.onlyDistribute) {
            po = new JeusProgressObject(po);
            commander.start(successIDs, this.utility, po);
            TargetModuleID[] startSuccessIDs = po.getResultTargetModuleIDs();
            if (startSuccessIDs == null || startSuccessIDs.length != successIDs.length) {
                Exception message = ((DeploymentStatusImpl)po.getDeploymentStatus()).getFailException();
                po = new JeusProgressObject();
                commander.undeploy(successIDs, this.utility, po);
                throw new JeusImproperCommanderException(JeusMessage_Manager._386, useAliasNameWhenDeploy ? aliaseName : moduleName, (Throwable)message);
            }
        }
        for (int i = 0; i < successIDs.length; ++i) {
            ObjectName moduleObjectName = new ObjectName(successIDs[i].getModuleID());
            out.println("The " + moduleObjectName.getKeyProperty("j2eeType") + ", " + moduleObjectName.getKeyProperty("name") + ", is " + (this.onlyDistribute ? "distribute " : "deployed ") + "on " + moduleObjectName.getKeyProperty("J2EEServer"));
        }
        if (permanent) {
            JEUSManagerMBean jeusManager = this.getJeusManagerMoMBean();
            jeusManager.removeApplicationType(JeusDeploymentManager.getNameFromPath(appType));
            jeusManager.addApplicationType(appType);
        }
    }

    private ApplicationType getAppDDFromServer(J2EEServerMBean server, String modulePath, String absolutePath) throws IOException, JAXBException {
        String path = absolutePath != null ? absolutePath : modulePath;
        String appDD = server.getModuleDescriptor(path, "META-INF/jeus-application-dd.xml");
        if (appDD != null) {
            return (ApplicationType)new ApplicationRuntimeDDFile().getDeploymentDescriptor(appDD);
        }
        return null;
    }

    private ApplicationType makeAppForServerDeploy(J2EEServerMBean server, String modulePath, ModuleType type, String moduleName, String absolutePath) throws IOException, JAXBException {
        String path;
        String appDD;
        jeus.xml.binding.j2ee.ApplicationType appType = null;
        if (type.equals(ModuleType.EAR) && (appDD = server.getModuleDescriptor(path = absolutePath != null ? absolutePath : modulePath, "META-INF/application.xml")) != null) {
            appType = (jeus.xml.binding.j2ee.ApplicationType)new ApplicationDeploymentDescriptorFile().getDeploymentDescriptor(appDD);
        }
        String moduleFullPath = absolutePath != null ? absolutePath : JeusProperties.JEUS_APP_HOME + File.separator + moduleName;
        return JeusDeploymentManager.fillApplicationDDFromModuleType(type, moduleFullPath, appType, null);
    }

    private DeploymentTargetType createDeploymentTargetType(ObjectFactory objectFactory, String[] containers, String node, String contextGroup, String virtualHostList) {
        DeploymentTargetType target = objectFactory.createDeploymentTargetType();
        WebContextGroupType cgType = this.createContextGroupType(contextGroup, objectFactory, virtualHostList);
        if ((containers == null || containers.length == 0) && node == null) {
            AllTargetsType allTargetType = objectFactory.createAllTargetsType();
            allTargetType.setWebContextGroup(cgType);
            target.getAllTargetsOrTarget().add(allTargetType);
        } else if (containers == null || containers.length == 0) {
            AppTargetType t = objectFactory.createAppTargetType();
            t.setNodeName(node);
            t.setWebContextGroup(cgType);
            target.getAllTargetsOrTarget().add(t);
        } else {
            for (String containerName : containers) {
                AppTargetType t = objectFactory.createAppTargetType();
                t.setEngineContainerName(containerName);
                t.setWebContextGroup(cgType);
                target.getAllTargetsOrTarget().add(t);
            }
        }
        return target;
    }

    private void writeAppDD(J2EEServerMBean server, ApplicationType appType, String modulePath, String absolutePath) throws IOException, JAXBException {
        String path = absolutePath != null ? absolutePath : modulePath;
        String desc = new ApplicationDeploymentDescriptorFile().marshalDescriptor(appType);
        server.setModuleDescriptor(path, "META-INF/jeus-application-dd.xml", desc);
    }

    private WebContextGroupType createContextGroupType(String contextGroup, ObjectFactory objectFactory, String virtualHostList) {
        WebContextGroupType cgType = null;
        if (contextGroup != null) {
            cgType = objectFactory.createWebContextGroupType();
            cgType.setName(contextGroup);
            if (virtualHostList != null) {
                StringTokenizer stk = new StringTokenizer(virtualHostList, ";");
                while (stk.hasMoreTokens()) {
                    String virtualHost = stk.nextToken();
                    cgType.getVirtualHostName().add(virtualHost);
                }
            }
        }
        return cgType;
    }
}

