/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.Vector;
import jeus.util.console.AbstractConsole;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.command.NodeControllerCommand;

public class DownCommand
extends NodeControllerCommand {
    private Option exitOption = new Option("e", "perform jeusexit after down", true);
    private Option immediateOption;
    private Option allOption;
    private BufferedReader input;

    public DownCommand(String nodeName, BufferedReader input, String realNodeName) {
        super("down", "down the JEUS Manager", nodeName, realNodeName);
        this.registerArgument((Argument)this.exitOption);
        this.immediateOption = new Option("i", "down immediately without confirm", true);
        this.registerArgument((Argument)this.immediateOption);
        this.allOption = new Option("all", "down all JEUS Manager clustered", true);
        this.registerArgument((Argument)this.allOption);
        this.input = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PrintStream out) throws Exception {
        if (!this.openConnection(out)) {
            return;
        }
        try {
            String[] answer = new String[1];
            if (!this.immediateOption.isSet()) {
                while ((answer = AbstractConsole.getCommandStrings((BufferedReader)this.input, (String)"Do you really want to down whole JEUS? (y : n):")) == null || answer.length == 0) {
                }
            } else {
                answer[0] = "y";
            }
            if (answer[0].equalsIgnoreCase("y")) {
                if (this.allOption.isSet()) {
                    int i;
                    Vector v = this.stub.downall();
                    for (i = 0; i < v.size(); ++i) {
                        out.println(v.get(i) + " down successful");
                    }
                    if (this.exitOption.isSet()) {
                        v = this.stub.exitall();
                        for (i = 0; i < v.size(); ++i) {
                            out.println(v.get(i) + " jeusexit successful");
                        }
                    }
                } else if (this.stub.down()) {
                    out.println(this.nodeName + " down successful");
                    if (this.exitOption.isSet()) {
                        if (this.stub.exit()) {
                            out.println(this.nodeName + " jeusexit successful");
                        } else {
                            out.println(this.nodeName + "down failed");
                        }
                    }
                } else {
                    out.println(this.nodeName + "down failed");
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }
}

