/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Vector;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Example;
import jeus.util.console.OptionalArgument;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;

public class DownConCommand
extends JeusMBeanCommand {
    private ArgumentedOption nodeOption = new ArgumentedOption("node", "node_name", "down all engine containers in this node");
    private OptionalArgument conOption = new OptionalArgument("container_name", "engine container name to down", "down all engine containers in the JEUS Manager");

    public DownConCommand() {
        super("downcon", "down engine container");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.nodeOption, this.conOption}));
        this.registerExample(new Example("downcon martin_container1", "down martin_container1 container"));
        this.registerExample(new Example("downcon -node martin", "down all containers in the martin node"));
    }

    public void run(PrintStream out) throws Exception {
        boolean isAll = false;
        String node = this.nodeName;
        String[] containerNames = null;
        ContainerManagerServiceMBean containerManager = this.getContainerManagerService(this.nodeName);
        if (this.nodeOption.isSet()) {
            isAll = true;
            node = this.nodeOption.getValue();
        } else {
            containerNames = this.conOption.isSet() ? new String[]{this.conOption.getValue()} : DownConCommand.getListProperty((String)"container.name");
        }
        if (containerNames == null) {
            isAll = true;
        }
        Vector allConlist = containerManager.getAllContainerList(this.nodeName);
        Vector bootedConList = containerManager.getContainerList(this.nodeName);
        Vector downConList = (Vector)allConlist.clone();
        downConList.removeAll(bootedConList);
        if (isAll) {
            containerManager = this.getContainerManagerService(node);
            if (containerManager.downAllContainers()) {
                out.println("all containers in the node " + node + " are down successfully");
            } else {
                int i;
                out.println("all containers in the node " + this.nodeName + " are down successfully");
                out.println("\t" + downConList.toString().substring(1, downConList.toString().length() - 1) + (downConList.size() == 1 ? " container is" : " containers are") + " already down");
                Vector failedConList = containerManager.getContainerList(this.nodeName);
                Vector downNowConList = (Vector)bootedConList.clone();
                downNowConList.removeAll(failedConList);
                for (i = 0; i < downNowConList.size(); ++i) {
                    out.println("\t" + downNowConList.get(i) + " container is down successfully");
                }
                for (i = 0; i < failedConList.size(); ++i) {
                    out.println("\t" + failedConList.get(i) + " container is down to start");
                }
            }
        } else {
            StringBuffer succeededContainerNames = new StringBuffer();
            for (String containerName : containerNames) {
                if (downConList.contains(containerName)) {
                    out.println(containerName + " container is already down");
                    continue;
                }
                if (!containerManager.downContainer(node, containerName)) continue;
                if (succeededContainerNames.length() > 1) {
                    succeededContainerNames.append(", ");
                }
                succeededContainerNames.append(containerName);
            }
            if (succeededContainerNames.length() > 0) {
                out.println(succeededContainerNames.toString() + (succeededContainerNames.indexOf(",") > 0 ? " containers are" : " container is") + " down successfully");
            }
        }
    }
}

