/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJBMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class EJBModuleInfoCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where ejb module is deployed", "use container.name property or all EJB Modules deployed in all containers");
    private Option regularExpressionOption;
    private Option beanRegularExpressionOption;
    private OptionalArgument moduleNameArg;
    private ArgumentedOption intervalOption;
    private ArgumentedOption repeatOption;
    private OptionalArgument beanNameArg;

    public EJBModuleInfoCommand() {
        this("moduleinfo", "get EJB module information");
    }

    protected EJBModuleInfoCommand(String name, String comment) {
        super(name, comment);
        this.registerArgument((Argument)this.conOption);
        this.regularExpressionOption = new Option("r", "regard module name as regular expression");
        this.registerArgument((Argument)this.regularExpressionOption);
        this.beanRegularExpressionOption = new Option("rb", "regard bean name as regular expression");
        this.registerArgument((Argument)this.beanRegularExpressionOption);
        this.intervalOption = new ArgumentedOption("i", "interval");
        this.registerArgument((Argument)this.intervalOption);
        this.repeatOption = new ArgumentedOption("k", "repeat_number");
        this.registerArgument((Argument)this.repeatOption);
        this.moduleNameArg = new OptionalArgument("module_name", "module name", "show all modules");
        this.registerArgument((Argument)this.moduleNameArg);
        this.beanNameArg = new OptionalArgument("bean_name", "bean name", "show all beans in the module");
        this.registerArgument((Argument)this.beanNameArg);
    }

    public void run(PrintStream out) throws Exception {
        ObjectName[] ejbModuleObjectNames;
        String containerName = null;
        if (this.conOption.isSet()) {
            containerName = this.conOption.getValue();
            ejbModuleObjectNames = JMXUtility.queryJ2EEDeployedApplications(this.utility, this.nodeName, containerName, "EJBModule", null);
        } else {
            String[] containerNames = EJBModuleInfoCommand.getListProperty((String)"container.name");
            if (containerNames != null) {
                int containerCount = containerNames.length;
                ArrayList deployedEJBModulesInAllCountainer = new ArrayList();
                ArrayList<Object> deployedEJBModulesInACountainer = new ArrayList();
                for (int i = 0; i < containerCount; ++i) {
                    deployedEJBModulesInACountainer = JMXUtility.queryJ2EEDeployedApplicationList(this.utility, this.nodeName, containerNames[i], "EJBModule", null);
                    deployedEJBModulesInAllCountainer.addAll(deployedEJBModulesInACountainer);
                }
                ejbModuleObjectNames = deployedEJBModulesInAllCountainer.toArray(new ObjectName[deployedEJBModulesInAllCountainer.size()]);
            } else {
                ejbModuleObjectNames = JMXUtility.queryJ2EEDeployedApplications(this.utility, this.nodeName, null, "EJBModule", null);
            }
        }
        boolean isRegEx = this.regularExpressionOption.isSet();
        if (!this.intervalOption.isSet() && !this.repeatOption.isSet()) {
            if (!this.moduleNameArg.isSet()) {
                if (ejbModuleObjectNames.length == 0) {
                    out.println("no EJB module");
                } else {
                    this.printModuleInfo(ejbModuleObjectNames, out);
                }
            } else {
                String moduleName = this.moduleNameArg.getValue();
                if (moduleName != null && !moduleName.equals("")) {
                    ejbModuleObjectNames = EJBModuleInfoCommand.getMatchedString(moduleName, ejbModuleObjectNames, isRegEx);
                }
                if (ejbModuleObjectNames.length == 0) {
                    out.println("there is no module corresponding to the request");
                } else {
                    this.printModuleInfo(ejbModuleObjectNames, out);
                }
            }
        } else {
            int interval = Integer.parseInt(this.intervalOption.getValue());
            int count = Integer.parseInt(this.repeatOption.getValue());
            for (int i = 0; i < count; ++i) {
                String moduleName;
                if (this.moduleNameArg.isSet() && (moduleName = this.moduleNameArg.getValue()) != null && !moduleName.equals("")) {
                    ejbModuleObjectNames = EJBModuleInfoCommand.getMatchedString(moduleName, ejbModuleObjectNames, isRegEx);
                }
                if (ejbModuleObjectNames.length == 0) {
                    out.println("there is no module corresponding to the request");
                    continue;
                }
                out.println("[" + logformat.format(new Date()) + "]");
                this.printModuleInfo(ejbModuleObjectNames, out);
                if (i >= count - 1) continue;
                try {
                    Thread.sleep(interval * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private void printModuleInfo(ObjectName[] ejbModuleObjectNames, PrintStream out) throws IOException, IllegalJeusSystemNameException {
        String[] modules = JMXUtility.getNameStringArray(ejbModuleObjectNames);
        String localContainerName = null;
        for (int i = 0; i < modules.length; ++i) {
            out.println("module-name : " + modules[i]);
            localContainerName = ejbModuleObjectNames[i].getKeyProperty("J2EEServer");
            if (this.beanNameArg.isSet()) {
                String[] beans = JMXUtility.getNameStringArray(JMXUtility.queryEJBNames(this.utility, localContainerName, modules[i], null));
                beans = EJBModuleInfoCommand.getMatchedString((String)this.beanNameArg.getValue(), (String[])beans, (boolean)this.beanRegularExpressionOption.isSet());
                if (beans.length == 0) {
                    out.println("there is no module corresponding to the request");
                }
                for (int k = 0; k < beans.length; ++k) {
                    this.printStatistics(modules[i], beans[k], out, localContainerName);
                }
            } else {
                this.printStatistics(modules[i], null, out, localContainerName);
            }
            out.println("==================================");
        }
    }

    private void printStatistics(String moduleName, String beanName, PrintStream out, String containerName) throws IOException, IllegalJeusSystemNameException {
        EJBMBean[] beans = this.getEJBEngineMoMBean(containerName, moduleName, beanName);
        for (int i = 0; i < beans.length; ++i) {
            EJBMBean bean = beans[i];
            out.println("bean : " + bean.getObjectName().getKeyProperty("name"));
            Stats beanStats = bean.getstats();
            Statistic[] statistics = beanStats.getStatistics();
            for (int j = 0; j < statistics.length; ++j) {
                out.println(statistics[j].toString());
            }
        }
    }
}

