/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.naming.NameNotFoundException;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.util.console.Argument;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JeusGroup;

public class EngListCommand
extends JeusMBeanCommand {
    private OptionalArgument containerName = new OptionalArgument("container_name", "the container name which contains engines", "all engines in the JEUS Manager");

    public EngListCommand() {
        super("englist", "list engines in the JEUS Manager");
        this.registerArgument((Argument)this.containerName);
    }

    public void run(PrintStream out) throws Exception {
        J2EEServerMBean[] j2EEServerMBeans;
        if (this.containerName.isSet()) {
            if (!this.isContainerInNode(this.containerName.getValue())) {
                out.println(this.containerName.getValue() + " is not container in the node " + this.nodeName);
                return;
            }
            if (!this.isContainerRunning(this.containerName.getValue())) {
                out.println(this.containerName.getValue() + " is not running");
                return;
            }
            j2EEServerMBeans = new J2EEServerMBean[]{this.getJ2EEServerMBean(this.containerName.getValue())};
        } else {
            j2EEServerMBeans = JeusGroup.getCachedJ2EEServerMBeans();
        }
        this.printEngineList(j2EEServerMBeans, out);
    }

    private void printEngineList(J2EEServerMBean[] j2eeServerMBeans, PrintStream out) {
        int serverSize = j2eeServerMBeans.length;
        for (J2EEServerMBean server : j2eeServerMBeans) {
            block4: {
                try {
                    String conName = server.getObjectName().getKeyProperty("name");
                    if (j2eeServerMBeans.length > 1) {
                        out.println("========================================");
                        out.println("engines in the container " + conName);
                    }
                    EngListCommand.printNameValues(out, server.getEngines());
                }
                catch (Throwable t) {
                    if (--serverSize > 0) continue;
                    if (!(t.getCause() instanceof NameNotFoundException)) break block4;
                    out.println("there is no running engine in the node " + this.nodeName);
                    return;
                }
            }
            if (j2eeServerMBeans.length <= 1) continue;
            out.println("========================================");
        }
    }
}

