/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.management.JMXUtility;
import jeus.management.j2ee.jdbc.JDBCConnectionInfoMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.JeusMBeanCommand;

public class JDBCConInfoCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container in which JDBC Datasource is located ", "use container.name");
    private ArgumentedOption intervalOption;
    private ArgumentedOption repeatOption;
    private Argument exportNameArg;
    private final Argument connIdOption;
    private static String infoMenu = "state | usecount | state time(sec) | type";
    private static String line1 = "================================================================================";
    private static String line2 = "--------------------------------------------------------------------------------";

    public JDBCConInfoCommand() {
        super("dsconinfo", "show JDBC DataSource Connection information");
        this.registerArgument((Argument)this.conOption);
        this.intervalOption = new ArgumentedOption("i", "interval");
        this.registerArgument((Argument)this.intervalOption);
        this.repeatOption = new ArgumentedOption("k", "repeat_number");
        this.registerArgument((Argument)this.repeatOption);
        this.connIdOption = new ArgumentedOption("id", "the connection identifier of a connection");
        this.registerArgument(this.connIdOption);
        this.exportNameArg = new Argument("export_name", "export name of DataSource");
        this.registerArgument(this.exportNameArg);
    }

    public void run(PrintStream out) throws Exception {
        String[] containerNames = this.conOption.isSet() ? new String[]{this.conOption.getValue()} : JDBCConInfoCommand.getListProperty((String)"container.name");
        if (containerNames == null || containerNames.length == 0) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command with container.name");
        }
        if (this.connIdOption.isSet()) {
            PooledConnectionInfo[][] infoList = this.getPooledConnectionInfoArray(this.exportNameArg.getValue(), containerNames);
            int i = 0;
            PooledConnectionInfo[][] arr$ = infoList;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PooledConnectionInfo[] infos;
                for (PooledConnectionInfo info : infos = arr$[i$]) {
                    if (!info.getConnectionId().equals(this.connIdOption.getValue())) continue;
                    this.dumpPooledConnectionInfo(info, this.exportNameArg.getValue(), out, containerNames[i]);
                    break;
                }
                ++i;
            }
        } else if (!this.intervalOption.isSet() && !this.repeatOption.isSet()) {
            PooledConnectionInfo[][] infoList = this.getPooledConnectionInfoArray(this.exportNameArg.getValue(), containerNames);
            for (int i = 0; i < containerNames.length; ++i) {
                this.dumpPooledConnectionInfoList(infoList[i], this.exportNameArg.getValue(), out, containerNames[i]);
            }
        } else {
            int interval = Integer.parseInt(this.intervalOption.getValue());
            int count = Integer.parseInt(this.repeatOption.getValue());
            for (int i = 0; i < count; ++i) {
                PooledConnectionInfo[][] infoList = this.getPooledConnectionInfoArray(this.exportNameArg.getValue(), containerNames);
                for (int j = 0; j < containerNames.length; ++j) {
                    this.dumpPooledConnectionInfoList(infoList[j], this.exportNameArg.getValue(), out, containerNames[j]);
                    if (i >= count - 1) continue;
                    this.waitForSeconds(interval);
                }
            }
        }
    }

    private PooledConnectionInfo[][] getPooledConnectionInfoArray(String cpname, String[] containerNames) throws IOException, IllegalJeusSystemNameException {
        PooledConnectionInfo[][] infoList = new PooledConnectionInfo[containerNames.length][];
        int i = 0;
        for (String containerName : containerNames) {
            JDBCConnectionInfoMBean connectionInfo = JMXUtility.getProxy(this.utility, JMXUtility.queryJDBCConnectionInfo(this.utility, containerName, cpname), JDBCConnectionInfoMBean.class, false);
            PooledConnectionInfo[] pooledConnectionInfoInACountainer = connectionInfo.getPooledConnectionInfo();
            infoList[i++] = pooledConnectionInfoInACountainer;
        }
        return infoList;
    }

    private String makeInfoString(PooledConnectionInfo info) {
        String state = info.isActive() ? "active" : "idle";
        int useCount = info.getUseCount();
        double time = (System.currentTimeMillis() - info.getStateChangedTime()) / 1000L;
        String disposable = info.isDisposable() ? "disposable" : "pooled";
        return JDBCConInfoCommand.printFixSize((String)(state + " "), (int)8) + JDBCConInfoCommand.printFixSize((String)(useCount + " "), (int)11) + JDBCConInfoCommand.printFixSize((String)(time + " "), (int)18) + disposable;
    }

    private void dumpPooledConnectionInfoList(PooledConnectionInfo[] infos, String cpname, PrintStream out, String containerName) {
        out.println(line1);
        out.println("Connection information list for " + cpname + " of " + containerName);
        out.println(line2);
        out.println("id                    | " + infoMenu);
        out.println(line2);
        if (infos != null) {
            for (PooledConnectionInfo info : infos) {
                String id = info.getConnectionId();
                String infoString = this.makeInfoString(info);
                out.println(JDBCConInfoCommand.printFixSize((String)(id + " "), (int)24) + infoString);
            }
        }
        out.println(line1);
    }

    private void dumpPooledConnectionInfo(PooledConnectionInfo info, String cpname, PrintStream out, String containerName) {
        out.println(line1);
        out.println("Connection information for " + info.getConnectionId() + " in " + cpname + " of container " + containerName);
        out.println(line2);
        out.println(infoMenu);
        out.println(line2);
        out.println(this.makeInfoString(info));
        Map traceList = info.getConnectionTraces();
        if (traceList != null && !traceList.isEmpty()) {
            Set keySet = traceList.keySet();
            for (Object aKeySet : keySet) {
                String conId = (String)aKeySet;
                Throwable trace = (Throwable)traceList.get(conId);
                if (trace == null) continue;
                out.println(line2);
                out.println("Stack trace for " + conId + " : ");
                out.println(ConnectionPoolImpl.getConnectionTraceAsString(trace));
                out.println(line2);
            }
        }
        out.println(line1);
    }
}

