/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JDBCGroup;

public class JDBCCreateCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container in which JDBC Datasource is located ", "use container.name");
    private Argument exportNameArg;

    public JDBCCreateCommand() {
        super("createds", "Create the JDBC DataSource");
        this.registerArgument((Argument)this.conOption);
        this.exportNameArg = new Argument("export_name", "JNDI export name of JDBC DataSource");
        this.registerArgument(this.exportNameArg);
    }

    public void run(PrintStream out) throws Exception {
        JDBCResourceMBean[] resourceMBeans = this.conOption.isSet() ? new JDBCResourceMBean[]{this.getJDBCResource(this.conOption.getValue())} : JDBCGroup.getCachedJDBCResourceMBeans();
        if (resourceMBeans == null || resourceMBeans.length == 0) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command with container.name");
        }
        Vector<String> successList = new Vector<String>();
        for (JDBCResourceMBean resourceMBean : resourceMBeans) {
            try {
                resourceMBean.createConnectionPool(this.exportNameArg.getValue());
                successList.add(resourceMBean.getContainerName());
            }
            catch (Exception e) {
                out.println(e.getMessage());
            }
        }
        if (successList.isEmpty()) {
            out.println("Failed to create all connection pool");
        } else {
            if (successList.size() > 1) {
                out.print("Connection pools");
            } else {
                out.print("Connection pool");
            }
            out.print(" of container [");
            Iterator it = successList.iterator();
            String containerName = (String)it.next();
            out.print(containerName);
            while (it.hasNext()) {
                out.print(", ");
                containerName = (String)it.next();
                out.print(containerName);
            }
            if (successList.size() > 1) {
                out.print("] are ");
            } else {
                out.print("] is ");
            }
            out.println("created successfully or already created.");
        }
    }
}

