/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.naming.NameNotFoundException;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.util.JNDIUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Command;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JeusGroup;

public class JndiListCommand
extends JeusMBeanCommand {
    private ArgumentedOption containerName = new ArgumentedOption("con", "container_name", "container to perform lookup");
    private Argument name;
    private Option all;

    public JndiListCommand() {
        super("jndilist", "list binded name in the specified jndi context");
        this.registerArgument((Argument)this.containerName);
        this.all = new Option("a", "list all infomations for the binded object", true);
        this.registerArgument((Argument)this.all);
        this.name = new OptionalArgument("context_name", "the jndi context name", "the root context");
        this.registerArgument(this.name);
    }

    public void run(PrintStream out) throws Exception {
        boolean allInfos = this.all.isSet();
        String jndiName = this.name.isSet() ? this.name.getValue() : "";
        try {
            if (this.containerName.isSet()) {
                if (!this.isContainerRunning(this.containerName.getValue())) {
                    out.println(this.containerName.getValue() + " is not running");
                    return;
                }
                J2EEServerMBean[] j2EEServerMBeans = new J2EEServerMBean[]{this.getJ2EEServerMBean(this.containerName.getValue())};
                String jndiInfo = j2EEServerMBeans[0].getJndiListInfo(jndiName, allInfos);
                this.printJndiInfo(out, jndiInfo, jndiName);
            } else {
                J2EEServerMBean[] j2EEServerMBeans = JeusGroup.getCachedJ2EEServerMBeans();
                if (!Command.isSetProperty() || j2EEServerMBeans == null || j2EEServerMBeans.length == 0) {
                    String jndiInfo = JNDIUtil.getJndiListInfo(jndiName, this.nodeName, allInfos);
                    this.printJndiInfo(out, jndiInfo, jndiName);
                } else {
                    for (J2EEServerMBean server : j2EEServerMBeans) {
                        String jndiInfo = server.getJndiListInfo(jndiName, allInfos);
                        String conName = server.getObjectName().getKeyProperty("name");
                        out.println("================= [JNDI List for " + conName + "] =================");
                        this.printJndiInfo(out, jndiInfo, jndiName);
                    }
                }
            }
        }
        catch (NameNotFoundException ex) {
            out.println("The jndiName " + jndiName + " does not exist");
        }
    }

    private void printJndiInfo(PrintStream out, String jndiInfo, String jndiName) {
        if (jndiInfo != null) {
            out.println(jndiInfo);
        } else {
            out.println("The jndiName " + jndiName + " does not exist");
        }
    }
}

