/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import jeus.server.JeusServerException;
import jeus.util.console.Argument;
import jeus.util.console.Example;
import jeus.util.console.command.FtpCommand;
import jeus.util.console.command.NodeControllerCommand;

public class RftpCommand
extends NodeControllerCommand {
    private Argument source = new Argument("ftpRoot:/source", "the url to get the file in JEUS Manager \n \tftpRoot: jeus (=$JEUS_HOME), web (=$webhome) ");
    private Argument destination;

    public RftpCommand(String nodeName, String realNodeName) {
        super("rftp", "transfer file from the JEUS Manager", nodeName, realNodeName);
        this.registerArgument(this.source);
        this.destination = new Argument("destination", "the local file path to save");
        this.registerArgument(this.destination);
        this.registerExample(new Example("rftp jeus:/temp/b.dat d:\\dir1\\a.dat", "transfer $JEUS_HOME/temp/b.dat of the JEUS Manager node to d:\\dir1\\a.dat in the local node"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PrintStream out) throws Exception {
        String sourcePath = this.source.getValue();
        FtpCommand.checkFtpRoot(sourcePath);
        if (!this.openConnection(out)) {
            return;
        }
        String destinationPath = this.destination.getValue();
        try {
            try {
                this.stub.rftp(sourcePath, destinationPath);
            }
            catch (JeusServerException jse) {
                out.println(jse.getMessage());
                this.closeConnection();
                return;
            }
            out.println(sourcePath + " -> " + destinationPath + " ftp performed");
        }
        finally {
            this.closeConnection();
        }
    }
}

