/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Vector;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.Example;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class StartConCommand
extends JeusMBeanCommand {
    private OptionalArgument conOption = new OptionalArgument("container_name", "the engine container name to start", "start all engine containers in the JEUS Manager");

    public StartConCommand() {
        super("startcon", "start engine container");
        this.registerArgument((Argument)this.conOption);
        this.registerExample(new Example("startcon martin_container1", "start martin_container1 container"));
    }

    public void run(PrintStream out) throws Exception {
        boolean isAll = false;
        String[] containerNames = null;
        ContainerManagerServiceMBean containerManager = this.getContainerManagerService(this.nodeName);
        containerNames = this.conOption.isSet() ? new String[]{this.conOption.getValue()} : StartConCommand.getListProperty((String)"container.name");
        if (containerNames == null) {
            isAll = true;
        }
        Vector allConlist = containerManager.getAllContainerList(this.nodeName);
        Vector bootedConList = containerManager.getContainerList(this.nodeName);
        Vector downedConList = (Vector)allConlist.clone();
        downedConList.removeAll(bootedConList);
        if (isAll) {
            if (containerManager.startAllContainer(this.nodeName)) {
                out.println("all containers in the node " + this.nodeName + " are started successfully");
            } else {
                int i;
                out.println("all containers in the node " + this.nodeName + " are not started successfully");
                out.println("\t" + bootedConList.toString().substring(1, bootedConList.toString().length() - 1) + (bootedConList.size() == 1 ? " container is" : " containers are") + " already started");
                Vector failedConList = (Vector)allConlist.clone();
                Vector bootedNowConList = containerManager.getContainerList(this.nodeName);
                failedConList.removeAll(bootedNowConList);
                bootedNowConList.removeAll(bootedConList);
                for (i = 0; i < bootedNowConList.size(); ++i) {
                    out.println("\t" + bootedNowConList.get(i) + " container is started successfully");
                }
                for (i = 0; i < failedConList.size(); ++i) {
                    out.println("\t" + failedConList.get(i) + " container is failed to start");
                }
            }
        } else {
            StringBuffer succeededContainerNames = new StringBuffer();
            for (String containerName : containerNames) {
                if (bootedConList.contains(containerName)) {
                    out.println(containerName + " container is already started");
                    continue;
                }
                if (!containerManager.startContainer(this.nodeName, containerName)) continue;
                if (succeededContainerNames.length() > 1) {
                    succeededContainerNames.append(", ");
                }
                succeededContainerNames.append(containerName);
            }
            if (succeededContainerNames.length() > 0) {
                out.println(succeededContainerNames.toString() + (succeededContainerNames.indexOf(",") > 0 ? " containers are" : " container is") + " started successfully");
            }
        }
    }
}

