/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.HashMap;
import jeus.management.j2ee.JTAResourceMBean;
import jeus.transaction.TMException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.DefinedValue;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.TMGroup;
import jeus.util.message.JeusMessage_TM;

public class TMResyncCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where transaction manager is located ", "use container.name");
    private Argument resourceTypeArg;
    private static final DefinedValue SQL_TYPE = new DefinedValue("sql", "JDBC XADataSource");
    private static final DefinedValue JMS_TYPE = new DefinedValue("jms", "JMS ConnectionFactory");
    private static final DefinedValue CONNECTOR_TYPE = new DefinedValue("connector", "Connector ResourceAdaptor");
    private Argument exportNameArg;
    private OptionalArgument moduleNameArg;

    public TMResyncCommand() {
        super("tmresync", "recover Resource Manager such as JDBC, JMS and Connector");
        this.registerArgument((Argument)this.conOption);
        this.resourceTypeArg = new Argument("resource_type", "resource type to recover");
        this.resourceTypeArg.setDefinedValues(new DefinedValue[]{SQL_TYPE, JMS_TYPE, CONNECTOR_TYPE}, true);
        this.registerArgument(this.resourceTypeArg);
        this.exportNameArg = new Argument("export_name", "export name of the resource");
        this.registerArgument(this.exportNameArg);
        this.moduleNameArg = new OptionalArgument("connector_module_name", "connector module name if the resource is connector");
        this.registerArgument((Argument)this.moduleNameArg);
    }

    public void run(PrintStream out) throws Exception {
        HashMap<String, JTAResourceMBean> jtaResourceMBeanMap = null;
        if (this.conOption.isSet()) {
            JTAResourceMBean jtaResourceMBean;
            String containerName = null;
            try {
                containerName = this.conOption.getValue();
                jtaResourceMBean = this.getJTAResource(this.conOption.getValue());
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created. \n");
                return;
            }
            jtaResourceMBeanMap = new HashMap();
            jtaResourceMBeanMap.put(containerName, jtaResourceMBean);
        } else {
            jtaResourceMBeanMap = TMGroup.getCachedJTAResourceMBeanMap();
        }
        if (jtaResourceMBeanMap == null || jtaResourceMBeanMap.isEmpty()) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command");
        }
        for (JTAResourceMBean jtaResourceMBean : jtaResourceMBeanMap.values()) {
            if (this.resourceTypeArg.isDefinedValue(CONNECTOR_TYPE)) {
                jtaResourceMBean.resyncXAResource(TMResyncCommand.getResourceType(this.resourceTypeArg.getValue()), this.exportNameArg.getValue(), this.moduleNameArg.getName());
                continue;
            }
            jtaResourceMBean.resyncXAResource(TMResyncCommand.getResourceType(this.resourceTypeArg.getValue()), this.exportNameArg.getValue());
        }
    }

    private static int getResourceType(String type) throws TMException {
        if (type.equals("sql")) {
            return 1;
        }
        if (type.equals("jms")) {
            return 2;
        }
        if (type.equals("connector")) {
            return 3;
        }
        throw new TMException(JeusMessage_TM.TM_209, type);
    }
}

