/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;
import jeus.management.j2ee.JTAResourceMBean;
import jeus.management.j2ee.transaction.IncompletedTransactionInfo;
import jeus.management.j2ee.transaction.TransactionInfo;
import jeus.management.j2ee.transaction.XAResourceInfo;
import jeus.transaction.util.XidToString;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.CountRepeater;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OnceRepeater;
import jeus.util.console.Option;
import jeus.util.console.Repeater;
import jeus.util.console.TimeRepeater;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.TMGroup;

public class TXListCommand
extends JeusMBeanCommand {
    private PrintStream out;
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where transaction manager is located", "use container.name property or apply to all containers");
    private Option inflight = new Option("inflight", "inflight state transaction information");
    private Option indoubt = new Option("indoubt", "indoubt state transaction information");
    private Option retrying = new Option("retrying", "retrying state transaction information");
    private ArgumentedOption repeatInterval = new ArgumentedOption("i", "sec", "set the interval of monitoring");
    private ArgumentedOption repeatCount = new ArgumentedOption("k", "number", "set the repeat count");
    private ArgumentedOption repeatTime = new ArgumentedOption("l", "sec", "set the repeat time");
    private Repeater repeater;

    public TXListCommand() {
        super("txlist", "report various kinds of transactions");
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)this.inflight);
        this.registerArgument((Argument)this.indoubt);
        this.registerArgument((Argument)this.retrying);
        this.registerArgument((Argument)this.repeatInterval);
        this.registerArgument((Argument)this.repeatCount);
        this.registerArgument((Argument)this.repeatTime);
    }

    public void run(PrintStream out) throws Exception {
        String containerName;
        JTAResourceMBean jtaResourceMBean;
        HashMap<String, JTAResourceMBean> jtaResourceMBeans = null;
        if (this.conOption.isSet()) {
            jtaResourceMBean = null;
            containerName = null;
            try {
                containerName = this.conOption.getValue();
                jtaResourceMBean = this.getJTAResource(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            jtaResourceMBeans = new HashMap();
            jtaResourceMBeans.put(containerName, jtaResourceMBean);
        } else {
            jtaResourceMBeans = TMGroup.getCachedJTAResourceMBeanMap();
        }
        if (jtaResourceMBeans == null || jtaResourceMBeans.isEmpty()) {
            throw new JeusImproperCommanderException("There is no running transaction manager.");
        }
        this.out = out;
        this.selectRepeater();
        while (this.repeater.isRepeatable()) {
            jtaResourceMBean = null;
            containerName = null;
            for (Map.Entry<String, JTAResourceMBean> jtaResourceMBeanPerContainer : jtaResourceMBeans.entrySet()) {
                jtaResourceMBean = jtaResourceMBeanPerContainer.getValue();
                containerName = jtaResourceMBeanPerContainer.getKey();
                this.execTransactionListCommand(containerName, jtaResourceMBean);
            }
        }
    }

    private void selectRepeater() {
        int interval = 0;
        int time = 0;
        int count = 0;
        if (this.repeatInterval.getValue() != null) {
            interval = Integer.parseInt(this.repeatInterval.getValue());
        }
        if (this.repeatTime.getValue() != null) {
            time = Integer.parseInt(this.repeatTime.getValue());
        }
        if (this.repeatCount.getValue() != null) {
            count = Integer.parseInt(this.repeatCount.getValue());
        }
        this.repeater = interval > 0 ? (count > 0 ? new CountRepeater(count, interval, this.out) : (time > 0 ? new TimeRepeater(time, interval, this.out) : new OnceRepeater())) : new OnceRepeater();
        this.repeater.reset();
    }

    private void execTransactionListCommand(String containerName, JTAResourceMBean jtaResourceMBean) throws Exception {
        boolean all = false;
        if (!(this.inflight.isSet() || this.indoubt.isSet() || this.retrying.isSet())) {
            all = true;
        }
        this.out.println("< ContainerName : " + containerName + " >");
        if (all || this.inflight.isSet()) {
            this.statInflight(jtaResourceMBean);
        }
        if (all || this.indoubt.isSet()) {
            this.statIndoubt(jtaResourceMBean);
        }
        if (all || this.retrying.isSet()) {
            this.statRetrying(jtaResourceMBean);
        }
    }

    private void statInflight(JTAResourceMBean jtaResourceMBean) {
        this.out.println("* in-flight transaction information *");
        TransactionInfo[] infos = jtaResourceMBean.getTransactionInfos();
        if (infos == null || infos.length == 0) {
            this.out.println("no information");
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            Xid xid = infos[i].getXid();
            String xidString = "";
            if (xid != null) {
                xidString = XidToString.getXidHexString(xid);
            }
            Xid externalXid = infos[i].getExternalXid();
            String externalXidString = "";
            if (externalXid != null) {
                externalXidString = XidToString.getXidHexString(externalXid);
            }
            String[] xaResources = infos[i].getXaResources();
            String xaResourcesInfo = "";
            if (xaResources != null) {
                for (int j = 0; j < xaResources.length; ++j) {
                    xaResourcesInfo = xaResourcesInfo + xaResources[j];
                    if (j == xaResources.length - 1) continue;
                    xaResourcesInfo = xaResourcesInfo + ",";
                }
            }
            this.out.println("    XID:" + xidString + "    coordinator:" + infos[i].getCoordinator() + "    externalXID:" + externalXidString + "    status:" + infos[i].getStatus() + "    timeout:" + infos[i].getTimeout() + "(ms)" + "    elapse:" + infos[i].getElapseSinceBegin() + "(ms)" + "    XAResources:" + xaResourcesInfo);
            this.out.println("");
        }
    }

    private void statIndoubt(JTAResourceMBean jtaResourceMBean) {
        this.out.println("* in-doubt transaction information *");
        IncompletedTransactionInfo[] infos = jtaResourceMBean.getIncompletedTransactionInfos();
        if (infos == null || infos.length == 0) {
            this.out.println("no information");
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            Xid xid = infos[i].getXid();
            String xidString = "";
            if (xid != null) {
                xidString = XidToString.getXidHexString(xid);
            }
            Xid externalXid = infos[i].getExternalXid();
            String externalXidString = "";
            if (externalXid != null) {
                externalXidString = XidToString.getXidHexString(externalXid);
            }
            Xid[] childXids = infos[i].getChildXids();
            String childXidsInfo = "";
            if (childXids != null) {
                for (int j = 0; j < childXids.length; ++j) {
                    childXidsInfo = childXidsInfo + XidToString.getXidHexString(childXids[j]);
                    if (j == childXids.length - 1) continue;
                    childXidsInfo = childXidsInfo + ",";
                }
            }
            this.out.println("    XID:" + xidString + "    coordinator:" + infos[i].getCoordinator() + "    externalXID:" + externalXidString + "    status:" + infos[i].getStatus() + "    decision:" + infos[i].getDecision() + "    sub-XID:" + childXidsInfo);
            this.out.println("");
        }
    }

    private void statRetrying(JTAResourceMBean jtaResourceMBean) {
        this.out.println("* retrying transaction information *");
        XAResourceInfo[] infos = jtaResourceMBean.getRetryingXAResourceInfos();
        if (infos == null || infos.length == 0) {
            this.out.println("no information");
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            Xid xid = infos[i].getXid();
            String xidString = "";
            if (xid != null) {
                xidString = XidToString.getXidHexString(xid);
            }
            this.out.println("    XID:" + xidString + "    name:" + infos[i].getName() + "    failcount:" + infos[i].getFailCount() + "    status:" + infos[i].getStatus() + "    decision:" + infos[i].getDecision());
            this.out.println("");
        }
    }
}

