/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import jeus.deploy.JeusDeploymentManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEDeployedObjectMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.util.JeusRuntimeException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.command.ApplicationCommand;
import jeus.util.message.JeusMessage_JMX;
import jeus.xml.binding.jeusDD.ApplicationType;

public class UndeployCommand
extends ApplicationCommand {
    private Option permanentOption;
    private Option forcedOption;
    private ArgumentedOption gracefulTimeoutOption;
    protected Option allOption;
    private String containerName;

    public UndeployCommand() {
        super("undeploy", "undeploy application");
    }

    protected UndeployCommand(String name, String comment) {
        super(name, comment);
    }

    public UndeployCommand(String containerConnected) {
        this();
        this.containerName = containerConnected;
    }

    protected void addAdditionalOptions() {
        this.permanentOption = new Option("per", "remove application setting from JEUSMain.xml");
        this.registerArgument((Argument)this.permanentOption);
        this.forcedOption = new Option("forced", "undeploy even if the application is a system application");
        this.registerArgument((Argument)this.forcedOption);
        this.gracefulTimeoutOption = new ArgumentedOption("gracetimeout", "time(second)", "graceful timeout");
        this.registerArgument((Argument)this.gracefulTimeoutOption);
        this.allOption = new Option("a", "undeploy all applications in the containers of the JEUS Manager");
        this.registerArgument((Argument)this.allOption);
    }

    public void run(PrintStream out) throws Exception {
        this.undeploy(out);
    }

    protected List undeploy(PrintStream out) throws Exception {
        if (this.isAll() && !this.allOption.isSet()) {
            throw new JeusImproperCommanderException("The module name or application name cannot be empty without -a option");
        }
        if (this.containerName != null) {
            this.conOption.setValue(this.containerName);
        }
        boolean permanent = this.permanentOption.isSet();
        boolean forced = this.forcedOption.isSet();
        int gracefulTimeout = -1;
        if (this.gracefulTimeoutOption.isSet()) {
            try {
                gracefulTimeout = Integer.parseInt(this.gracefulTimeoutOption.getValue());
            }
            catch (NumberFormatException e) {
                throw new JeusImproperCommanderException("\"" + this.gracefulTimeoutOption.getValue() + "\" is not valid integer parameter");
            }
        }
        ObjectName[] moduleObjectNames = new ObjectName[]{};
        try {
            moduleObjectNames = this.getJ2EEDeployedObjects();
        }
        catch (IllegalArgumentException iae) {
            out.println(iae.getMessage());
        }
        catch (Exception ex) {
            throw new JeusImproperCommanderException((Throwable)ex);
        }
        ArrayList<Object[]> filePaths = new ArrayList<Object[]>();
        for (int i = 0; i < moduleObjectNames.length; ++i) {
            ObjectName moduleObjectName = moduleObjectNames[i];
            J2EEDeployedObjectMBean mbean = JMXUtility.getProxy(this.utility, moduleObjectName, J2EEDeployedObjectMBean.class, false);
            try {
                ApplicationType appType = mbean.getApplicationType();
                if ((forced || !mbean.getSystemApp()) && appType != null) {
                    String absolutePath = (String)appType.getInfoMap().get("absolute-path");
                    if (absolutePath != null) {
                        JeusDeploymentManager.setApplicationPath(appType, absolutePath);
                        filePaths.add(new Object[]{moduleObjectName, appType});
                    } else if (JeusDeploymentManager.getApplicationPath(appType) != null) {
                        filePaths.add(new Object[]{moduleObjectName, appType});
                    }
                }
                long start = System.currentTimeMillis();
                out.println("Undeploying " + moduleObjectName.getKeyProperty("j2eeType") + " [" + moduleObjectName.getKeyProperty("name") + "] from " + moduleObjectName.getKeyProperty("J2EEServer") + " (This may take time due to graceful undeployment)");
                if (forced) {
                    mbean.undeploy(forced);
                } else if (gracefulTimeout >= 0) {
                    mbean.undeploy(gracefulTimeout);
                } else {
                    mbean.undeploy();
                }
                long time = System.currentTimeMillis() - start;
                out.println(moduleObjectName.getKeyProperty("j2eeType") + " [" + moduleObjectName.getKeyProperty("name") + "] is undeployed from " + moduleObjectName.getKeyProperty("J2EEServer") + " (elapsed = " + time + "ms)");
                continue;
            }
            catch (Exception e) {
                Throwable ex;
                if (e instanceof RuntimeMBeanException && (ex = e.getCause()) instanceof JeusRuntimeException && ((JeusRuntimeException)ex).getMessageNumber() == JeusMessage_JMX._83) {
                    out.println("module " + moduleObjectName.getKeyProperty("name") + " is a system application, skip");
                    continue;
                }
                out.println("fail to undeploy the module " + moduleObjectName.getKeyProperty("name"));
            }
        }
        if (permanent) {
            JEUSManagerMBean jeusManager = this.getJeusManagerMoMBean();
            String[] names = JMXUtility.getNameStringArray(moduleObjectNames);
            jeusManager.removeApplicationType(names);
        }
        return filePaths;
    }
}

